//	Encapsulates the MapiRecipDesc structure

////////////////////////////////////////////////////////////////////////
#ifndef __GCSMAPIRECIPIENT_H__
#define __GCSMAPIRECIPIENT_H__

#pragma once

#include "GCSDllExt.h"

#include <mapi.h>
#include "GCSMapiex.h"


class CLASS_DECL_GCS CGCSMapiRecipient : public CObject
{
DECLARE_SERIAL( CGCSMapiRecipient );

   	friend class CGCSMapiMessage;   // needs access to private functions;
   	friend class CGCSMapi;
    
// Data members -------------------------------------------------------------
public:
	
protected:
    
private:
		lpMapiRecipDesc m_pMapiRecipDesc;			
		lpMapiRecipDesc m_pPosition;
		ULONG 		    m_ulRecipCount;

// Member functions ---------------------------------------------------------
public:
	CGCSMapiRecipient();
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object
	//				It will initialize the internal state
    
	CGCSMapiRecipient( lpMapiRecipDesc pMapiRecip, DWORD dwCount );	
	// --- In  : pMapiRecip : pointer to arry of mapirecipients
	//			 dwCount : the number of recipients poited to by pMapiRecip
	// --- Out : 
	// --- Returns :
	// --- Effect : Contructor of object
	//				It will initialize the internal state

	CGCSMapiRecipient( CGCSMapiRecipient& b );
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : Copy constructor Can throw a CGCSMapiException
	//				It will initialize the internal state

    void Flush();
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : frees all memory associated with this object.
			
	DWORD GetSize() const;
	// --- In  : 
	// --- Out : 
	// --- Returns :
	// --- Effect : Gets the size of array of structures contained in this object
	
	DWORD CreatePointer( WORD wSize );
	// --- In  : wSize : required size of one mapirecipdesc
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_ALREADY_THERE, or MEMORY_ERROR_ON_NEW
	// --- Effect : allocates memory for array of mapirecipdesc structures of wSize
	//				and sets contents to NULL
			
	DWORD SetPosition( DWORD dwPos );
	// --- In  : dwPos : the position the user wants to set. Each mapirecipdesc has a 
	//					 zero based index.
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE, or NOT_VALID_POSITION
	// --- Effect : sets the postion for all other member functions	by the use of an
	//				internal pointer.
								
	inline DWORD GetRecipClass()
	// --- In  : 
	// --- Out : 
	// --- Returns : the class of the Mapi Recipient
	// --- Effect : gets the class for the mapifiledesc currently selected within this object
	//				See MAPI doco for more info
		{	
		ASSERT_VALID( this );
		ASSERT( m_pMapiRecipDesc != NULL );
		return ( (DWORD)m_pPosition->ulRecipClass );
		}


	DWORD SetRecipClass( DWORD dwNewRecipClass );
	// --- In  : 
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS, POINTER_NOT_THERE, or NOT_VALID_POSITION
	// --- Effect : sets the class of the Mapi Recipient for the mapifiledesc currently selected
	//				within this object :
	//				See MAPI doco for more info.
				
	CString GetName();
	// --- In  : 
	// --- Out : 
	// --- Returns : the name of the recipient
	// --- Effect : gets name of the recipient of the currently positioned mapifile struct
	//				can throw a CGCSMapiException. See MAPI doco for more info
		
	DWORD SetName( CString NewName );
	// --- In  : NewName : the new name of the recipient
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : sets the name of the currently positioned recipient	struct
	//				See MAPI doco for more info
	 	
	CString GetAddress();
	// --- In  : 
	// --- Out : 
	// --- Returns : the address of the recipient
	// --- Effect : gets address of the recipient of the currently positioned mapifile struct
	//				can throw a CGCSMapiException. See MAPI doco for more info
	
	DWORD SetAddress( CString NewAddress );
	// --- In  : NewAddress : the new address of the recipient
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : sets the address of the currently positioned recipient	struct
	//				See MAPI doco for more info

	DWORD SetEntryID ( LPVOID pEntryID, WORD wEIDSize );
	// --- In  : pEntryID : the new EntryID of the recipient
	//			 wEIDSize : the size of the pointer
	// --- Out : 
	// --- Returns : SUCCESS_SUCCESS or POINTER_NOT_THERE
	// --- Effect : copies the contents of pEntryID into the currently positioned recipient object
	//				See MAPI doco for more info
	
	virtual void Serialize( CArchive& ar );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : read or writes a CGCSMapiRecipient object to disk
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapiException
	
	CGCSMapiRecipient& operator=( CGCSMapiRecipient& b );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : assignment operator
	//				May throw a CGCSMapiException
	
	CGCSMapiRecipient& operator+=( CGCSMapiRecipient& b );
	// --- In  : 
	// --- Out : 
	// --- Returns : the concatenation of the source and parameter
	// --- Effect : concatenation operator
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapiException
	
	CGCSMapiRecipient& operator[]( DWORD d );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : array operator.
	//				May throw a CGCSMapiException.
	
	friend CArchive& AFXAPI operator <<( CArchive& ar, CGCSMapiRecipient& recip );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : piping operator to disk
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapiException

    friend CArchive& AFXAPI operator >>( CArchive& ar, CGCSMapiRecipient& recip );
	// --- In  : 
	// --- Out : 
	// --- Returns : 
	// --- Effect : piping operator from disk
	//				may throw a CMemoryException, CArchiveException, CFileException, CGCSMapiException
	        
#ifdef _DEBUG
	virtual void Dump(CDumpContext&) const;
	virtual void AssertValid() const;
#endif //_DEBUG

	virtual ~CGCSMapiRecipient();
	// --- In  :
	// --- Out : 
	// --- Returns :
	// --- Effect : Destructor of object

protected:      

private:
	// Helper functions;
	lpMapiRecipDesc GetPointer();

	DWORD CopyFromPointer( lpMapiRecipDesc pMapiRecip, DWORD dwCount );
		
};

CArchive& AFXAPI operator <<( CArchive& ar, CGCSMapiRecipient& recip );
CArchive& AFXAPI operator >>( CArchive& ar, CGCSMapiRecipient& recip );

#endif
