
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Dotlist

- object:anObject
{
    object = anObject;
    dots = [Fablist new];return self;
}

+ object:anObject
{
    return [[super new] object:anObject];
}

- add:anObject
{
    [dots add:anObject];return self;
}

- paragraphs:aCltn
{
  int i,n;
  id text;
  static id style,dotitem,dotbegin,dotend;

  if (!dotitem) {
    style = [TextStyle named:"Doc"];
    dotbegin = [TextStyle named:"Dotbegin"];
    dotitem = [TextStyle named:"Dotitem"];
    dotend = [TextStyle named:"Dotend"];
  }

  text = [object asText];
  [aCltn add:[Paragraph withText:text style:style]]; 

  text = [Text new];
  [aCltn add:[Paragraph withText:text style:dotbegin]]; 

  for(i=0,n=[dots size];i<n;i++) {
    text = [[dots at:i] asText];
    [aCltn add:[Paragraph withText:text style:dotitem]]; 
  }

  text = [Text new];
  [aCltn add:[Paragraph withText:text style:dotend]]; 

  return aCltn;
}

@end

