
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Fablist

- substitute
{
    int i;
    int n = [self size];
    id res = [isa new:n + 1];
    for(i=0;i<n;i++) [res add:[[self at:i] substitute]];
    return res;
}

- include
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] include];
    return self;
}

- makepublicsummary
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] makepublicsummary];
    return self;
}

- print:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] print:f];
    return self;
}

- dumpheader:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] dumpheader:f];
    return self;
}

- dumppublicheader:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] dumppublicheader:f];
    return self;
}

- dumpsource:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] dumpsource:f];
    return self;
}

- dumppublicsource:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] dumppublicsource:f];
    return self;
}

- dumpdepend:(FILE *)f
{
    int i;
    int n = [self size];
    for(i=0;i<n;i++) [[self at:i] dumpdepend:f];
    return self;
}

- asText
{
  id text = [Text new];
  int i,n = [self size];
  for(i=0;i<n;i++) [[self at:i] asText:text];
  return text;
}

- nameAsText
{
  id text = [Text new];
  int i,n = [self size];
  for(i=0;i<n;i++) [[self at:i] nameAsText:text];
  return text;
}

- asText:text
{
  int i,n = [self size];
  for(i=0;i<n;i++) [[self at:i] asText:text];
  return text;
}

- paragraphs:aCltn
{
  int i,n = [self size];
  for(i=0;i<n;i++) [[self at:i] paragraphs:aCltn];
  return aCltn;
}

- allparagraphs:aCltn
{
  int i,n = [self size];
  for(i=0;i<n;i++) [[self at:i] allparagraphs:aCltn];
  return aCltn;
}

@end

