
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"
#include "Textanchor.h"
#include "Textlink.h"

/******************************************************************************
 *
 * Method 
 * 
 *****************************************************************************/

@implementation Method

- type:t atoms:list 
{
    static int count = 0;
    anchor = count++; /* stes - 8/97 - idea is to have links inside doc */
    type = t;atoms = list;
    return self;
}

+ type:t atoms:list {return [[super new] type:t atoms:list];}

- makepublicsummary
{
    if (flags.public && fabMethodType) [fabMethodType add:self];
    return self;
}

- print:(FILE *)f
{
    fprintf(f,(isclass)?"+":"-");
    /* note the space before parenthese */
    if (type) { fprintf(f," (");[type print:f];fprintf(f,")"); }
    [atoms print:f];
    return self;
}

- setisclass:(BOOL)flag { isclass = flag;return self; }

- dumpsource:(FILE *)f
{
    if (fabtestmode) {
	if (flags.test) {[self print:f];fprintf(f,"\n");}
	return self;
    } else {
	[self print:f];fprintf(f,"\n");return self;
    }
}

- dumpheader:(FILE *)f
{
    if (!fabtestmode) { [self print:f];fprintf(f,";\n"); }
    return self;
}

- asText
{
  id text;
  text = [Text str:((isclass)?"+":"-")];
  if (type) {
    [[text string] concatSTR:" ("];
    [type asText:text];
    [[text string] concatSTR:")"];
  }
  [atoms asText:text];
  return text;
}

- nameAsText
{
  return [atoms nameAsText];
}

- asSummaryText
{
  id text = [self nameAsText];
  [text addAttribute:[Textlink to:anchor]];
  return text;
}

- paragraphs:aCltn
{
  id text;
  static id namestyle,protostyle;

  if (!namestyle) namestyle = [TextStyle named:"Methodname"];
  if (!protostyle) protostyle = [TextStyle named:"Methodproto"];

  /* proto without +/- on single line */
  text = [self nameAsText];
  [text addAttribute:[Textanchor to:anchor]];
  [aCltn add:[Paragraph withText:text style:namestyle]];

  /* blockquote */
  [aCltn add:[Paragraph withText:[self asText] style:protostyle]];

  return aCltn;
}

@end

