
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Methodtype

+ object:anObject
{
    self = [super object:anObject];return self;
}

- add:anObject   { [methods add:anObject];return self; }

- makepublicsummary
{
    if (flags.public && fabmethodsummary) [fabmethodsummary add:self];
    methods = [Fablist new];return fabMethodType = self;
}

- dumpheader:(FILE *)f
{
    fprintf(f,"\n");return self;
}

- dumpsource:(FILE *)f
{
    fprintf(f,"\n");return self;
}

- summaryparagraphs:aCltn
{
  int i;
  id text;
  static id title;
  static id dotitem,dotbegin,dotend;

  if (!dotitem) {
    title = [TextStyle named:"Subsubtitle"];
    dotbegin = [TextStyle named:"Dotbegin"];
    dotitem = [TextStyle named:"Dotitem"];
    dotend = [TextStyle named:"Dotend"];
  }

  text = [Text str:[object str]];
  [text allBold];
  [aCltn add:[Paragraph withText:text style:title]];

  [aCltn add:[Paragraph withText:[Text new] style:dotbegin]];
  for(i=0;i<[methods size];i++) {
    text = [[methods at:i] asSummaryText];
    [aCltn add:[Paragraph withText:text style:dotitem]];
  }
  [aCltn add:[Paragraph withText:[Text new] style:dotend]];

  return aCltn;
}

@end

