
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Unit 

- name:(STR)string:(STR)root
{
    extern id yyres;
    extern int yyparse();
    extern int yyconnect(STR file);

    yyconnect(string);
    if (yyparse()) exit(1);
    list = yyres;
    /* stpstn's +self returns (SHR), so typecast to id for -isKindOf: */
    assert([list isKindOf:(id)[Fablist self]]);
    
    /* now we parse the included files
     * this could be done at the point that we encounter includes
     * but this is easier to program
     */
    [list include];filename = string;rootname = root;
    
    return self;
}

+ name:(STR)string:(STR)root
{
    return [[super new] name:string:root];
}

- dumpheader:(FILE *)f
{
    return [list dumpheader:f];
}

- dumpsource:(FILE *)f
{
    return [list dumpsource:f];
}

- dumppublicheader:(FILE *)f
{
    return [list dumppublicheader:f];
}

- dumppublicsource:(FILE *)f
{
    return [list dumppublicsource:f];
}

- dumpdepend:(FILE *)f
{
    return [list dumpdepend:f];
}

- paragraphs:aCltn
{
  [list makepublicsummary];
  return [list allparagraphs:aCltn];
}

@end

