
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

char *umsg = "Usage : fab file ... [-option dir]\n";

void fabusage()
{
   fprintf(stderr,umsg);exit(1);
}

#define strEq(x,y) (strcmp(x,y) == 0)

void main(int argc,STR *argv)
{
    int i;
    fab = [Fabricator new];	/* global fabricator object */
    
    if (argc == 1) fabusage();
    
    for(i=1;i<argc;i++) {
	STR arg = argv[i];
	if (strEq(arg,"-I"))     {
	    if ((arg = argv[++i])) [fab addsearchpath:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-h"))     {
	    if ((arg = argv[++i])) [fab setheaderdir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-H"))     {
	    if ((arg = argv[++i])) [fab setpublicheaderdir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-m"))     {
	    if ((arg = argv[++i])) [fab setsourcedir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-M"))     {
	    if ((arg = argv[++i])) [fab setpublicsourcedir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-man"))   {
	    if ((arg = argv[++i])) [fab setmandir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-html"))  {
	    if ((arg = argv[++i])) [fab sethtmldir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-ascii"))  {
	    if ((arg = argv[++i])) [fab setasciidir:arg];
	    else fabusage();continue;
	}
	if (strEq(arg,"-rtf"))  {
	    if ((arg = argv[++i])) [fab setrtfdir:arg];
	    else fabusage();continue;
	}
	
	[fab addfile:arg];
    }
     
    [fab run];exit(0);
}
