
/*
 * Copyright (C) 1998 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"
#include <runarray.h> 
#include <assert.h> 

static void pheader(void)
{
  /* paperw and paperh in twips (1/20 point) */

  printf("\\rtf1\\ansi{\\fonttbl\\f0\\fnil Times-Roman;\\f1\\fswiss Helvetica;\\f2\\fmodern Courier;} \\paperw16220 \\paperh18640 \\margl40 \\margr40\n");
}

static void pchar(char c)
{
  if (c == '{') {printf("\\{");return;}
  if (c == '}') {printf("\\}");return;}
  if (c == '\n') {printf("\\\n");return;}
  putchar(c);
}

static void opencode(id a)
{
  switch([a emphasiscode]) {
    case ROMAN : break;
    case BOLD    : printf("{\\b ");break;
    case COURIER : printf("{\\f2 ");break;
    case ITALIC  : printf("{\\i ");break;
    case SWISS   : printf("{\\f1 ");break;
    default : break;
  }
}

static void closecode(id a)
{
  switch([a emphasiscode]) {
    case ROMAN   : break;
    case BOLD    : 
    case COURIER :
    case ITALIC  :
    case SWISS   : printf("}");break;
    default : break;
  }
}

static void prtf(id t)
{
  unsigned p = 0;
  char *chars = [t str];
  unsigned size = [t size];
  id runArray = [t runs];

  while (p < size) {
    int i,n;
    id attrs;
    unsigned q;
    attrs = [runArray at:p];
    n = [attrs size];
    q = p + [runArray runLengthAt:p];
    assert(q != p && q <= size);
    for(i=0;i<n;i++) opencode([attrs at:i]);
    for(;p<q;p++) pchar(chars[p]);
    while (n--) closecode([attrs at:n]);
  }
}

static void pcopyright(id t)
{
  int n = 7;
  printf("\\pard\\f0\\fs24\\fc0\\cf0 ");prtf(t);
  printf("\\fs16");while (n--) pchar('\n');
}

static void ptitle(id t)
{
  int n = 6;
  printf("\\f1\\b\\fs56\\li2200 ");prtf(t);
  printf("\\f0\\b0\\fs16");while (n--) pchar('\n');
}

static void pdoc(id t)
{
  printf("\\f0\\fs28\\li2200 ");prtf(t);
  printf("\\fs16\\\n\\\n");
}

static void psubtitle(id t)
{ 
  printf("\\fs16\\\n\\\n");
  printf("\\f1\\b\\fs36\\li1400 ");prtf(t);
  printf("\\b0\\f0\\fs16\\\n\\\n");
}

static void pdotbegin(id t)
{
  /* set tab at 6000 twips */
  printf("\\pard\\tx6000\\fs28\\fi-3800\\li6000\\fc0\\cf0\n");
}

static void psubsubtitle(id t)
{
  pdotbegin(t);
  prtf(t);
  printf("\n");
}

static void pdot(id t)
{
  /* uses tab set before */
  printf("\t- ");prtf(t);pchar('\n');
}

static void pdotend(id t)
{
  printf("\\pard\\fs16\\\n\\\n"); /* get rid of tabsetting */
}

static void pmethodname(id t)
{
  printf("\\fs16\\\n\\\n");
  printf("\\f1\\b\\fs28\\li2200 ");
  prtf(t);
  printf("\\f0\\b0\\\n");
}

static void pmethodproto(id t)
{
  printf("\\f0\\fs28\\li2500 ");
  prtf(t);
  printf("\\fs16\\\n\\\n");
}

static void pexample(id t)
{
  printf("\\f2\\fs24\\li2800 ");
  prtf(t);
  printf("\\f0\\fs16\\\n");
}

static void pnote(id t)
{
  printf("\\f0\\fs28\\li2200 ");prtf(t);
  printf("\\fs16\\\n\\\n");
}

void writertf(id paragraphs)
{
  int i,n = [paragraphs size];

  printf("{");pheader();

  for(i=0;i<n;i++) {
    id p = [paragraphs at:i];
    char *style = [[p textStyle] name];
    id t = [p text];
    assert(style != NULL && style != NULL);
    if (!strcmp(style,"Title")) ptitle(t);
    else if (!strcmp(style,"Subtitle")) psubtitle(t);
    else if (!strcmp(style,"Subsubtitle")) psubsubtitle(t);
    else if (!strcmp(style,"Copyright")) pcopyright(t);
    else if (!strcmp(style,"Dotbegin")) pdotbegin(t); 
    else if (!strcmp(style,"Dotitem")) pdot(t);
    else if (!strcmp(style,"Dotend")) pdotend(t); 
    else if (!strcmp(style,"Methodname")) pmethodname(t);
    else if (!strcmp(style,"Methodproto")) pmethodproto(t);
    else if (!strcmp(style,"Example")) pexample(t);
    else if (!strcmp(style,"Methodname")) psubsubtitle(t);
    else if (!strcmp(style,"Methodproto")) pmethodproto(t);
    else if (!strcmp(style,"Example")) pexample(t);
    else if (!strcmp(style,"Note")) pnote(t);
    else if (!strcmp(style,"Seealso")) pnote(t);
    else if (!strcmp(style,"Doc")) pdoc(t);
    else { prtf(t);pchar('\n'); }
  }

  printf("\\fs16\\\n\\\n\\\n");
  printf("}\n");
}

