// My.cpp : implementation file
// The grid is owner draw so we can get grid-lke lines in it.
// Initially each row is poplated by the text formed in AddOne.
// After that the  ON_WM_DRAWITEM message extracts the
//		text from the control and repaints (e.g. when scrolling).
// All data is owned by the control - no callbacks are used.
// When the user selects a row, the ON_WM_DRAWITEM handler
//		extracts the row number from the lParam loaded when the 
//		row's item data (the left hand position) was loaded - search
//		this file for string "trick" to see how it is done.
//

#include "stdafx.h"
#include "list.h"
#include "My.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMy dialog


CMy::CMy(CWnd* pParent /*=NULL*/)
	: CDialog(CMy::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy)
	m_unLots = 200;
	m_sHowMany = _T("");
	m_sRowSel = _T("");
	//}}AFX_DATA_INIT
}


void CMy::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy)
	DDX_Control(pDX, IDC_LIST1, m_cMy);
	DDX_Text(pDX, IDC_EDIT1, m_unLots);
	DDV_MinMaxUInt(pDX, m_unLots, 1, 10000);
	DDX_Text(pDX, IDC_HOWMANY, m_sHowMany);
	DDX_Text(pDX, IDC_ROWSEL, m_sRowSel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMy, CDialog)
	//{{AFX_MSG_MAP(CMy)
	ON_BN_CLICKED(IDC_ADD1, OnAdd1)
	ON_BN_CLICKED(IDC_ADDLOTS, OnAddlots)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_WM_DRAWITEM()
	ON_NOTIFY(NM_OUTOFMEMORY, IDC_LIST1, OnOutofmemoryList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy message handlers

/////////////////////////////////////////////////////////////////////////////
BOOL CMy::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CString s;
	LV_COLUMN lvcol;
	lvcol.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.cx = 80;
	for( int i = 0; i < NUM; i++)
	{
		switch( i )
		{
		case 0:
			s = "Sales";
			break;
		case 1:
			s = "Profit";
			break;
		case 2:
			s = "This";
			break;
		case 3:
			s = "That";
			break;
		case 4:
			s = "The Other";
			break;
		}
		lvcol.pszText = (LPSTR)(const char *)s;
		lvcol.iSubItem = i;
		m_cMy.InsertColumn( i, &lvcol );
	}
	// init member variables
	m_nItem = 0;
	m_unLots = 100;
	m_sHowMany = "No items in list";
	m_sRowSel = "No row selected";
	// send to screen
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
// helper function that does the work of adding a row
void CMy::AddOne() 
{

	// populate the strings	before calling the first entry
	CString sEntries[NUM];
	sEntries[0].Format( "item %d", m_nItem);
	for( int i = 1; i < NUM; i++)
	{
		sEntries[i].Format( "subitem %d", i);
	} 

	// form the list control structure
	LV_ITEM lvitem;
	lvitem.mask = LVIF_TEXT | LVIF_PARAM;

	// this is the trick! load the 0-index row number into the helper parameter for the 0th column
	lvitem.lParam = m_nItem;
	// point to the row number
	lvitem.iItem = m_nItem;	  
	lvitem.pszText = (LPSTR)(const char *)sEntries[0]; 
	// must be zero for the 0th column
	lvitem.iSubItem = 0;
	// do the insert
	int ret = m_cMy.InsertItem( &lvitem ); 
	// a check
	ASSERT( ret != -1 );

	// now populate the subitems
	for( i = 1; i < NUM; i++)
	{
		BOOL b = m_cMy.SetItemText( m_nItem, i, (LPTSTR)(const char *)sEntries[i] );
		ASSERT(b);
	} 

	// bump the row counter
	m_nItem++;
}

/////////////////////////////////////////////////////////////////////////////
// button handler
void CMy::OnAdd1() 
{
	// pre-adjust allocation - faster
	m_cMy.SetItemCount( 1 + m_cMy.GetItemCount());
	// call helper
	AddOne();	
	m_sHowMany.Format("Number of items in list is %d", m_nItem);
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// button handler
void CMy::OnAddlots() 
{
	BeginWaitCursor();
	// may take a while so tell user
	UpdateData(TRUE);
	m_sHowMany = "Working...";
	UpdateData(FALSE);

	// pre-adjust allocation - faster
	m_cMy.SetItemCount( (int)m_unLots + m_cMy.GetItemCount());

	// m_unLots is from dialog edit box
	for( int i = 0; i < (int)m_unLots; i++)
	{
		AddOne();
	}
	m_sHowMany.Format("Number of items in list is %d", m_nItem);
	UpdateData(FALSE);
	EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
void CMy::OnDelete() 
{
	BeginWaitCursor();
	// may take a while so tell user
	m_sHowMany = "Working...";
	UpdateData(FALSE);
	// delete items and update text
	m_cMy.DeleteAllItems();

	// reset state variable and strings
	m_nItem = 0;
	m_sHowMany = "No items in list";
	m_sRowSel = "No row selected";

	UpdateData(FALSE);
	EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
void CMy::OnOutofmemoryList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// a check
	AfxMessageBox("Out of memory");
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
void CMy::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
		// Create a temporary CDC object.

	CHeaderCtrl * pHdr = (CHeaderCtrl *)m_cMy.GetDlgItem(0);
	if( pHdr == NULL )
	{
		ASSERT(0);
		return;
	}

	CDC* pDC = CDC::FromHandle( lpDrawItemStruct->hDC );

	if( lpDrawItemStruct->itemAction & (ODA_DRAWENTIRE | ODA_SELECT) )
	{ 	
		COLORREF crOldText;     // never permanently alter the original CDC attributes
		COLORREF crOldBack;   // never permanently alter the original CDC attributes

		// If the item is selected then highlight the item.	
		if( lpDrawItemStruct->itemState & ODS_SELECTED )
		{
			crOldText = pDC->SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT) );
			crOldBack = pDC->SetBkColor(::GetSysColor(COLOR_HIGHLIGHT) );

			// this is the trick! we always know the row number of the selection (the one with highlight)
			// remember this row for later and update box text
			// this code is kinda redundant (dw *is* lpDrawItemStruct->itemData)
			DWORD dw = m_cMy.GetItemData(lpDrawItemStruct->itemData); 
			m_sRowSel.Format("You selected row %d", (int)dw);
			UpdateData(FALSE);
		}

	   	// Erase the entire area. Using ExtTextOut is a neat alternative to FillRect and quicker, too!
		pDC->ExtTextOut( lpDrawItemStruct->rcItem.left,
							  lpDrawItemStruct->rcItem.top,
							  ETO_OPAQUE, &(lpDrawItemStruct->rcItem),"", 0, NULL );              

		// do some setup
		CString s;
		int x, y;
		x = lpDrawItemStruct->rcItem.left;
		y =lpDrawItemStruct->rcItem.top;

		HD_ITEM hditem;
		hditem.mask = HDI_WIDTH;
		/// why -1?
		pDC->MoveTo( lpDrawItemStruct->rcItem.left, lpDrawItemStruct->rcItem.bottom-1 ); 
		// -2 is probably a text metric (frame?)
		pDC->LineTo( lpDrawItemStruct->rcItem.right-2, lpDrawItemStruct->rcItem.bottom -1);

		for( int i = 0; i < NUM; i++)
		{
			s = m_cMy.GetItemText(lpDrawItemStruct->itemData, i);

			// paint text 
			pDC->TextOut(  x+2, y, s, s.GetLength()  );

			// bump to next column based on header's tab stops
			pHdr->GetItem( i, &hditem);
			x += hditem.cxy;

			// 2 is probably a text metric (frame?)
			pDC->MoveTo( x-2, lpDrawItemStruct->rcItem.bottom ); 
			pDC->LineTo( x-2, lpDrawItemStruct->rcItem.top );
		}

		// Draw the focus state.
		if( lpDrawItemStruct->itemState & ODA_FOCUS )
		{
			pDC->DrawFocusRect( &(lpDrawItemStruct->rcItem) );  
		}

		// Return the device context to its original state.
		if( lpDrawItemStruct->itemState & ODS_SELECTED )
		{
			pDC->SetTextColor( crOldText );
			pDC->SetBkColor( crOldBack );
		}

	} // end of if on	ODA_DRAWENTIRE | ODA_SELECT

   	if( lpDrawItemStruct->itemAction & ODA_FOCUS )
	{
		pDC->DrawFocusRect( &(lpDrawItemStruct->rcItem) );
	}

	//CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

//////////// reference below here

/*typedef struct tagDRAWITEMSTRUCT {
    UINT   CtlType;
    UINT   CtlID;
    UINT   itemID;
    UINT   itemAction;
    UINT   itemState;
    HWND   hwndItem;
    HDC    hDC;
    RECT   rcItem;
    DWORD  itemData;
} DRAWITEMSTRUCT; */

/*typedef struct _HD_ITEM 
{
    UINT    mask;
    int     cxy;         // width or height of item
    LPSTR   pszText;     // address of item string
    HBITMAP hbm;         // handle of item bitmap
    int     cchTextMax;  // length of item string, in characters
    int     fmt;
    LPARAM  lParam;      // application-defined item data
} HD_ITEM; */

