/** \file CON_Console.h
    Main control structure.  Points to all devices. 

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
class Console;

#ifndef H_CON_CONSOLE
#define H_CON_CONSOLE

#include <CON_3D.h>
#include <CON_Sound.h>
#include <CON_Input.h>

/** This is the main console class.  A single object of this class will exist,
    and will be passed as a parameter to the main action() routine. */
class Console : public SystemInterface
{
public:
  /** Returns pointer to the mouse object. */
	virtual Mouse*    getMouse() = 0;

  /** Returns pointer to the keyboard object. */
	virtual Keyboard* getKeyboard() = 0 ;

  /** Returns pointer to the screen object. */
	virtual Screen*   getScreen() = 0;

  /** Returns pointer to the 3D Screen object. */
	virtual Screen3D* getScreen3D() = 0;

  /** Returns pointer to the sound object, or NULL if not available. */
  virtual Sound*    getSound() = 0;

  /** Returns pointer to the joystick object, or NULL if not available. */
  virtual Joystick* getJoystick() = 0;

  /** Returns a non-zero value if an error occurred. */
	virtual long      status()=0;
};

/** Call this function to check if a full screen application has been reactivated.
    If true, you must reload all video memory bitmaps. */
int CON_Reactivated();


////////////////////////////////////////////////////////////
// Generic functions.
////////////////////////////////////////////////////////////
#ifndef FUNC_GENERIC
#define FUNC_GENERIC

#ifdef __cplusplus
extern "C" {
#endif

/** Returns the version of the library. */
DLLExport float    getVersion();

#ifdef __cplusplus
}
#endif

/** Returns the Fraction frame time needed for a world's advance. */
DLLExport float    getFrameTime();

/** Returns the Console object pointer. */
DLLExport Console* getConsole();


#endif // FUNC_GENERIC

#endif // H_CON_CONSOLE
