#ifndef H_UTILS
#define H_UTILS

#include <math.h>

#ifndef RELEASEINT
  #define RELEASEINT(x) if ((x)!=NULL) { (x)->release(); (x)=NULL; }
#endif 

#ifndef RELEASE
  #define RELEASE(x) if ((x)!=NULL) { (x)->Release(); (x)=NULL; }
#endif 

#ifndef DELETEOBJ
  #define DELETEOBJ(x)  if ((x)!=NULL) { delete (x); (x)=NULL; }
#endif 

#ifndef DELETEARR
  #define DELETEARR(x)  if ((x)!=NULL) { delete[] (x); (x)=NULL; }
#endif

#ifndef FALSE
  #define FALSE (0)
#endif

#ifndef TRUE
  #define TRUE (!FALSE)
#endif

#undef PI
#undef PITIMES2
#undef PIOVER2
#undef NatE
#undef SQRT2
#undef SQRT3
#undef GOLDEN
#undef DTOR
#undef RTOD

// define basic constants with high precision
#define PI     3.141592653589793238462643383279502884197169399375105820975
#define NatE   2.718281828459045235360287471352662497757247093699959574967
#define SQRT2  1.414213562373095048801688724209698078569671875376948073177
#define SQRT3  1.732050807568877293527446341505872366942805253810380628056
#define GOLDEN 1.618033988749894848204586834365638117720309179805762862135

// define derived constants
#define PITIMES2  (2.0*PI)
#define PIOVER2   (0.5*PI)
#define DTOR      (PI/180.0)
#define RTOD      (180.0/PI)

// macro and constant for base 2 logarithm
#define LN2    0.693147180559945309417232121458176568075500134360255254121
#define LOG2(val) (log(val)*(1.0/LN2))


#define fPI       ((float) PI)
#define fPITIME2  ((float) PITIMES2)
#define fPIOVER2  ((float) PIOVER2)
#define fE        ((float) NatE)
#define fSQRT2    ((float) SQRT2)
#define fSQRT3    ((float) SQRT3)
#define fGOLDEN   ((float) GOLDEN)
#define fDTOR     ((float) DTOR)
#define fRTOD     ((float) RTOD)
#define fLN2      ((float) LN2)
#define fLOG2(val) ((float) (log(val)*(1.0/LN2)))

#ifndef EPSILON
   #define EPSILON 1e-10f
#endif

#ifndef ISZERO
   #define ISZERO(x) (fabs(x) < EPSILON)
#endif

#ifndef ISEQ
   #define ISEQ(x,y) (fabs(x-y) < EPSILON)
#endif


template<class T>
inline T Min(T t1, T t2)
{
  return (t1<t2?t1:t2);
}

template<class T>
inline T Max(T t1, T t2)
{
  return (t1>t2?t1:t2);
}

template<class T>
inline T Abs(T t)
{
  return (t>0?t:-t);
}

template<class T>
inline void Swap(T& t1, T& t2)
{
   T tmp = t1;
   t1 = t2;
   t2 = tmp;
}

#endif 