// =========================================================================
//       LEdit wrapper for Borland OWL 2.5 (16-/32-bit Windows)
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       Version 2.05
//       (c) 1996-1997 AY Software Corporation
//       Nobody can modify this file without written permission of author
//
//       Limitations of current version:
//       Summary length of all editing files: min(ca 60M,your memory)
//       Maximum line length: 8K
//
//       This file containts full definitions and documentation on constants
//       and functions needed to deal with LEdit OWL wrapper
//       !!! Many things have different meaning than in stanard "TEdit" !!!
//       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//       Windows      is a trademark of Microsoft corp.
//
//       If you have some questions please contact:  xor@aysoft.com
// =========================================================================
//
//   Defines TLEdit classes:
//
//
//  TView --------------------|
//                            |---> TLEditView
//                        |---|
//  TWindow ---> TLEdit --|
//                        |-------> TLEditFile
//
//  TWindow ----------------------> TLEditGroup
//
// You may use the following constants to disable some components.
// This will exclude them from LEOWL.H
//
//#define LEDIT_NO_FILE
//#define LEDIT_NO_VIEW
//#define LEDIT_NO_GROUP
//
//  $$$ Make sure WIN32 is defined while compiling apps for 32-bit targets
//
//  When working with these objects you may use ES_* constants for
//  LEdit styles. See them in file LEDIT.H
//
//  File LEDIT.H also contains description of all structures
//  and options very important while using LEdit.
//
//----------------------------------------------------------------------------
// USE THIS LINE TO SHOW BORLAND C++ VERSION (BC40 or BC45)
#define BC45
//----------------------------------------------------------------------------
#if !defined(WIN32)

#if !defined(BI_DATA_FAR) && !defined(__LARGE__)
#error Sorry, LEdit OWL wrapper works with LARGE memory model only
#endif

#else

#if !defined(huge)
#define huge far
#endif
#if !defined(WM_CTLCOLOR)
#define WM_CTLCOLOR WM_CTLCOLOREDIT
#endif
#if !defined(FP_OFF)
#define FP_OFF(ptr) LOWORD((long)ptr)
#endif
#if !defined(FP_SEG)
#define FP_SEG(ptr) HIWORD((long)ptr)
#endif

#endif

#if !defined(OWL_LEDIT_H)
#define OWL_LEDIT_H

#include "ledit.h"

//***** In no cases can you change these definitions
#define SIZE_FILEMASK 255
#define SIZE_SYNTAX 253

//
//  Class TLEditGroup
//  ----- -----------
//
#if !defined(LEDIT_NO_GROUP)
//
// TLEditGroup is destinated to register TLEdit and their descendents
// All LEdit window registered with the same group will be treated as
// one group and will share Find/Replace dialogs and Insert/Overwrite
// status. To register use Attach method of LEdit class.
// See leowl_2 example for datails.
//
class TLEditGroup : public TWindow {
  public:
	 TLEditGroup(TWindow* parent,
					 TModule* module = 0);
  protected:
			//
	 // Override TWindow virtual member functions
	 //
	 virtual char far* GetClassName();

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 TLEditGroup(const TLEditGroup&);
	 TLEditGroup& operator =(const TLEditGroup&);

  DECLARE_STREAMABLE(,TLEditGroup,1);
  DECLARE_RESPONSE_TABLE(TLEditGroup);
};
#endif // TLEditGroup


//
//  class TLEdit
//  ----- ------
//
class TLEdit : public TWindow {
  public:
	 TLEdit(TWindow*        parent,
			  const char far* title,
			  long extraStyle = 0, // Additional styles. See the list in LEDIT.H
			  TModule*        module = 0);

	 TLEdit(TWindow*        parent,
			  int             id,
			  const char far* title,
			  int x = 0, int y = 0, int w = 0, int h = 0,
			  long extraStyle = 0, // Additional styles. See the list in LEDIT.H
			  TModule*        module = 0);

	 TLEdit(TWindow*   parent,
			  int        resourceId,
			  TModule*   module = 0);

    ~TLEdit();

	 //
	 // This data member determines wether Memory DC or actual
	 // LEdit DC will be passed to Paint virtual function
	 // It makes sense only if LEdit has ES_Transparent style
	 //
	 BOOL UseMemoryDC;

	 //
	 // Colors to be used with highlight selection
	 // Initially set to default in constructor
	 //
	 COLORREF BackColorSelected;
	 COLORREF ForeColorSelected;

    //
    // Colors to be used with standard text.
    // You may coose them and then act as in case of EM_CTLCOLOR
    // To do this set ControlColors to TRUE, or otherwise to
	 // FALSE in which case color control will be tracked by
    // your parent
    //
    BOOL ControlColors;
    COLORREF BackColor;
    COLORREF ForeColor;

	 //
	 // LEDITPOSITION Structure to be used in default operations
	 //
	 LEDITPOSITION SelPos;

	 //
	 // WORDDESC Structure to be used when asking for words
	 //
	 WORDDESC WordDesc;

    //
    // This method attaches LEdit to the group object. All objects
    // attached to the same object will constitute group.
    // Make sure not to remove TLEditGroup while one of attached
    // LEdit windows exist. The best way is to make TLEditGroup a
    // child of some real window, so that it'll be deleted automatically.
    // See LEDIT.H for details.
    //
    int Attach(TLEditGroup* group);

	 //
	 // Object to store font data. It automatically maintains font
	 // used in LEdit, so if changed SetFont() must be called.
	 //
	 TFont far* lpFont;

	 //
	 // Sets font using HFONT works only when control exists
	 // It's left here only for compatibility with standards
	 //
	 void SetFont(HFONT font)
		{HandleMessage(WM_SETFONT,(WPARAM) font);}
	 void SetFont(LOGFONT& font)
		{HandleMessage(EM_SETLOGFONT,0,(LPARAM) &font);}
	 void SetFont(TFont& font);
	 void SetFont()
		{SetFont(*lpFont);}

	 //
	 // Sets syntax. May be used at any time. See LEDIT.H for
	 // detailed information. Or alternative form as in VBX
	 // or Delphi VCL wrappers may be used with string supplied
	 // to function.
	 //
	 void SetSyntax(SYNTAX far* syntax, int syntaxLength, int flags = 0);
	 void SetSyntax(char far* syntax, int flags = 0);

	 //******* The following functions constitute syntax parser ***************

	 //
	 // Starts parsing process and move pointer position (PP) to the
	 // beginning of the text
	 //
	 void SetScan()
		{HandleMessage(EM_SETSCAN);}

	 //
	 // Retrieves current word from PP and move PP to the end of it.
	 // Return status of the operation
	 //
	 int GetWord(WORDDESC& wordDesc, BOOL skipLines = TRUE)
		{return LOWORD(HandleMessage(EM_GETWORD,skipLines,(LPARAM) &wordDesc));}
	 int GetWord(BOOL skipLines = TRUE)
		{return GetWord(WordDesc,skipLines);}

	 //
	 // Moves PP to the begin of the next line
	 //
	 int NextLine()
		{return LOWORD(HandleMessage(EM_NEXTLINE));}

	 //
	 // Gets the rest of line from PP to the next of line. Doesn't
	 // move PP.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 int GetRestOfLine(char far* buf)
		{return LOWORD(HandleMessage(EM_GETRESTOFLINE,0,(LPARAM) buf));}
	 char far* GetRestOfLine();


	 //
	 // Retrieves position of last word read by GetWord() or start of
	 // new line set by NewLine()
	 //
	 int GetScan(LEDITPOSITION& Pos)
		{return LOWORD(HandleMessage(EM_GETSCAN,0,(LPARAM) &Pos));}
	 int GetScan()
		{return GetScan(SelPos);}

	 //******* End of syntax parser *****************************************

	 //
	 // Retrieves current word from the caret position.
	 // Return status of the operation
	 //
	 int GetCurrentWord(WORDDESC& wordDesc)
		{return LOWORD(HandleMessage(EM_GETCURRENTWORD,0,(LPARAM) &wordDesc));}
	 int GetCurrentWord()
		{return GetCurrentWord(WordDesc);}

	 //
	 // returns the length of the control's caption
	 //
	 int GetCaptionLen()
		{return ::GetWindowTextLength(HWindow);}

	 //
	 // fills the passed string with the text of the associated
	 // control's caption.  returns the number of characters copied
	 //
	 BOOL GetCaption(char far* str, int maxChars)
		{return (maxChars == EMP_ALLTEXT) ? FALSE :
		 ::GetWindowText(HWindow, str, maxChars);}

	 //
	 // sets the contents of the associated control's caption to
	 // the passed string
	 //
	 void SetCaption(const char far* str)
		{::SetWindowText(HWindow, str);}

	 //
	 // Returns number of lines in LEdit
	 //
	 long GetNumLines()
		{return HandleMessage(EM_EX_GETLINECOUNT);}

	 //
	 // Returns the length of specified line
	 //
	 long GetLineLength(long lineNumber)
		{return HandleMessage(EM_EX_LINELENGTH,0,lineNumber);}

	 //
	 // Returns specified line. Buffer str must be large enough.
	 // Returns the length of the line.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 long GetLine(char far* str, long lineNumber);
	 char far* GetLine(long lineNumber);

	 //
	 // Returns number of screenlines composing current line
	 //
	 short GetWrapLineCount(long lineNumber)
		{return LOWORD(HandleMessage(EM_GETWRAPLINECOUNT,0,lineNumber));}

	 //
	 // Returns the length of specified screenline within a line
	 //
	 long GetWrapLineLength(long lineNumber, short lineSkip)
		{return HandleMessage(EM_GETWRAPLINELENGTH,lineSkip,lineNumber);}

	 //
	 // Returns specified screenline. Buffer str must be large enough.
	 // Returns the length of the line.
	 // In the second form allocates memory using new and pass
	 // returns its address
	 //
	 long GetWrapLine(char far* str, long lineNumber, short lineSkip);
	 char far* GetWrapLine(long lineNumber, short LineSkip);

	 //
	 // Returns Selected position
	 //
	 void GetSelection(LEDITPOSITION& Pos)
		{HandleMessage(EM_EX_GETSEL,0,(LPARAM) &Pos);}
	 void GetSelection() {GetSelection(SelPos);}

	 //
	 // Sets selected position
	 //
	 void SetSelection(const LEDITPOSITION& Pos)
		{HandleMessage(EM_EX_SETSEL,0,(LPARAM) &Pos);}
	 void SetSelection(long StartLine,short int StartPosition, long EndLine,
		short int EndPosition);
	 void SetSelection() {SetSelection(SelPos);}

	 //
	 // Moves caret
	 //
	 void MoveCaret(long Line,short int Position);

	 //
	 // Returns text length
	 //
	 long GetTextLength()
		{return HandleMessage(EM_GETTEXTLENGTH,EMP_ALLTEXT);}

	 //
	 // Returns text
	 //
	 BOOL GetText(char huge* str)
		{return ! HandleMessage(EM_GETTEXT,EMP_ALLTEXT,(LPARAM) str);}
	 BOOL GetText(char huge* str, long maxChars)
		{return ( maxChars > GetTextLength()) ? GetText(str) : FALSE; }
	 HANDLE GetText();

	 //
	 // Replaces text
	 //
	 void SetText(const char huge* str)
		{HandleMessage(EM_SETTEXT,EMP_ALLTEXT,(LPARAM) str);}
	 void SetText(HANDLE hGlobal);

	 //
	 // Returns Selected text length
	 //
	 long GetSelLength()
		{return HandleMessage(EM_GETSELTEXTLENGTH);}

	 //
	 // Returns Selected text
	 //
	 BOOL GetSelText(char huge* str)
		{return ! HandleMessage(EM_GETSELTEXT,0,(LPARAM) str);}
	 BOOL GetSelText(char huge* str, long maxChars)
		{return ( maxChars > GetSelLength()) ? GetSelText(str) : FALSE;}
	 HANDLE GetSelText();

	 //
	 // Replaces Selected text
	 //
	 void SetSelText(const char huge* str)
		{HandleMessage(EM_EX_REPLACESEL,0,(LPARAM) str);}
	 void SetSelText(HANDLE hGlobal);

	 //
	 // Verifies if the text was modified since last ClearModify()
	 //
	 BOOL IsModified(int flagNumber = 2)
		{return LOWORD(HandleMessage(EM_EX_GETMODIFY,flagNumber));}

	 //
	 // Sets or Clears modify flag
	 //
	 void SetModify(int fSetOrClear, int flagNumber = 2)
		{HandleMessage(EM_EX_SETMODIFY,fSetOrClear,flagNumber);}

	 //
	 // Clears modify flag
	 //
	 void ClearModify(int flagNumber = 2)
		{SetModify(EMP_CLEAR,flagNumber);}

	 //
	 // Deletes all text
	 //
	 void DeleteText()
		{HandleMessage(EM_CLEAR,EMP_ALLTEXT);}

	 //
	 // Deletes specified part of the text
	 //
	 void DeleteSubText(const LEDITPOSITION& Pos);
	 void DeleteSubText(long StartLine,short int StartPosition, long EndLine,
		short int EndPosition);
	 void DeleteSubText() {DeleteSubText(SelPos);}

	 //
	 // Deletes specified line
	 //
	 void DeleteLine(int lineNumber);

	 //
	 // The same as SetSelText - exists only for compatibility.
	 //
	 void Insert(const char far* str)
		{SetSelText(str);}

	 //
	 // Set number of cahrs equivalent to one tab (1 - 40)
	 // May be used before window creation
	 //
	 void SetTabStops(int numTabs);

	 //
	 // Returns handle of pop-up menu
	 //
	 HMENU GetPopUpMenu()
		{return (HMENU) HandleMessage(EM_EX_GETHANDLE,EMP_32_POPUP);}

	 //
	 // Returns handle of main menu if ES_HASMENU
	 //
	 HMENU GetMenu()
		{return (HMENU) HandleMessage(EM_EX_GETHANDLE,EMP_32_MENU);}

    //
    // Returns LEditGroup handle
    //
    HWND GetGroup()
      {return (HWND) HandleMessage(EM_EX_GETHANDLE,EMP_32_GROUP);}

	 //
	 // Returns number of first visible line
	 //
	 long GetFirstVisibleLine()
		{return HandleMessage(EM_EX_GETFIRSTVISIBLELINE);}

	 //
	 // Returns number of leftmost visible position in units that
	 // may be retrieved with GetUnitsHorizontal()
	 //
	 int GetFirstVisiblePos()
		{return LOWORD(HandleMessage(EM_GETHORZPOSITION));}

	 //
	 // Gets line height in pixels
	 //
	 int GetUnitsVertical()
		{return HIWORD(HandleMessage(EM_GETUNITS));}

	 //
	 // Gets horizontl scrolling unit in pixels
	 //
	 int GetUnitsHorizontal()
		{return LOWORD(HandleMessage(EM_GETUNITS));}

	 //
	 // Sets/Clears read-only flag
	 //
	 void SetReadOnly(BOOL readOnly = TRUE);

	 //
	 // Gets ReadOnly status. Won't work if this status is
	 // changed directly by sending EM_SETREADONLY
	 //
	 BOOL GetReadOnly()
		{return (Attr.Style & ES_READONLY) != 0;}

    //
	 // Sets/Clears ES_HIGHLIGHT flag
	 //
	 void SetHighlight(BOOL highlight = TRUE);

	 //
	 // Gets Highlight status. Won't work if this status is
	 // changed directly by sending EM_SETHIGHLIGHT
	 //
	 BOOL GetHighlight()
		{return (Attr.Style & ES_HIGHLIGHT) != 0;}

    //
	 // Sets/Clears ES_TRANSPARENT flag
	 //
	 void SetTransparent(BOOL transparent = TRUE);

	 //
	 // Gets Transparent status. Won't work if this status is
	 // changed directly by sending EM_SETTRANSPARENT
	 //
	 BOOL GetTransparent()
		{return (Attr.Style & ES_TRANSPARENT) != 0;}

    //
	 // Sets/Clears WS_HSCROLL and WS_VSCROLL flag
	 //
	 void SetScrollBars(BOOL horzScrollBar, BOOL vertScrollBar);
    void SetHorzScrollBar(BOOL horzSctollBar);
    void SetVertScrollBar(BOOL vertScrollBar);

	 //
	 // Gets ScrollBar status. Won't work if this status is
	 // changed directly by sending EM_SETMETRICS
	 //
	 BOOL GetHorzScrollBar()
		{return (Attr.Style & WS_HSCROLL) != 0;}
    BOOL GetVertScrollBar()
      {return (Attr.Style & WS_VSCROLL) != 0;}

    //
	 // Sets external spacing in Pixels. Works only when control
    // window is created and allow setting spacing in range 0 - 15
	 //
	 void SetExtraSpacing(short horzSpacing, short vertSpacing);
    void SetExtraHorzSpacing(short horzSpacing);
    void SetExtraVertSpacing(short vertSpacing);

    //
    // Resets file information and sets ES_HASFILE according to hasFile
    // This method doesn't change menu.
    //
    void ResetFileState(BOOL hasFile = TRUE)
      {HandleMessage(EM_RESETFILESTATE,
        (hasFile) ? EMP_EMPTYFILE : EMP_NOFILE);}

	 //
	 // Sets insert mode
	 //
#define IM_INSERT    FALSE
#define IM_OVERWRITE TRUE
	 void SetInsertMode(BOOL insertMode = FALSE);

	 //
	 // Toggles insert mode
	 //
	 void ToggleInsertMode()
		{SetInsertMode(!InsertMode);}

	 //
	 // Gets insert mode
	 //
	 BOOL GetInsertMode()
		{return InsertMode;}

	 //
	 // Sets AutoIndent state
	 //
	 void SetAutoIndent(BOOL autoIndent = TRUE);

	 //
	 // Gets AutoIndent State
	 //
	 BOOL GetAutoIndent()
		{return AutoIndent;}

	 //
	 // Sets DefaultSelection State
	 //
	 void SetDefaultSelection(BOOL defaultSelection = TRUE);

	 //
	 // Gets DefaultSelection State
	 //
	 BOOL GetDefaultSelection()
		{return DefaultSelection;}

	 //
	 // Sets WrapKeys State
	 //
	 void SetWrapKeys(BOOL wrapKeys = TRUE);

	 //
	 // Gets WrapKeys State
	 //
	 BOOL GetWrapKeys()
		{return WrapKeys;}

	 //
	 // Sets MultilineItems state
	 //
	 void SetMultilineItems(BOOL multilineItems = TRUE);

	 //
	 // Gets MultilineItems State
	 //
	 BOOL GetMultilineItems()
		{return MultilineItems;}

    //
	 // Sets MultilineStrings state
	 //
	 void SetMultilineStrings(BOOL multilineStrings = TRUE);

	 //
	 // Gets MultilineStrings State
	 //
	 BOOL GetMultilineStrings()
		{return MultilineStrings;}

    //
	 // Sets SinglelineStrings state
	 //
	 void SetSinglelineStrings(BOOL singlelineStrings = TRUE);

	 //
	 // Gets SinglelineStrings State
	 //
	 BOOL GetSinglelineStrings()
		{return SinglelineStrings;}

    //
	 // Sets CurrentWordAsText state
	 //
	 void SetCurrentWordAsText(BOOL currentWordAsText = TRUE);

	 //
	 // Gets CurrentWordAsText State
	 //
	 BOOL GetCurrentWordAsText()
		{return CurrentWordAsText;}

    //
	 // Sets UnixStyleSave state
	 //
	 void SetUnixStyleSave(BOOL unixStyleSave = TRUE);

	 //
	 // Gets UnixStyleSave State
	 //
	 BOOL GetUnixStyleSave()
		{return UnixStyleSave;}

    //
	 // Sets MacStyleSave state
	 //
	 void SetMacStyleSave(BOOL macStyleSave = TRUE);

	 //
	 // Gets MacStyleSave State
	 //
	 BOOL GetMacStyleSave()
		{return MacStyleSave;}

	 //
	 // Sets StartInComments flag that forces LEdit to think that
	 // there's the line with open comment sign before the text
	 //
	 void SetStartInComments(BOOL startInComments = TRUE);

    //
	 // Gets StartInComments flag
	 //
	 BOOL GetStartInComments()
		{return StartInComments;}

	 //
	 // Allows or suppresses Print Dialog
	 //
	 void SetPrintDialog(BOOL printDialog = TRUE);

	 //
	 // Tells if Print Dialog is allowed
	 //
	 BOOL GetPrintDialog()
		{return ! NoPrintDialog;}

	 //
	 // Allows or suppresses Print Progress Dialog
	 //
	 void SetPrintProgress(BOOL printDialog = TRUE);

	 //
	 // Tells if Print Progress Dialog is allowed
	 //
	 BOOL GetPrintProgress()
		{return ! NoPrintProgress;}

	 //
	 // Sets Width of the caret
	 //
	 void SetCaretWidth(short caretWidth = 0);

	 //
	 // Gets width of the caret
	 //
	 BOOL GetCaretWidth()
		{return CaretWidth;}

    //
    // Sets Word Wrap and its attributes. active means that words
    // will be wrapped, automatic means that WordBreakProc() won't
    // be called, width specifies a width, zero stands for window
    // width.
    //
    void SetWordWrap(BOOL active = TRUE, BOOL automatic = TRUE,
      short width = 0);

    //
	 // Sets search flags. See EM_SETFINDFLAGS in LEDIT.H for details
	 // Works only when control window exists
	 //
	 void SetSearchFlags(long flags = 0)
		{HandleMessage(EM_SETFINDFLAGS,0,flags);}

	 //
	 // Gets search flags.
	 //
	 long GetSearchFlags()
		{return HandleMessage(EM_GETFINDFLAGS);}

	 //
	 // Sets the string to be found by Find and FindNext methods
	 //
	 void SetSearchFindText(char far* text)
		{HandleMessage(EM_SETFINDTEXT,EMP_FIND,(LPARAM) text);}

	 //
	 // Gets the string to be found by Find and FindNext methods
	 // buffer must be at least 128 bytes
	 //
	 void GetSearchFindText(char far* buffer)
		{HandleMessage(EM_GETFINDTEXT,EMP_FIND,(LPARAM) buffer);}

	 //
	 // Sets the string to replace matches found in Replace and
	 // ReplaceAll methods
	 //
	 void SetSearchReplaceText(char far* text)
		{HandleMessage(EM_SETFINDTEXT,EMP_REPLACE,(LPARAM) text);}

	 //
	 // Sets the string to replace matches found in Replace and
	 // ReplaceAll methods
	 // buffer must be at least 128 bytes
	 //
	 void GetSearchReplaceText(char far* buffer)
		{HandleMessage(EM_GETFINDTEXT,EMP_REPLACE,(LPARAM) buffer);}

	 //
	 // Finds the text specified. Returns 1 if match was found and
	 // highlighted. -1 indicates error.
	 //
	 short Find()
		{return LOWORD(HandleMessage(EM_FIND,EMP_FIND));}
	 short Find(char far* what)
		{SetSearchFindText(what); return Find();}
	 short Find(char far* what, long flags)
		{SetSearchFlags(flags); return Find(what);}

	 //
	 // Finds the text specified. Returns 1 if match was found and
	 // highlighted. -1 indicates error. Unlike Find doesn't use
	 // current selection, but LEDITPOSITION supplied
	 //
	 short QuietFind(const LEDITPOSITION& Pos)
		{return LOWORD(HandleMessage(EM_FIND,EMP_FIND,(LPARAM) &Pos));}
	 short QuietFind(const LEDITPOSITION& Pos, char far* what)
		{SetSearchFindText(what); return QuietFind(Pos);}
	 short QuietFind(const LEDITPOSITION& Pos, char far* what, long flags)
		{SetSearchFlags(flags); return QuietFind(Pos, what);}

	 //
	 // Verifies if currently selected text matches search criteria
    // and then replaces it. Returns 1 if match was found and
    // replaced. -1 indicates error.
    //
    short Replace()
      {return LOWORD(HandleMessage(EM_FIND,EMP_REPLACE));}
    short Replace(char far* byWhat)
      {SetSearchReplaceText(byWhat); return Replace();}
    short Replace(char far* what, char far* byWhat)
      {SetSearchFindText(what); return Replace(byWhat);}
    short Replace(char far* byWhat, long flags)
      {SetSearchFlags(flags); return Replace(byWhat);}
    short Replace(char far* what, char far* byWhat, long flags)
      {SetSearchFlags(flags); return Replace(what, byWhat);}

    //
    // Replaces all occurrences of one string by another. Returns
    // number of occurrences replaced. -1 indicates error.
    //
    long ReplaceAll()
      {return HandleMessage(EM_FIND,EMP_REPLACEALL);}
    long ReplaceAll(char far* what, char far* byWhat)
      {SetSearchFindText(what); SetSearchReplaceText(byWhat);
        return ReplaceAll();}
    long ReplaceAll(char far* what, char far* byWhat, long flags)
      {SetSearchFlags(flags); return ReplaceAll(what, byWhat);}
    long ReplaceAll(long flags)
      {SetSearchFlags(flags); return ReplaceAll();}

        //
    // Draws a page of text to the specified Device Context
    //                                                     
    void DrawPage(HDC hDC, DRAWPAGE far* drawPage)
      {HandleMessage(EM_DRAWPAGE,(WPARAM)hDC,(LPARAM) drawPage);}
      
	 //
	 // Adjusts DrawPage to point to the next page
	 //
	 void NextPage(HDC hDC, DRAWPAGE far* drawPage)
		{HandleMessage(EM_NEXTPAGE,(WPARAM)hDC,(LPARAM) drawPage);}

	 //
	 // Sets dialog locations for LEdit's dialogs. This refers to
	 // their left corners. Constants for dialog types are listed in
	 // LEDIT.H under EM_SETDIALOGLOCATION message.
	 //
	 void SetDialogLocation(int dlgType, int x, int y)
		{HandleMessage(EM_SETDIALOGLOCATION,dlgType,MAKELONG(x,y));}

	 //
	 // Gets dialog locations for LEdit's dialogs. This refers to
	 // their left corners. Constants for dialog types are listed in
	 // LEDIT.H under EM_SETDIALOGLOCATION message.
	 //
	 void GetDialogLocation(int dlgType, int &x, int &y);

	 //
	 // Translates screen coordinates to LEdit's position
	 // line receives number of line; pos - position inside
	 // line. If operation is set to EMP_TOLEFT returns
	 // position to the left of specified location
	 //
	 void TranslateLocation(int x, int y, long &line, int &pos,
		int operation = EMP_NEAREST);

	 //
	 // Translate text position into screen coordinates. Returns
	 // TRUE if successfull. Return FALSE if the position
	 // specified don't extst or isn't visible
	 //
	 BOOL GetLocation(long line, int pos, int &x, int &y);

	 //
	 // Sets maximum possible number of bookmarks
	 //
	 void SetBookmarksMax(short number);

	 //
	 // Retrieves previously set maximum number of bookmarks
	 //
	 short GetBookmarksMax()
		{return BookmarksMax;};


			//
         // Sets bookmark with specified number at specified line
         // Operates only when LEdit window exists. number may be
         // between 0 and 15.
         //
         int SetBookmark(int number, int line)
           {return LOWORD(HandleMessage(EM_SETBMLINE,number,line));}
         int SetBookmark(int line)
           {return SetBookmark(0,line);}

         //
         // Retrieves number of line at which bookmark with specified
         // number was set. This number of line may change as user
         // edits text and inserts/removes lines
         //
         long GetBookmarkLine(int number = 0)
           {return HandleMessage(EM_GETBMLINE,number);}

         //
         // Set Foreground color to be used to highlight bookmark
         //
         void SetBookmarkForeColor(int number, COLORREF color)
           {HandleMessage(EM_SETBMATTRIBUTES,number +
             ((EMP_SETTEXTCOLOR | EMP_STARTTEXTCOLOR) << 8),color);}
         void SetBookmarkForeColor(COLORREF color)
           {SetBookmarkForeColor(0,color);}

         //
         // Stops Foreground highlight of specified bookmark
         //
         void RemoveBookmarkForeColor(int number = 0)
           {HandleMessage(EM_SETBMATTRIBUTES,number+(EMP_STOPTEXTCOLOR << 8));}

         //
         // Set Background color to be used to highlight bookmark
         //
         void SetBookmarkBackColor(int number, COLORREF color)
           {HandleMessage(EM_SETBMATTRIBUTES,number +
             ((EMP_SETBKCOLOR | EMP_STARTBKCOLOR) << 8),color);}
         void SetBookmarkBackColor(COLORREF color)
           {SetBookmarkBackColor(0,color);}

         //
         // Stops Foreground highlight of specified bookmark
         //
         void RemoveBookmarkBackColor(int number = 0)
           {HandleMessage(EM_SETBMATTRIBUTES,number+(EMP_STOPBKCOLOR << 8));}

	 //
	 // Gets maximum possible depth of Undo. Works only
	 // when window exists
	 //
	 int GetUndoMaxBuffer()
		{return LOWORD(HandleMessage(EM_GETMAXUNDOBUFFER));}

	 //
	 // Sets the depth of undo. -1 means maximum possible depth
	 //
	 void SetUndoDepth(int undoDepth = -1);

    //
    // Scrolls the control vertically. line becomes first visible
    // line and "skip" screenlines of it are left above screen
    //
    void ScrollVertically(long line, short skip)
      {HandleMessage(EM_SCROLLVERTICALLY,skip,line);}

    //
    // Scrolls LEdit horizontally.
    //
    void ScrollHorizontally(short pos)
      {HandleMessage(EM_SCROLLHORIZONTALLY,pos);}

    //
    // Return the number of invisible screenlines belonging to
    // the topmost visible line
    //
    short GetSkip()
      {return LOWORD(HandleMessage(EM_GETSKIP));}

	 //
	 // Fill in the control with text from file
	 //
	 BOOL LoadFromFile(const char far* fileName)
		{return !LOWORD(HandleMessage(EM_SETTEXTFROMFILE,0,(LPARAM) fileName));}


	 //
	 // Stores control containt into the file
	 //
	 BOOL StoreToFile(const char far* fileName)
		{return !LOWORD(HandleMessage(EM_GETTEXTTOFILE,0,(LPARAM) fileName));}

#define MENU_COMMAND(MC_fn,MC_cmd) \
	  void MC_fn() {HandleMessage(WM_COMMAND,MC_cmd);}


         BOOL CanExecute(WORD commandId)
                {return LOWORD(HandleMessage(EM_CANEXECUTECOMMAND,commandId));}

	 //
	 // Edit operations
	 //
	 BOOL CanUndo()
		{return LOWORD(HandleMessage(EM_EX_CANUNDO,EMP_UNDO));}
	 BOOL CanRedo()
		{return LOWORD(HandleMessage(EM_EX_CANUNDO,EMP_UNDO));}
	 BOOL IsSelection();

	 void Undo()
		{HandleMessage(EM_EX_UNDO,EMP_UNDO);}
	 void Redo()
		{HandleMessage(EM_EX_UNDO,EMP_REDO);}
	 void Cut()
		{HandleMessage(WM_CUT);}
	 void Copy()
		{HandleMessage(WM_COPY);}
	 void Paste()
		{HandleMessage(WM_PASTE);}
	 MENU_COMMAND(Duplicate,EC_EDITDUPLICATE)
	 void DeleteSelection()
		{HandleMessage(EM_CLEAR,EMP_SELECTION);}
	 MENU_COMMAND(SelectAll,EC_EDITSELECTALL)

	 //
	 // Search operations
	 //
	 BOOL CanFindNext()
		{return LOWORD(HandleMessage(EM_CANFINDNEXT));}

	 MENU_COMMAND(ShowFindDialog,EC_SEARCHFIND)
	 MENU_COMMAND(FindNext,EC_SEARCHNEXT)
	 MENU_COMMAND(ShowReplaceDialog,EC_SEARCHREPLACE)
	 MENU_COMMAND(FindBrace,EC_SEARCHBRACE)
	 MENU_COMMAND(ShowGotoLineDialog,EC_SEARCHLINE)
	 MENU_COMMAND(FindBookmark,EC_SEARCHBOOKMARK)
	 MENU_COMMAND(SetBookmark,EC_SEARCHSETBOOKMARK)

	 //
	 // Tools operations
	 //
	 MENU_COMMAND(ShowFontDialog,EC_TOOLSCHANGEFONT)
	 void EmptyUndoBuffer()
		{HandleMessage(EM_EX_EMPTYUNDOBUFFER);}
	 void Clear()
		{HandleMessage(WM_CLEAR,EMP_ALLTEXT);}
    MENU_COMMAND(Print,EC_FILEPRINT)
    MENU_COMMAND(PrinterSetup,EC_FILEPRINTERSETUP)

	 //
	 // Return TRUE if this is LEditWindow
	 //
	 BOOL IsLEdit()
		{return (HandleMessage(EM_ISLEDITWINDOW,0,543210L) == 543211L);}

	 //
	 // Override TWindow virtual member functions.
	 //
	 // Transfers nothing
	 //
	 virtual UINT Transfer(void* buffer, TTransferDirection direction);

	 //
	 // Sends several notifications. See LEDIT.H for details.
	 //
	 virtual BOOL CanClose();

  protected:
	 //
	 // Indicates if LEdit window is functional. Don't write!!!
	 //
	 BOOL Run;

	 //
	 // command response functions. Commands EC_* are responded
	 // directly. Only responses to IDs with existing CM_*
	 // constants are provided to make CM_* commands work
	 // the same way as EC_* ones. All constants are listed below
	 // as comments to the functions.
	 //
	 void CmEC_Command(WPARAM wp)
		{DefWindowProc(WM_COMMAND,wp,0L);}       // Any EC_*

	 void CmEditUndo() {Undo();}                // CM_EDITUNDO
															  // EC_EDITUNDO

															  // EC_EDITREDO

	 void CmEditCut() {Cut();}                  // CM_EDITCUT
															  // EC_EDITCUT

	 void CmEditCopy() {Copy();}                // CM_EDITCOPY
															  // EC_EDITCOPY

	 void CmEditPaste() {Paste();}              // CM_EDITPASTE
															  // EC_EDITPASTE

															  // EC_DUPLICATE

	 void CmEditDelete() {DeleteSelection();}   // CM_EDITDELETE
															  // EC_EDITCLEAR

															  // EC_EDITSELECTALL

	 void CmEditFind() {ShowFindDialog();}      // CM_EDITFIND
															  // EC_SEARCHFIND

	 void CmEditFindNext() {FindNext();}        // CM_EDITFINDNEXT
															  // EC_SEARCHNEXT

	 void CmEditReplace() {ShowReplaceDialog();}// CM_EDITREPLACE
															  // EC_SEARCHREPLACE

															  // EC_SEARCHBRACE
															  // EC_SEARCHLINE
															  // EC_SEARCHBOOKMARK
															  // EC_SEARCHSETBOOKMARK
															  // EC_TOOLSCHANGEFONT
															  // EC_TOOLSCLEARUNDOBUFFER

	 void CmEditClear() {Clear();}              // CM_EDITCLEAR
															  // EC_TOOLSCLEARALL

    void CmFilePrint() {Print();}              // CM_FILEPRINT
                                               // EC_FILEPRINT

    void CmFilePrinterSetup() {PrinterSetup();}// CM_FILEPRINTSETUP
                                               // EC_FILEPRINTERSETUP


	 //
	 // command enabler functions
	 //
	 void CmDirectEnable(TCommandEnabler& commandHandler);
	 void CmTranslateEnable(TCommandEnabler& commandHandler);

	 //
	 // Virtual functions to handle events. LEdit can't use normal RESPONSE
	 // TABLE Mechanism because its notifications may be answered. So, all
	 // events generated by LEdit lead to call to some of the follofing
	 // virtual functions. By default they all sends notification about
	 // the event and then return zero as default answer.
	 //
	 // Some events generate notifications that weren't generated by LEdit
	 // On the other hand some events, which are results of LEdit nofification
	 // does not generate notifications by itself.
	 //
	 // File handling events are also included here though they make sense
	 // only in TLEditFile
	 //
	 // The following virtual functions do send notifications
	 // If you override them you need to call prototypes to ensure
	 // notification processing
	 //
#define NOTIFY_PARENT(id,code,hwnd) if (Parent) \
  Parent->SendNotification(id,code,hwnd)

	 virtual void OnChange()
		{NOTIFY_PARENT(Attr.Id,EN_CHANGE,HWindow);}

	 virtual void OnChangeMode()
		{NOTIFY_PARENT(Attr.Id,EN_INSERTMODE + InsertMode,HWindow);}

	 virtual LRESULT OnClipboardError()
		{NOTIFY_PARENT(Attr.Id,EN_CLIPBOARD,HWindow);
		 return 0;}

	 virtual LRESULT OnFileError()
		{NOTIFY_PARENT(Attr.Id,EN_FILEERROR,HWindow);
		 return 0;}

	 virtual LRESULT OnSpaceError()
		{NOTIFY_PARENT(Attr.Id,EN_ERRSPACE,HWindow);
		 return 0;}

	 virtual LRESULT OnMaxLine()
		{NOTIFY_PARENT(Attr.Id,EN_MAXTEXT,HWindow);
		 return 0;}

	 virtual LRESULT OnGoingToClose()
		{NOTIFY_PARENT(Attr.Id,EN_GOINGTOCLOSE,HWindow);
		 return 0;}

	 virtual void OnGotFocus()
		{NOTIFY_PARENT(Attr.Id,EN_SETFOCUS,HWindow);}

	 virtual void OnLostFocus()
		{NOTIFY_PARENT(Attr.Id,EN_KILLFOCUS,HWindow);}

	 virtual void OnHorzScroll()
		{NOTIFY_PARENT(Attr.Id,EN_HSCROLL,HWindow);}

	 virtual void OnVertScroll()
		{NOTIFY_PARENT(Attr.Id,EN_VSCROLL,HWindow);}

	 virtual void OnNewFile()
		{NOTIFY_PARENT(Attr.Id,EN_NEWFILE,HWindow);}

	 virtual void OnNewFont()
		{NOTIFY_PARENT(Attr.Id,EN_NEWFONT,HWindow);}

	 //
	 // This function is called from EM_CTLCOLOR handler
	 // You may change BackColorSelected and ForeColorSelected
	 // when receiving the notification. Default handler of EM_CTLCOLOR
	 // uses them to set colors of selected text.
	 //
#define EN_CTLSELCOLOR 30000
	 virtual void OnCtlSelColor()
		{NOTIFY_PARENT(Attr.Id,EN_CTLSELCOLOR,HWindow);}

	 //
	 // This function is called from WM_CTLCOLOR handler
	 // You may change BackColor and ForeColor
	 // when receiving the notification. Default handler of WM_CTLCOLOR
	 // uses them to set colors of selected text.
	 //
	 // This function works only if ControlColors == TRUE, otherwise
	 // colors are intended to be controlled by parent Window, that
	 // gives default LEdit behaviour.
	 //
#define EN_CTLTXTCOLOR 30001
	 virtual void OnCtlTxtColor()
		{NOTIFY_PARENT(Attr.Id,EN_CTLTXTCOLOR,HWindow);}

	 //
	 // This one should be used for informational purposes
	 // only and is called from EM_WORDCLICK handler
#define EN_WORDCLICK   30002
	 virtual void OnWordClick()
		{NOTIFY_PARENT(Attr.Id,EN_WORDCLICK,HWindow);}

	 //
	 // OnCreated is called much after creation, from SetupWindow()
	 // virtual method
	 //
	 virtual void OnCreated()
		{NOTIFY_PARENT(Attr.Id,EN_CREATED,HWindow);}

	 //
	 // EN_DESTROY notification becomes obsolete in OWL because
	 // Destroy() virtual function may always be called
	 //

	 //
	 // These virtual functions don't send any notifications
	 //
	 virtual LRESULT OnAskIfStoreFile()
		{return 0;}

	 //
	 // Called before showing Matches/Replaces message boxes
	 //
	 virtual LRESULT OnNotifyFound(long Code)
		{return 0;}

	 //
	 // Does Highlight if ES_HIGHLIGHT style is set
	 //
	 virtual WORD ControlHighlight(const WORDDESC& WordDesc,
											 COLORREF& BkColor,
											 COLORREF& TextColor)
		{ BkColor = 0; TextColor = 0; return 0;}
#define EOCH_NONE  0
#define EOCH_TEXT  1
#define EOCH_BKGND 2
#define EOCH_BOTH  3

    //
    // These two functions make sense only from within
    // ControlHighlight and return number of line and
    // position of the word being highlighted respectively
    //
    long HighlightedLine()
      {return HandleMessage(EM_HIGHLIGHTEDLINE);}
    short HighlightedPos()
      {return LOWORD(HandleMessage(EM_HIGHLIGHTEDPOS));}

	 //
	 // Brace definition function called on EM_FINDBRACE
	 //
	 virtual WORD OnFindBrace(WORDDESC& WordDesc)
		{ return EMF_NOBRACE; }

	 //
	 // This function is called on EM_WORDCLICK that is when
	 // user doubleclick some word.
	 //
	 virtual WORD WordClick(const WORDDESC& WordDesc)
		{ return 0; }

	 //
	 // Does Background drawing if ES_TRANSPARENT style is set
	 // Receives actual LEdit or Memory DC depending on UseMemoryDC member
	 //
	 virtual void Paint(TDC& hDC, BOOL erase, TRect& rect)
		{}

    //
    // This function is called to draw footer/header. Should return
    // size of part drawn (see EM_PRINT in LEDIT.H)
    //
    virtual long OnPrint(TDC& hDC, short width, short height)
      {return 0;}

    //
    // Return number of page being printed or zero
    //
    short PrintedPageNum()
      {return LOWORD(HandleMessage(EM_PRINTEDPAGE));}

    //
    // This function is called when LEdit needs to break a line.
    // It should return position where to break (no more than maxBreak)
	 //
    virtual short WordBreakProc(const char far*, short maxBreak)
      {return maxBreak;}

	 //
	 // Override TWindow virtual member functions
	 //
	 virtual void SetupWindow();
	 virtual char far* GetClassName();
	 virtual LRESULT EvCommand(UINT Id, HWND hWndCtl, UINT notifyCode);
	 virtual void EvPaint();
#ifdef BC40
	 virtual void EvSetFont(HANDLE hfont, BOOL redraw);
#else
	 virtual void EvSetFont(HFONT hfont, BOOL redraw);
#endif
	 virtual void EvDestroy();

	 //
	 // Create new response-table functions
	 //
	 virtual LRESULT EvControlSColor(WPARAM, LPARAM);
    virtual LRESULT EvControlTColor(WPARAM, LPARAM);
	 virtual LRESULT EvControlHighlight(WPARAM, LPARAM);
	 virtual LRESULT EvDraw(WPARAM, LPARAM);
	 virtual LRESULT EvFindBrace(WPARAM, LPARAM);
	 virtual LRESULT EvWordClick(WPARAM, LPARAM);
    virtual LRESULT EvPrint(WPARAM, LPARAM);
	 virtual LRESULT EvWordWrap(WPARAM, LPARAM);
	 virtual LRESULT EvNotifyFound(WPARAM, LPARAM);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 BOOL StreamInit;
	 BOOL InsertMode;
	 BOOL AutoIndent;
	 BOOL DefaultSelection;
	 BOOL WrapKeys;
	 BOOL MultilineItems;
	 BOOL MultilineStrings;
	 BOOL SinglelineStrings;
	 BOOL CurrentWordAsText;
	 BOOL UnixStyleSave;
	 BOOL MacStyleSave;
	 BOOL StartInComments;
	 BOOL NoPrintDialog;
	 BOOL NoPrintProgress;
	 BOOL WordWrap;
	 BOOL WordWrapAuto;
	 short WordWrapWidth;
	 short CaretWidth;
	 short BookmarksMax;
	 TLEditGroup* Group;
	 int UndoDepth;
	 int TabStops;
	 SYNTAX Syntax[SIZE_SYNTAX];
	 int SyntaxLength;

    void Init();

	 TLEdit(const TLEdit&);
	 TLEdit& operator =(const TLEdit&);

  DECLARE_STREAMABLE(,TLEdit, 1);
  DECLARE_RESPONSE_TABLE(TLEdit);
};

//
//  class TLEditFile
//  ----- ----------
//
#if !defined (LEDIT_NO_FILE)
class TLEditFile : public TLEdit {
  public:
	 TLEditFile(TWindow*        parent,
					const char far* title,
					long extraStyle = 0, // Additional styles. See the list in LEDIT.H
					TModule*        module = 0);

	 TLEditFile(TWindow*        parent,
					int             id,
					const char far* title,
					int x = 0, int y = 0, int w = 0, int h = 0,
					long extraStyle = 0, // Additional styles. See the list in LEDIT.H
					TModule*        module = 0);

	 TLEditFile(TWindow*   parent,
					int        resourceId,
					TModule*   module = 0);

	 //
	 // Returns file name. Buffer fileName must be large enough.
	 // Returns the length of the line.
	 // In the second form allocates memory using new and
	 // returns its address
	 //
	 long GetFileName(char far* fileName)
		{return HandleMessage(EM_GETFILENAME,0,(LPARAM) fileName);}
	 char far* GetFileName();

	 //
	 // Sets File Mask/Filter (see EM_SETFILEMASK)
	 //
	 void SetFileMask(char far* fileMask);

	 //
	 // Gets File Mask/Filter
	 //
	 char far* GetFileMask(char far* fileMask)
		{return lstrcpy(fileMask, FileMask);}

	 //
	 // File operations
	 //
	 MENU_COMMAND(NewFile,EC_FILENEW)
	 MENU_COMMAND(OpenFile,EC_FILEOPEN)
	 MENU_COMMAND(ReloadFile,EC_FILEREOPEN)
	 MENU_COMMAND(SaveFile,EC_FILESAVE)
	 MENU_COMMAND(SaveFileAs,EC_FILESAVEAS)

  protected:
	 //
	 // command response functions. Commands EC_* are responded
	 // directly. Only responses to IDs with existing CM_*
	 // constants are provided to make CM_* commands work
	 // the same way as EC_* ones. All constants are listed below
	 // as comments to the functions.
	 //
	 // All commands are automatically enabled/disabled except
	 // CM_FILENEW and CM_FILEOPEN {Not EC_FILENEW/EC_FILEOPEN}
	 //
	 // CmFileNew and CmFileOpen don't have any entries
	 // in Response Table, but may be added in descendents
	 //
	 void CmFileNew() {NewFile();}              // CM_FILENEW
															  // EC_FILENEW

	 void CmFileOpen() {OpenFile();}            // CM_FILEOPEN
															  // EC_FILEOPEN

	 void CmFileReOpen() {ReloadFile();}        // CM_FILEREVERT
															  // EC_FILEREOPEN

	 void CmFileSave() {SaveFile();}            // CM_FILESAVE
															  // EC_FILESAVE

	 void CmFileSaveAs() {SaveFileAs();}        // CM_FILESAVEAS
															  // EC_FILESAVEAS

    //
	 // Override TWindow virtual member functions
	 //
	 virtual void SetupWindow();

	 //
	 // Create new response-table functions
	 //
	 virtual LRESULT EvSetFileMask(WPARAM, LPARAM);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 char FileMask[SIZE_FILEMASK];

	 void Init();

	 TLEditFile(const TLEditFile&);
	 TLEditFile& operator =(const TLEditFile&);

  DECLARE_STREAMABLE(,TLEditFile, 1);
  DECLARE_RESPONSE_TABLE(TLEditFile);
};
#endif // TLEditFile

//
//  class TLEditView
//  ----- ----------
//
#if !defined(LEDIT_NO_VIEW)
class TLEditView : public TLEdit, public TView {
  public:
	 TLEditView(TDocument& doc,
		    TWindow* parent = 0,
		    TModule* module = 0);
	 //
	 // Returns view name
	 //
	 static const char far* StaticName()
		{return "Large Edit View";}

	 //
	 // overrides virtual functions from TView
	 //
	 virtual const char far*   GetViewName()
		{return StaticName();}
	 virtual TWindow* GetWindow()
		{return (TWindow*) this;}
	 virtual BOOL SetDocTitle(const char far* docname, int index)
		{return TLEdit::SetDocTitle(docname, index);}

	 //
	 // overrides virtual functions from TLEditControl
	 //
	 virtual BOOL CanClose()
		{return TLEdit::CanClose() && Doc->CanClose();}

  protected:
	 virtual BOOL Create();
	 BOOL   LoadData();
	 //
	 // message response functions
	 //
	 virtual BOOL VnCommit(BOOL force);
	 virtual BOOL VnRevert(BOOL clear);
	 virtual BOOL VnIsWindow(HWND hWnd)
		{return (HWindow == hWnd) && IsLEdit();}
	 virtual BOOL VnIsDirty()
		{return TLEdit::IsModified(15);}
	 virtual BOOL VnDocClosed(int omode);

  private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 BOOL weWrite;

	 TLEditView(const TLEditView&);
	 TLEditView& operator =(const TLEditView&);

  DECLARE_STREAMABLE(, TLEditView,1);
  DECLARE_RESPONSE_TABLE(TLEditView);
};
#endif // TLEditView

#endif // OWL_LEDIT_H
