//////////////////////////////////////////////////////
// File: MatDemo1.cpp
// Purpose: Demonstrates use of matrix template class
// Author: Somnath Kundu

#include <time.h>
#include "matrix.h"

#ifndef _NO_NAMESPACE
using namespace std;
using namespace math;
#define STD std
#else
#define STD
#endif

#ifndef _NO_TEMPLATE
typedef matrix<double> Matrix;
#else
typedef matrix Matrix;
#endif

#ifndef _NO_EXCEPTION
#  define TRYBEGIN   try {
#  define CATCHERROR } catch (const STD::exception e) { \
                     cout << "Error: " << e.what() << endl; }
#else
#  define TRYBEGIN
#  define CATCHERROR
#endif


int main ()
{
   TRYBEGIN
     cout << "Creating a random number matrix:\n";
     Matrix m;
     srand( (unsigned)time( NULL ) );
     for (int i=0; i < 4; i++)
        for (int j=0; j < 4; j++)
           m(i,j) = 12/((rand()%25)+1.0);
     m.SetSize(4,4);

     cout << "The matrix is:\n" << m << endl;

     Matrix m1 = m.Adj();
     cout << "Adjoint of the matrix is:\n" <<  m1 << endl;

     m1 = !m;
     cout << "Inverse of the matrix is:\n" << m1 << endl;

     cout << "Cofactor of (0,0) is: " << m.Cofact(0,0) << endl;
     cout << "Determinant: " << m.Det() << endl;
     cout << "Condition No: " << m.Cond() << endl;
     cout << "Norm: " << m.Norm() << endl;
#if !defined(_MSC_VER) || _MSC_VER > 1020
     Matrix s = (m * 2.0) + (m ^ 3U) - (2 * m /3) * (1/m);
     cout << "Result of following matrix equation is:\n" ;
     cout << "(m * 2) + (m ^ 3U) - (2 * m /3) * (1/m) = \n" << s << endl;
#endif
   CATCHERROR

   return 0;
}

