//////////////////////////////////////////////////////
// File: MatDemo2.cpp
// Purpose: Demonstrates use of matrix template class
// Author: Somnath Kundu

#include "matrix.h"

#ifndef _NO_NAMESPACE
using namespace std;
using namespace math;
#define STD std
#else
#define STD
#endif

#if !defined(_NO_TEMPLATE)
#  if defined(_MSC_VER)
#     if _MSC_VER > 1000
#        include <complex>
         typedef complex<double> type;
#     else
         typedef double type;
#     endif
#  elif defined(__BORLANDC__)
#     if defined(__WIN32__)
#        include <complex>
         typedef complex<double> type;
#     else
#        include <complex.h>
         typedef complex type;
#     endif         
#  endif
   typedef matrix<type> Matrix;
#else
   typedef matrix Matrix;
#endif

/*
#if !defined(_NO_TEMPLATE)
#  if !defined(_MSC_VER) || _MSC_VER > 1000
#     include <complex>
#     if defined(__BORLANDC__) && defined(__WIN32__)
         typedef complex<double> type;
#     else
         typedef complex type;
#     endif
#  else
      typedef double type;
#  endif
   typedef matrix<type> Matrix;
#else
   typedef matrix Matrix;
#endif
*/

#ifndef _NO_EXCEPTION
#  define TRYBEGIN try {
#  define CATCHERROR } catch (const STD::exception e) { \
                     cout << "Error: " << e.what() << endl; }
#else
#  define TRYBEGIN
#  define CATCHERROR
#endif

int main ()
{
   Matrix m(3,3),v(3,1),s(3,1);

   cout << "Solution of linear equation of complex number:\n\n";
   cout << "Enter the linear equations as (3X3) matrix:\n";
   cin >> m;
   cout << "Enter the vector as (3X1) matrix to solve it:\n";
   cin >> v;

   TRYBEGIN
      s = m.Solve(v);
   CATCHERROR
   cout << "Solution:\n" << s << endl;

   return 0;
}

