/*
 * sample 10
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

void ExitCB(MENU_ITEM item, MVALUE status, void *b)
{
	MOBJECT obj;

	obj = MMenuItemGetMenu(item);
	obj = MObjectShell(obj);
	MShellUnrealize(obj);
	MShellDestroy(obj);
	MGUITerm();
	exit(0);
}

void ToggleItemCB(MENU_ITEM item, MVALUE status, void *udata)
{
	char str[128];

	sprintf(str, "The selected menu item\nhas been %s",
		(status ? "Activated" : "Deactivated"));
	MMessageDialog("", str, "Ok", NULL);
}

void RadioItemCB(MENU_ITEM item, MVALUE status, void *udata)
{
	char str[128];

	if (!status)
		return;
	sprintf(str, "Menu item <%lx> selected", item);
	MMessageDialog("", str, "Ok", NULL);
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT shell, menubar, menu, submenu;
	MENU_ITEM pd_item_id;

	shell = MCreateShell("Sample 10", 0);

	menubar = MCreateMenuBar(shell, HELV_L_FONT);
	MMenuBarSetAcc(menubar, F10);
	menu = MCreateMenu(menubar, "File");
	MMenuAddItem(menu, "Quit", ExitCB, NULL);
	menu = MCreateMenu(menubar, "Submenu");
	MMenuAddToggleItem(menu, "Item 1", ToggleItemCB, NULL);
	MMenuAddToggleItem(menu, "Item 2", ToggleItemCB, NULL);
	pd_item_id = MMenuAddItem(menu, "Item 3", NULL, NULL);
	MMenuAddToggleItem(menu, "Item 4", ToggleItemCB, NULL);

	submenu = MCreateSubMenu(pd_item_id);
	MMenuAddRadioItem(submenu, "RadioItem 3-1", RadioItemCB, NULL);
	MMenuAddRadioItem(submenu, "RadioItem 3-2", RadioItemCB, NULL);
	MMenuAddRadioItem(submenu, "RadioItem 3-3", RadioItemCB, NULL);
	MMenuAddSeparator(submenu);
	MMenuAddRadioItem(submenu, "RadioItem 3-4", RadioItemCB, NULL);
	MMenuAddRadioItem(submenu, "RadioItem 3-5", RadioItemCB, NULL);

	MShellRealize(shell);

	MMainLoop();
}
