
/*
 *    File drawa.c
 *      Demonstrates the use of the DRAWAREA Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "mgui.h"

/*
 *    Callback for closing and destroying a generic dialog
 */
extern void CloseDialogCB(MOBJECT p, void *s, void *v);
extern MTColor black, white, darkblue, cadetblue, seagreen;

MOBJECT xy_label;

/*****************************************************
 *	This Callback draws lines and circles in the
 *	DRAWAREA Object using its current dimensions.
 *****************************************************/
void 
DrawAreaExposeCB(MOBJECT obj, MEvent * pe, void *a_data)
{
    int hsize, wsize;

    wsize = MObjectGetWidth(obj);
    hsize = MObjectGetHeight(obj);

    MDrawLine(obj, 0, 0, wsize, hsize, black);
    MDrawLine(obj, 0, hsize, wsize, 0, white);
#ifndef __DPMI32__AA
    MDrawFilledCircle(obj, wsize / 2, hsize / 2, wsize / 4, cadetblue);
    MDrawCircle(obj, wsize / 2, hsize / 2, wsize / 4, black);
#endif
}

/*****************************************************
 *	This Callback handles the resize of the
 *	DRAWAREA, setting a LABEL text to the
 *	new dimensions.
 *****************************************************/
void 
DrawAreaResizeCB(MOBJECT obj, DRAWAREA_PREF * pref, void *label)
{
    char str[128];

    sprintf(str, "%dx%d", pref->new_w, pref->new_h);
    MObjectSetText((MOBJECT) label, str);
}

/*****************************************************
 *	This Callback handles the mouse input events
 *	in the Object drawing lines
 *****************************************************/
void 
DrawAreaInputCB(MOBJECT obj, MEvent * pe, void *a_data)
{
extern MTColor MGetPixel(MOBJECT p, int x, int y);
    static int x1, y1, x2, y2;
    char buff[128];

    switch (pe->type)
    {
    case E_WINDOW_EXIT:
/*
 * Set the initial coordinates at the mouse
 * button press event
 */
	MObjectSetText(xy_label, "");
	break;
    case E_BUTTON_PRESS:
/*
 * Set the initial coordinates at the mouse
 * button press event
 */
	x1 = x2 = pe->mouse.x;
	y1 = y2 = pe->mouse.y;
	break;
    case E_WINDOW_ENTER:
    case E_MOTION:
	if ((pe->mouse.state & Button1Mask) && x1 > 0)
	{
/*
 * Erase the old line and draw the new one
 * while dragging the mouse (draw in Xor mode)
 */
	    MDrawXorLine(obj, x1, y1, x2, y2);
	    MDrawXorLine(obj, x1, y1, pe->mouse.x, pe->mouse.y);
	}
	x2 = pe->mouse.x;
	y2 = pe->mouse.y;
	sprintf(buff, "%3d %3d", x2, y2);
	MObjectSetText(xy_label, buff);
	break;
    case E_BUTTON_RELEASE:
/*
 * Erase the old line and draw the definitive one
 */
	MDrawXorLine(obj, x1, y1, x2, y2);
	x2 = pe->mouse.x;
	y2 = pe->mouse.y;
	MDrawLine(obj, x1, y1, x2, y2, seagreen);
	x1 = -1;
	break;
    case E_GRAB_LOSE:
/*
 * The Object has lost mouse grab, so, clear the line
 */
	MDrawXorLine(obj, x1, y1, x2, y2);
	x1 = -1;
    }
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void 
DrawAreaCB(MOBJECT obj, void *a, void *b)
{
    MOBJECT pbutton, shell, cform, rform, cf2, label, drawa, sfile;

    shell = MCreateShell("Draw Area", SF_MODAL);

    cform = MCreateColForm(shell);
    rform = MCreateRowForm(cform);
    cf2 = MCreateColForm(rform);
/*
 * This LABEL is used to show the current
 * DRAWAREA dimensions
 */
    label = MCreateLabel(cf2, "", HELV_MEDIUM);
    xy_label = MCreateLabel(cf2, "", SMALL_FONT);

/*
 * Create the DRAWAREA Object of 256x256 pixels wide
 */
    drawa = MCreateDrawArea(rform, 256, 256);
	MObjectSetBackgroundImageFile(drawa, "tile5.bmp", BI_TILED);
    MObjectSetCursor(drawa, MC_CROSSHAIR);
/*
 * Allow the DRAWAREA to resize in Horizontal and Vertical
 * directions
 */
    MObjectSetResize(drawa, True, True);
/*
 * Set the callbacks to handle the Object events
 */
    MDrawAreaSetExposeCallback(drawa, DrawAreaExposeCB, NULL);
    MDrawAreaSetInputCallback(drawa, DrawAreaInputCB, NULL);
    MDrawAreaSetResizeCallback(drawa, DrawAreaResizeCB, label);
/*
 * Create a SFILE Object to show this source file in the dialog
 */
    sfile = MCreateSFile(cform, __FILE__, FIXED_MEDIUM, 10, 48);
    MObjectSetColor(sfile, darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
    pbutton = MCreatePButton(shell, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseDialogCB, 0L);

    MShellRealize(shell);
}
