/*
 *    File fontview.c
 *      Demonstrates the Font loading technique
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

#if defined __GNUC__ && !defined __RSXNT__
#define stricmp strcasecmp
#endif

extern void CloseDialogCB(MOBJECT p, void *s, void *v);
extern MTColor black, white, darkblue, cadetblue, seagreen;

MOBJECT drawa, e_fname, e_fsize;

MTFont font = FIXED_MEDIUM;
int bold = False;
int italic = False;

/***************************************************************
 *	This callback toggles the Bold attribute
 ***************************************************************/
static void 
SetBoldCB(MOBJECT obj, MVALUE a, void *data)
{
    bold = (int) a;
}

/***************************************************************
 *	This callback toggles the Italic attribute
 ***************************************************************/
static void 
SetItalicCB(MOBJECT obj, MVALUE a, void *data)
{
    italic = (int) a;
}

/***************************************************************
 *	This callback Unloads the latest loaded font and
 *	destroys the dialog
 ***************************************************************/
static void 
CloseFontViewCB(MOBJECT p, void *a, void *data)
{
    if (font != FIXED_MEDIUM)
	MUnloadFont(font);
    font = FIXED_MEDIUM;
    p = MObjectShell(p);

    MShellUnrealize(p);
    MShellDestroy(p);
}

/***************************************************************
 *	This callback tries to load the specified font
 ***************************************************************/
static void 
LoadFontCB(MOBJECT obj, void *a, void *data)
{
    MTFont newfont;
    int size;
    char family[32], buff[8];
/*
 * Get user preferences from the EDIT Objects
 */
    MObjectGetText(e_fname, family);
    MObjectGetText(e_fsize, buff);
    size = atoi(buff);
    newfont = MLoadFont(family, size, bold, italic);
/*
 * The function returns FIXED_MEDIUM on failure
 */
    if (newfont != FIXED_MEDIUM)
    {
	if (font != FIXED_MEDIUM)
	    MUnloadFont(font);
	font = newfont;
	MObjectRedraw(drawa);
    }
    else
	MBeep();
}

/***************************************************************
 *	This callback draws strings using the selected font
 ***************************************************************/
static void 
DrawAreaExposeCB(MOBJECT obj, MEvent * pe, void *data)
{
    MDrawText(obj,
	      0, 0, MObjectGetWidth(obj), MObjectGetHeight(obj) / 2,
	      "AaBbCcDdEeFfGgHhIiJjKkLlMm",
	      font, black, CENTER_ALIGN);
    MDrawText(obj,
       0, MObjectGetHeight(obj) / 2, MObjectGetWidth(obj), MObjectGetHeight(obj) / 2,
	      "NnOoPpQqRrSsTtUuWwYyXxZz",
	      font, black, CENTER_ALIGN);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void 
FontViewCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT pbutton, shell, form;
	MOBJECT tbutton, sfile, list;
	const char *family;

	bold = False;
	italic = False;

    shell = MCreateShell("Font Browser", SF_MODAL);

    form = MCreateColForm(shell);
//	MRightAttach(form, F_ATT_NONE, 0, 0);

/*
 * The Option Edit contains the known font families
 */
	family = MGetFirstFontFamily();
    e_fname = MCreateOptionEdit(form, family, 32, 32, 8, FIXED_MEDIUM);
    list = MOptionEditGetList(e_fname);
	MSListSetSortCallback(list, stricmp);

	while (family)
	{
		MSListAddItem(list, family, 0L);
		family = MGetNextFontFamily();
	}

    e_fsize = MCreateEdit(form, "18", 2, FIXED_MEDIUM);

    tbutton = MCreateTButton(form, "&Bold", HELV_MEDIUM);
    MTButtonSetCallback(tbutton, SetBoldCB, 0L);
	MObjectSetResize(tbutton, False, False);

    tbutton = MCreateTButton(form, "&Italic", HELV_MEDIUM);
    MTButtonSetCallback(tbutton, SetItalicCB, 0L);
	MObjectSetResize(tbutton, False, False);

    pbutton = MCreatePButton(form, "&Test", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, LoadFontCB, 0L);

    drawa = MCreateDrawArea(shell, 320, 120);
	MObjectSetResize(drawa, True, False);
    MDrawAreaSetExposeCallback(drawa, DrawAreaExposeCB, 0L);

    sfile = MCreateSFile(shell, __FILE__, FIXED_MEDIUM, 10, 60);
    MObjectSetColor(sfile, darkblue, white);

    pbutton = MCreatePButton(shell, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseFontViewCB, 0L);

    MShellRealize(shell);
}
