// MiniFTP copyright 1997 Paul Gerhart pgerhart@voicenet.com
// XportDlg.cpp : implementation file
//

#include "stdafx.h"
#include "miniftp.h"
#include "XportDlg.h"
#include "Choosdir.h" // the directory picker helper

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXport dialog


CXport::CXport(CWnd* pParent /*=NULL*/)
	: CDialog(CXport::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXport)
	m_nRadioASCII = -1;
	m_sIncomingPath = _T("");
	//}}AFX_DATA_INIT
}


void CXport::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXport)
	DDX_Radio(pDX, IDC_RADIO_BIN, m_nRadioASCII);
	DDX_Text(pDX, IDC_EXPORTBOX, m_sIncomingPath);
	DDV_MaxChars(pDX, m_sIncomingPath, 300);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXport, CDialog)
	//{{AFX_MSG_MAP(CXport)
	ON_BN_CLICKED(IDC_BROWSEBUTTON, OnBrowsebutton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXport message handlers

/////////////////////////////////////////////////////////////////////////////
// launch the directory picker
void CXport::OnBrowsebutton() 
{
	// save any edit in the other controls else they will be destroyed when the 
	//		screen repaints on dialog exit
	UpdateData(TRUE);
	CChooseDir   dlg(FALSE, 
									NULL, 
									NULL, 
									OFN_SHOWHELP |
										OFN_HIDEREADONLY |
										OFN_OVERWRITEPROMPT | 
										OFN_ENABLETEMPLATE |
										OFN_NONETWORKBUTTON, // my addition
									NULL);

	// I commented this out
	//CWinApp*        pApp;
	//pApp = AfxGetApp();

	// this is where I modified it somewhat
	/*CString sDrive = ""; // set to safe value
	CString sDirectory = ""; // set to safe value

	UpdateData(TRUE);
	if( m_sPathOut.GetLength() >2 )
	{
		sDirectory = m_sPathOut;
		sDrive = sDirectory.Left(3);
	} // end of my mods
	*/

	/*  my comment out
	CString sDrive = pApp->GetProfileString("Setting", 
									"DefaultDir","");
	CString sDirectory = pApp->GetProfileString("Setting",
									"TargetDir", szDrive);
	if (szDrive != szDirectory.Left(3))
	{
		szDirectory = szDrive;
	}*/

	dlg.m_ofn.lpstrInitialDir = (LPCTSTR)(const char *)m_sIncomingPath;

	if (IDOK == dlg.DoModal())
	{
		// must have this for it to work
		WORD wFileOffset;
		wFileOffset = dlg.m_ofn.nFileOffset;
		dlg.m_ofn.lpstrFile[wFileOffset-1] = 0;

		// I commented this out
		//sDirectory = dlg.m_ofn.lpstrFile;
		//sDirectory.MakeUpper();
		//sDrive = sDirectory.Left(3);

		// I commented this out
		//pApp->WriteProfileString("Setting", "TargetDir", szDirectory);
		//pApp->WriteProfileString("Setting", "DefaultDir", szDrive);

		// I added this 
		m_sIncomingPath = dlg.m_ofn.lpstrFile;
		UpdateData(FALSE);

		// I commented this out
		//CString szTemp;
		//szTemp.Format("Region Filer - [%s\\*]", szDirectory);
		//SetWindowText(szTemp);  // Place szTemp in Title bar
	}	
}






/*
	UpdateData(TRUE);
	// filter
	static char BASED_CODE szFilter[50];
//	= "Data Files (*.xlc;*.xls)|*.xlc; *.xls|All Files (*.*)|*.*||";
//	 static char BASED_CODE szFilter[] ="Text Files (*.txt)|*.txt| All Files (*.*)|*.*||";
  
	// setup based on the file type radio button
	// bias if for text
	CString sExt = "txt";
	strcpy(szFilter, "Text Files (*.txt)|*.txt| All Files (*.*)|*.*||" );
	CFileDialog fileDialog(		FALSE, // so Save As
											(LPCTSTR)sExt, // extension
											(LPCTSTR)m_sIncomingPath,	// starter name
										//	OFN_EXPLORER |		// controls
											OFN_LONGNAMES |
											OFN_HIDEREADONLY ,		 
										//	OFN_OVERWRITEPROMPT,  I'll do my own checking in parent
											szFilter,	 //  filter
											NULL );	 // parent

	if( fileDialog.DoModal() == IDOK)
	{
		m_sIncomingPath = fileDialog.GetPathName();
		UpdateData(FALSE);
	} 
}*/

void CXport::OnOK() 
{
	UpdateData(TRUE);
	if( m_sIncomingPath.GetLength() )
	{
		CDialog::OnOK();
	}
	else
	{
		AfxMessageBox("You must supply a path name");
	}
}
