//
//                oooooooooo.
//                `888'   `Y8b
//                 888     888  .ooooo.    oooooooo  .ooooo.
//                 888oooo888' d88' `88b  d'""7d8P  d88' `88b
//                 888    `88b 888   888    .d8P'   888   888
//                 888    .88P 888   888  .d8P'  .P 888   888
//                o888bood8P'  `Y8bod8P' d8888888P  `Y8bod8P'
//                           _
//                          /_\     |    _  _ | _ ._
//                         /   \  \_||_|(_|(_||(/_|
//                                       _| _|
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// Semaphores
//
//  This module performs double duty as the Semaphore library and
//  the task-switch request library.
//
//

#ifndef __BZ_SEMAPHORE_H
#define __BZ_SEMAPHORE_H 1

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

#ifdef __cplusplus
extern "C" {
#endif

//
//
//                                Includes
//
//

#include "bzqueue.h"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

typedef struct _bz_semaphore bz_semaphore;
struct _bz_semaphore
{
    int             count;
    bz_task_queue   waiting;
};

//
//
//                               Prototypes
//
//

void bzsem_init (bz_semaphore *sem, unsigned);
void bzsem_wait (bz_semaphore *sem);
void bzsem_signal (bz_semaphore *sem);

// Separate?
void bz_yield (bz_task_queue *, bz_task_queue *);
void bz_suspend (void);

#ifdef __cplusplus
}
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - bzsemap.h 
