//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//    Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// xfini.hpp
//
//      This contains an object for parsingg .INI-style files.  These
//      are text-based data files with headings and subsections of the
//      format:
//
//         [heading-name]
//         item=value
//
//

#ifndef __XFINI_HPP
#define __XFINI_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include "xfbase.hpp"

//
//
//                                Equates
//
//

//--- Compile time value ---

const ulong XF_MAX_ININAME=256;    // Maximum size of item or section name.
const ulong XF_MAX_INIVALUE=1024;  // Maximum size of a value

//
//
//                                Classes
//
//

class XFParseINI {
   XFileDOS xfile;

protected:
   XFile           *xf;

   xf_error_codes  errorn;

   ulong           buffsize;
   char            *buff;
   char            sectname[XF_MAX_ININAME];

           //Ŀ
           // Loads the internal buffer from the open file handle.          
           //
   xf_error_codes load(void);

           //Ŀ
           // Returns the start position in buffer for active section       
           //
   char *start(void);

           //Ŀ
           // Scans the buffer for the variable starting with 'start'.  0   
           // is returned if not found.                                     
           //
   char *find(char *ptr, const char *item);

public:
   XFParseINI();
   XFParseINI(XFile *f);
   ~XFParseINI();

   void attach(XFile *f) { if (!f) {xf=&xfile;} else {xf=f;} };

   xf_error_codes error(void) { return errorn; };

           //Ŀ
           // Quick access functions for the XFile object embedded.         
           //
   xf_error_codes open(const char *name, dword flags)
           { xf_error_codes err=xf->open(name,flags|XF_OPEN_READ);
             if (!err) {return begin();}
             errorn=err;
             return err; };
   xf_error_codes create(const char *name, dword flags)
           { xf_error_codes err=xf->create(name,flags|XF_OPEN_READ);
             if (!err) {return begin();}
             errorn=err;
             return err; };
   xf_error_codes close(void)
           {  end();
              xf_error_codes err=xf->close();
              if (err) errorn=err;
              return err; };

           //Ŀ
           // These must be called if the XFile object is not opened/closed 
           // via the member functions for this object.                     
           //
   xf_error_codes begin(void);
   xf_error_codes end(void);

           //Ŀ
           // Sets processing to the given named section.  If writing, and  
           // the section doesn't exist, a new section is created.          
           //
   xf_error_codes section(const char *name);

           //Ŀ
           // Reads an item=value pair from the file, using the current     
           // section, if any set.                                          
           //
   xf_error_codes read(const char *item, char *value);
   xf_error_codes read(const char **item, char **value);
   int read(const char *item);

           //Ŀ
           // Writes an item=value pair to the file, using the current      
           // section, if any set.                                          
           //
   xf_error_codes write(const char *item, const char *value);
   xf_error_codes write(const char **item, const char **value);
   xf_error_codes write(const char *item, int value);
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - xfini.hpp 

