//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
//                       *** IPAS Mesh Data Exporter ***
//
// uiquery.c
//
// Contains the user-interface for the texture resize query.
//
//

//
//
//                                Includes
//
//

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <debug.h>

#include "xfdefs.h"

#include "pxp.h"
#include "dialog.h"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

//
//
//                               Routines
//
//

// Feel functions
static void feel_ok(Dialog *d, int mouse);
static void feel_xy(Dialog *d, int mouse);

//
//
//                                 Data
//
//

static int loop_done;

//Ŀ
// Make sure that 'empty' strings in .3DE file are filled with dummy values,
// otherwise the compiler makes them all point to the same string, assuming 
// it is static.  This is wrong and results in editables pointing to the    
// string.                                                                  
//
#include "eschqry.3de"

static FeelSub EschQry_feel[] =
{
    OK,         feel_ok,
    -1, FNULL
};

int query_xsize=128;
int query_ysize=128;

static RadSub EschQry_rad[] =
{
    X16, feel_xy, &query_xsize, 16,
    X32, feel_xy, &query_xsize, 32,
    X64, feel_xy, &query_xsize, 64,
    X128, feel_xy, &query_xsize, 128,
    X256, feel_xy, &query_xsize, 256,

    Y16, feel_xy, &query_ysize, 16,
    Y32, feel_xy, &query_ysize, 32,
    Y64, feel_xy, &query_ysize, 64,
    Y128, feel_xy, &query_ysize, 128,
    Y256, feel_xy, &query_ysize, 256,

    -1, FNULL, NULL, -1
};

static int nframes;

//
//
//                                 Code
//
//

//Ŀ
// do_query                                                                 
//                                                                          
// Do texture resize query dialog.                                          
//
void do_query(char *image, int orgxsize, int orgysize, int orgframes)
{
    static int  inited = 0;

    if (!inited)
    {
        init_dialog(EschQry, NULL, NULL);
        inited = 1;
    }

    loop_done=0;

    ready_dialog(EschQry, NULL, NULL, EschQry_feel, EschQry_rad,
                NULL, NULL);

    strcpy(EschQry_name,image);

    nframes = orgframes;
    if (orgframes > 1)
    {
        sprintf(EschQry_orgsize,"%d by %d   %d frames",
                                orgxsize,orgysize,orgframes);
        sprintf(EschQry_bytes,"%5d bytes (%7d total)",
                               query_xsize * query_ysize,
                               query_xsize * query_ysize * orgframes);
    }
    else
    {
        sprintf(EschQry_orgsize,"%d by %d",
                                orgxsize,orgysize);
        sprintf(EschQry_bytes,"%5d bytes",query_xsize * query_ysize);
    }

    while (!loop_done)
    {
        center_dialog(EschQry);
        save_under_dialog(EschQry);
        draw_dialog(EschQry);
        do_dialog(EschQry, -1);
    }
}


//Ŀ
//                             static                                 
// Feel functions                                                           
//
static void feel_ok(Dialog *d, int mouse)
{
    if(mouse)
        if(!(press_button(d)))
            return;

    dialog_done=1;
    restore_under_dialog();

    loop_done=1;
}

static void feel_xy(Dialog *d, int mouse)
{
    feel_radio(d,mouse);

    if (nframes > 1)
    {
        sprintf(EschQry_bytes,"%5d bytes (%7d total)",
                               query_xsize * query_ysize,
                               query_xsize * query_ysize * nframes);
    }
    else
    {
        sprintf(EschQry_bytes,"%5d bytes",query_xsize * query_ysize);
    }

    draw_dialog_entry(EschQry, BYTES);
}

// End of module - uiquery.c 
