//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// escontxt.hpp
//
// The EschContext class provides the current drawing information such
// as current camera, light list, and drawable object list.  Contexts
// are maintained as a stack of objects for dynamic adjustment of
// the drawing context.
//
// EschContext class are used implictly by the various other classes, but
// can be controlled by the application to provide multiple drawing
// contexts.
//
//

#ifndef __ESCONTXT_HPP
#define __ESCONTXT_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Data
//
//

class EschContext;

//Ŀ
// Pointer to the currently active context used by all other objects.       
//
extern EschContext *EschCurrent;

//
//
//                                Classes
//
//

class EschLight;
class EschCamera;
class EschDrawable;

class EschFace;
class EschVertex;
class EschTexture;
class VngoPoint;

//Ŀ
// EschContext                                                              
//
class EschContext {

    //Ŀ
    // Protected data members                                               
    //
    EschContext *prev;

public:
    //Ŀ
    // Public data members                                                  
    //

    // Rendering globals

    EschCamera      *camera;                // Current camera
    EschLight       *lights;                // Light list
    EschDrawable    *eschs;                 // Drawable object list

    // Face drawing globals (used internally)

    EschDrawable    *current;

    EschVertex      *verts;
    dword           *vflags;
    VngoPoint       *vpoints;

    EschFace        *faces;
    dword           *fflags;

    EschTexture     **txts;

    dword           color;
    dword           alpha;

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschContext() : camera(0), lights(0), eschs(0) {}
    EschContext(const EschContext *c)
    {
        if (c)
            *this=*c;
        else
        {
            camera=0;
            lights=0;
            eschs=0;
        }
    }

    ~EschContext() {}

    //Ŀ
    // Operations                                                           
    //
    void push()
    {
        if (this != EschCurrent)
        {
            prev = EschCurrent;
            EschCurrent = this;
        }
    }
    void pop()
    {
        if (this == EschCurrent)
            EschCurrent = prev;
    }
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - escontxt.hpp 

