//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// esexts.hpp
//
// Contains the extents classes.
//
// EschSphereExtents is the container type for spherical extents.
//
// EschBoxExtents is the container type for bounding box extents.
//
//

#ifndef __ESEXTS_HPP
#define __ESEXTS_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include "esmath.hpp"

//
//
//                                Classes
//
//

//Ŀ
// EschSphereExtents - Spherical extents class.                             
//
class EschSphereExtents {

public:
    //Ŀ
    // Public data members                                                  
    //
    EschPoint       center;
    float           radius;

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschSphereExtents() {}
    EschSphereExtents(float x, float y, float z, float r) :
        center(x,y,z),
        radius(r) {}
    EschSphereExtents(const EschPoint *p, float r) :
        center(*p),
        radius(r) {}

    ~EschSphereExtents() {}

    //Ŀ
    // Operations                                                           
    //
    void draw(const EschFrameRef *fr, dword clr) const;

    int hit(const EschPoint *pt) const;
    int hit(const EschPoint *pt, const float r) const;

    float ray(const EschPoint *pt, const EschVector *v) const;
};


//Ŀ
// EschBoxExtents -  Box extents class.                                     
//
class EschBoxExtents {

public:
    //Ŀ
    // Public data members                                                  
    //
    float           mins[3];
    float           maxs[3];

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschBoxExtents() {}
    EschBoxExtents(float minx, float miny, float minz,
                   float maxx, float maxy, float maxz)
        { mins[0] = minx; mins[1] = miny; mins[2] = minz;
          maxs[0] = maxx; maxs[1] = maxy; maxs[2] = maxz; }
    EschBoxExtents(const EschPoint *min, const EschPoint *max)
        { mins[0] = min->x; mins[1] = min->y; mins[2] = min->z;
          maxs[0] = max->x; maxs[1] = max->y; maxs[2] = max->z; }

    ~EschBoxExtents() {}

    //Ŀ
    // Operations                                                           
    //
    void draw(const EschFrameRef *fr, dword clr) const;

    int hit(const EschPoint *pt) const;
    int hit(const EschPoint *pt, const float r) const;

    float ray(const EschPoint *pt, const EschVector *v) const;
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - esexts.hpp 

