//
//           __ ,
//            ,-| ~           ,               ,,
//           ('||/__,        ||               ||                  _
//          (( |||  | \\ \\ =||=   _-_  \\/\\ ||/|,  _-_  ,._-_  / \\
//          (( |||==| || ||  ||   || \\ || || || || || \\  ||   || ||
//           ( / |  , || ||  ||   ||/   || || || |' ||/    ||   || ||
//            -____/  \\/\\  \\,  \\,/  \\ \\ \\/   \\,/   \\,  \\_-|
//                                                               /  \
//                                                              '----`
//                     Text Output and Font Management System
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// gutenbrg.hpp
//
// C++-interface include header.
//
//

#ifndef __GUTENBRG_HPP
#define __GUTENBRG_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include <stdlib.h>

#include <vangogh.hpp>

#include "gutenbrg.h"

//
//
//                               Prototypes
//
//

//Ŀ
// Text output functions.                                                   
//

// these must be C++ since Van Gogh is not C-callable

long gberg_outc(VngoVport *vp, long x, long y, char c, BOOL vert=FALSE);

long gberg_widthc(char c);
long gberg_heightc();

long gberg_width(const char *str);

//
//
//                                Classes
//
//

//Ŀ
// System class                                                             
//
class GBergSystem
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    GBergSystem() { gberg_init(); }
    ~GBergSystem() { gberg_term(); }

    //Ŀ
    // Operations                                                           
    //
    gberg_error_codes color(dword fc, dword bc=VNGO_TRANSPARENT)
                                           { return gberg_color(fc,bc); }
    gberg_error_codes select_font(const char *f) { return gberg_select_font(f); }
    gberg_error_codes install_font(const char *fn, const char *f) { return gberg_install_font(fn,f); }
    gberg_error_codes remove_font(const char *f) { return gberg_remove_font(f); }
    gberg_error_codes info_font(const char *f, GBergFontInfo *i) const { return gberg_info_font(f,i); }

    gberg_error_codes select_strings(const char *t) { return gberg_select_strings(t); }
    gberg_error_codes install_strings(const char *fn, const char *t) { return gberg_install_strings(fn,t); }
    gberg_error_codes remove_strings(const char *t) { return gberg_remove_strings(t); }
    gberg_error_codes info_strings(const char *t, GBergTextInfo *i) { return gberg_info_strings(t,i); }

};


//Ŀ
// Text output class                                                        
//
class GBergText {
public:
    //Ŀ
    // Public data members (should be changed only by utility functions).   
    //
    long       curx;       // Current X position (in pixels)
    long       cury;       // Current Y position (in pixels)
    VngoVport  *vport;

    //Ŀ
    // Constructor/Destructors                                              
    //
    GBergText(VngoVport *vp) { vport=vp; curx=cury=0; }
    ~GBergText() {}

    //Ŀ
    // Operations                                                           
    //
    void outc(char c);
    void outc(long x, long y, char c) { curx=x; cury=y; outc(c); }
    void outc_vert(char c);
    void outc_vert(long x, long y, char c) { curx=x; cury=y; outc_vert(c); }

    void out(const char *str);
    void out(long x, long y, const char *str) { curx=x; cury=y; out(str); }
    void out_vert(const char *str);
    void out_vert(long x, long y, const char *str) { curx=x; cury=y; out_vert(str); }

    void out(long num);
    void out(long x, long y, long num) { curx=x; cury=y; out(num); }
    void out_vert(long num);
    void out_vert(long x, long y, long num) { curx=x; cury=y; out_vert(num); }

    void outf(const char *fmt, ...);
    void outf_vert (const char *fmt, ...);

    void out_wrap(const char *, const VngoRect * = 0);

    void setpos(byte row, byte col);
    void getpos(byte *row, byte *col) const;
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - gutenbrg.hpp 

