//
//           __ ,
//            ,-| ~           ,               ,,
//           ('||/__,        ||               ||                  _
//          (( |||  | \\ \\ =||=   _-_  \\/\\ ||/|,  _-_  ,._-_  / \\
//          (( |||==| || ||  ||   || \\ || || || || || \\  ||   || ||
//           ( / |  , || ||  ||   ||/   || || || |' ||/    ||   || ||
//            -____/  \\/\\  \\,  \\,/  \\ \\ \\/   \\,/   \\,  \\_-|
//                                                               /  \
//                                                              '----`
//                     Text Output and Font Management System
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// global.hpp
//
//

#ifndef __GLOBAL_HPP
#define __GLOBAL_HPP    1

//
//
//                                Includes
//
//

// NOTE: the including file must define any Windows control defines

#include <windows.h>
#include <stdio.h>

#include "portable.h"
#include "debug.h"

#include <ivory.hpp>
#include <max.hpp>
#include <vangogh.hpp>

#include "gutenbrg.hpp"

//
//
//                                Equates
//
//

#if defined (WIN32)
        #define IS_WIN32 TRUE
#else
        #define IS_WIN32 FALSE
#endif
#define IS_NT      IS_WIN32 && (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S  IS_WIN32 && (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_CHICAGO (BOOL)(!(IS_NT) && !(IS_WIN32S)) && IS_WIN32

//
//
//                               Structures
//
//

//
//
//                                Classes
//
//

// The game class
class GameState
{
protected:
    TCHAR   szFileName[MAX_PATH];

    MaxDevices      *devs;
    MaxEventSource  *evt;           // Source of our events
    MaxEventListOneshot oneshot;    // Track events for single_events
    MaxEventList    events;         // Most current event set
    MaxEventList    single_events;  // Most current event set, momentary

public:     // Construction/Destruction
    enum { MAP_XSIZE = 320, MAP_YSIZE = 200 };
    BITMAPINFO      *bmi;
    BYTE            *gmap;
    VngoVport       *gvp;
    VngoPal         *mypal;

    GameState (MaxDevices *);
    ~GameState ();

public:     // Misc. Members
    BOOL    active;
    int     page;

            // Per-Frame Members
    virtual BOOL    PumpWindows ();
    virtual void    LoadEvents (LPCSTR lpszFile);
    virtual void    GetEvents ();
    virtual void    ProcessEvents();
    virtual void    Render();
    virtual void    Display();
};


//
//
//                               Prototypes
//
//

//
//
//                                 Data
//
//

extern HINSTANCE   hInst;         // current instance
extern HWND        hWndClient;    // Main window handle
extern const char  szAppName[];
extern GameState   *game;


#endif

// End of header - global.hpp 

