//
//                                   ____
//                                  / __ \
//                                 ( (__) )
//                                 _\____/___
//                                /  |  |   /\
//                               /_________/  \_
//                              /          \    \
//                             /            \    \_
//                            /              \     \
//                           /                \     \_
//                          /                  \      \
//                         /                    \      \_
//                        /                      \       \
//                       /                        \       \_
//                      /                          \        \
//                     /                            \        \_
//                    /                              \         \
//                   / N  N EEE W   W TTTTT  OO  N  N \        /
//                  /  NN N E_  W   W   T   O  O NN N  \      /
//                 /   N NN E   W W W   T   O  O N NN   \    /
//                /    N  N EEE  W W    T    OO  N  N    \  /
//               /________________________________________\/
//
//                     Newtonian Physics Simulation Library
//
//                      Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// newtforc.cpp
//
// Force Class implementation.
//
//

//
//
//                                Includes
//
//

#include <newton.hpp>

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//
//  NewtForce - Constructor
//
NewtForce::NewtForce (const NewtVector &_vector) :
    vector (_vector)
{
}


//
//  NewtForce - Constructor alternative
//
NewtForce::NewtForce (float i, float j, float k) :
    vector (i, j, k)
{
}


//
//  NewtForce - Default Constructor
//
NewtForce::NewtForce () :
    vector (0, 0, 0)
{
}


//
//  NewtForce - Destructor
//
NewtForce::~NewtForce ()
{
}



//
//  Operations  
//

//
//  NewtonForce - affect_permanent
//
void NewtForce::affect_permanent (NewtObject *ob) const
{
    assertMyth("NewtForce::affect_permanent needs NewtObject with non-zero mass",
               ob != 0 && ob->mass != 0);

    ob->acceleration += vector / ob->mass;
}


//
//  NewtonForce - affect
//
void NewtForce::affect (NewtObject *ob) const
{
    assertMyth("NewtForce::affect needs NewtObject with non-zero mass",
               ob != 0 && ob->mass != 0);

    ob->temp_acceleration += vector / ob->mass;
}

// End of module - newtforc.cpp 

