
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: intmodp.h,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#ifndef __CAINTEGERMODP_HEADER__
#define __CAINTEGERMODP_HEADER__

#include "cobject.h"

#define USHRT_MAX_PRIME 65521U
typedef unsigned short modp_t;

typedef unsigned short modp_c;
typedef modp_t *modpseq_t;
typedef struct
  {
    unsigned short p;
  }
modp_args;

#define modp_isvalue		1
#define modp_pervalue	1

@interface IntegerModp : CAObject
{
  modp_t value;
  unsigned short modulus;
}

+ new;
+ modulus:(unsigned short)aPrime;
- _setUpIntValue:(int)intValue modulus:(unsigned short)aPrime;
- int:(int)intValue modulus:(unsigned short)aPrime;
+ int:(int)intValue modulus:(unsigned short)aPrime;
- class_vector;
- class_vardnsrecdegsps_polynomial;
- class_vardnsrecdegdns_polynomial;
- class_vardnsexpdegsps_polynomial;
- clone;
- (modp_t) modp_value;
- modp_value:(modp_t)aValue;
- (modp_t *) modp_reference;
- modp_reference:(modp_t *)aValue;

- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (unsigned short) modulus;
- (int) intValue;
- intValue:(int)aValue;

- zero;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;

- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) notOne;
- (BOOL) isMinusOne;
- (BOOL) notMinusOne;
- square;
- squareSelf;
- multiply:b;
- multiplySelf:b;
- inverse;
- inverseSelf;
- divide:b;
- _add:(int)v:B multiply:b:(int)w;
- _addSelf:(int)v:B multiply:b:(int)w;
- _multiply:a:(int)v add:B:(int)w;
- _multiplySelf:a:(int)v add:B:(int)w;
- _multiply:a:(int)v add:B multiply:b:(int)w;
- _multiplySelf:a:(int)v add:B multiply:b:(int)w;

- (int) characteristic;
- frobenius;
- frobeniusInverse;

- (BOOL) printsLeadingSign;
- printOn:(IOD)aFile;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __CAINTEGERMODP_HEADER__ */
 
