// DialogListBox.cpp : implementation file
//

#include "stdafx.h"
#include "OzAPI.h"
#include "DialogListBox.h"
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogListBox dialog


CDialogListBox::CDialogListBox(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogListBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogListBox)
	m_prompt = _T("");
	//}}AFX_DATA_INIT
}


void CDialogListBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogListBox)
	DDX_Control(pDX, IDC_LIST, m_lb);
	DDX_Text(pDX, IDC_TEXT, m_prompt);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogListBox, CDialog)
	//{{AFX_MSG_MAP(CDialogListBox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogListBox message handlers





///////////////////  FORTRAN /////////////////////////////////////



// global param copies slack!!!

static char* g_fileName;
static char* g_items;
static long g_itemSize;
static long g_numItems;
static int	g_selected;
static CString g_selectedString;
 
extern "C" void ozfilelistboxdlg (char* prompt, char* fileName, long* item, 
								  char* text, long* lenStr)
{
	CDialogListBox*  dlg;
	int i;
	char* out;
	int	num;

	g_fileName = fileName;
	g_items = NULL;
	g_itemSize = 0;
	g_numItems = 0;
	g_selected = 0;
	g_selectedString = "NONE";
	dlg = new CDialogListBox;
	dlg->m_prompt = prompt;

	if (dlg->DoModal() == IDOK)
	{
		*item = ++g_selected; // first is 1
		out = (char*) LPCSTR(g_selectedString);
		num = strlen(out);
		strcpy(text, out);
		for (i=num; i<*lenStr; i++)
			text[i] = ' ';
	}

	delete dlg;
	return;
}

extern "C" long ozlistboxdlg (char* prompt, char* items, long* itemSize, long* numItems)
{
	CDialogListBox*  dlg;
	long result = 0;

	g_fileName = NULL; // acts as flag

	if (*numItems < 2)
		OzFatalError ("ozlistboxdlg - illegal number items");
	if (*itemSize < 2 || *itemSize > 200)
		OzFatalError ("ozlistboxdlg - illegal item size");
	g_items = items;
	g_itemSize = *itemSize;
	g_numItems = *numItems;
	g_selected = 0;
	g_selectedString = "NONE";
	dlg = new CDialogListBox;
	dlg->m_prompt = prompt;

	if (dlg->DoModal() == IDOK)
	{
		result = ++g_selected; // first is 1
	}

	delete dlg;
	return(result);
}


BOOL CDialogListBox::OnInitDialog() 
{
	int		i;
	char*	ptr;
	CStdioFile	f;
	char	buff[205];

	CDialog::OnInitDialog();
	if (g_fileName) // load from file
	{
		if (!f.Open(g_fileName, CFile::modeRead))
			OzFatalError ("ozfilelistboxdlg - cannot open file");
		while (f.ReadString(buff, 100))
		{
			i = (int)strlen(buff)-1;
			while (i > 0 && (buff[i]=='\r'||buff[i]=='\n'||buff[i]==' '))
			{
				buff[i] = '\0';
				i--;
			}
			m_lb.AddString(buff);
		}
		f.Close();  
	}
	else // load from string array
	{
		ptr = g_items;
		for (i=0; i<g_numItems; i++)
		{
			strncpy(buff,ptr,g_itemSize); // may not be null terminated
			buff[g_itemSize] = '\0';
			m_lb.AddString(buff);
			ptr += g_itemSize;
		}
	}
	
	m_lb.SetCurSel(0);
	return TRUE; 
}


void CDialogListBox::OnOK() 
{
		g_selected = m_lb.GetCurSel();
		m_lb.GetText(g_selected, g_selectedString);
	
	CDialog::OnOK();
}
