// OzAPIView.cpp : implementation of the COzAPIView class
//

#include "stdafx.h"
#include "OzAPIDoc.h"
#include "OzAPIView.h"

#include "OzAPI.h"
#include "OzGKS.h"
#include "OzFTN.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COzAPIView

IMPLEMENT_DYNCREATE(COzAPIView, CView)

BEGIN_MESSAGE_MAP(COzAPIView, CView)
	//{{AFX_MSG_MAP(COzAPIView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COzAPIView construction/destruction

COzAPIView::COzAPIView()
{
	m_firstDraw = TRUE;
	//this->Invalidate();	// force draw to get screen params etc
}

COzAPIView::~COzAPIView()
{
}

BOOL COzAPIView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// COzAPIView drawing

void COzAPIView::OnDraw(CDC* pDC)
{
	COzAPIDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	GKSonDraw (pDoc, this, pDC, m_firstDraw);	// pass to GKS system
	if (m_firstDraw)
	{
		m_firstDraw = FALSE;
		OZINIT();	// Fortran initialisation
	}
}

// COzAPIView printing

void COzAPIView::OnPrint(CDC* pDC, CPrintInfo *pInfo)
{
	COzAPIDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	GKSonPrint (pDoc, this, pDC, pInfo);	; // pass to GKS system
}

/////////////////////////////////////////////////////////////////////////////
// COzAPIView printing

BOOL COzAPIView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void COzAPIView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void COzAPIView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


/////////////////////////////////////////////////////////////////////////////
// COzAPIView diagnostics

#ifdef _DEBUG
void COzAPIView::AssertValid() const
{
	CView::AssertValid();
}

void COzAPIView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

COzAPIDoc* COzAPIView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(COzAPIDoc)));
	return (COzAPIDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COzAPIView message handlers


/////////////// Busy cursor ///////////////////////////////////

BOOL	isBusy = FALSE;

extern "C" void ozbusy ()
{
	isBusy = TRUE;
	SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
}

extern "C" void oznotbusy ()
{
	isBusy = FALSE;
	SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
}



////////////// GKS cursor //////////////////////////////


void COzAPIView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (isBusy)
		SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
	else
		GKSonLButtonDown(point);
}

void COzAPIView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if (isBusy)
		SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
	else
		GKSonLButtonUp(point);
}

void COzAPIView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (isBusy)
		SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
	else	
	GKSonMouseMove(point);
}

