// gksCursor.h : interface of the CgksCursor class for basic Xhair
//					serves as base class for diff cursor types
//


class CgksCursor : public CgksObject
{
public:
CgksCursor::CgksCursor(long type, float* initialData, long handle, BOOL callback);
virtual ~CgksCursor();

protected:


// Attributes
protected:
long						m_type;			// type of cursor
											//	1 = cross hair 
											//	2 = box cursor
											//	3 = circle type
											//	4 = straight line 
											//	5 = fixed size box
											//	6 = digitise line
	CArray<CPoint,CPoint>	m_screenPoint;  // ready for display
	float					m_extra;		// currently the radius
	long					m_handle;		// user identifier
	BOOL					m_drawing;		// if in process of drawing the cursor
	BOOL					m_doCallback;	// if callback routine or one-time
public:

// Operations
public:
	virtual void ButtonDown(CClientDC* pDC, CPoint point);
	virtual void ButtonUp(CClientDC* pDC, CPoint point);
	virtual void MouseMove(CClientDC* pDC, CPoint point);

protected:
void GKScallback();
};
