// gksSegment.cpp : implementation file
//

#include "stdafx.h"
#include "OzAPI.h"
#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "OzGKS.h"
#include "gksObject.h"
#include "gksLine.h"
#include "gksText.h"
#include "gksMarker.h"
#include "gksPolygon.h"
#include "gksSegment.h"
#include "gksViewport.h"
#include "gksWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CgksSegment

CgksSegment::CgksSegment()
{
	m_clipOn = FALSE;
	m_pickable = FALSE;
}


CgksSegment::~CgksSegment()
{
}


// add a new GKS object to the array, calc MBR

int CgksSegment::Add (CgksObject* newElement)
{
	int	index;
	index = CObArray::Add(newElement); // add using standard
	index++;	// fortran index	
	return (index);
}

// find entry in segment of given type. NULL returned if invalid index

CgksObject* CgksSegment::Find (int handle, int type)
{
	int	index;
	CgksObject* obj;
	index = handle-1;
	obj = (CgksObject*) CObArray::GetAt(index);
	if (obj)
	{
		if (obj->m_objType != type)
			obj = NULL;  // wrong type of gks object
	}
	return (obj);
}


// clear the segment, delete all GKS objects

void CgksSegment::Clear()
{
	CObject*	obj;
	int			num, i;

	num = this->GetSize();
	for (i=0; i<num; i++)
	{
		obj = this->GetAt(i);	// delete all GKS objects in segment
		delete obj;
	}
	this->RemoveAll();
}


// draw all objects in this segment

void CgksSegment::DrawAll(CDC* pDC, BOOL needTransform)
{
	int obj, numObj;
	numObj = this->GetSize();
	if (numObj < 1)
		return;


	CgksObject*	pObject;
	CgksLine* pLine = NULL;
	CgksText* pText = NULL;
	CgksMarker* pMarker = NULL;
	CgksPolygon* pPolygon = NULL;
	CgksViewport* pViewport = NULL;
	CgksWindow* pWindow = NULL;
	m_window[0] = 0.0;
	m_window[1] = 1.0;
	m_window[2] = 0.0;
	m_window[3] = 1.0;
	m_viewport[0] = 0.0;
	m_viewport[1] = 1.0;
	m_viewport[2] = 0.0;
	m_viewport[3] = 1.0;
	GKStransf(pDC, m_viewport, m_window, m_clipOn); // initial window etc


	for (obj=0; obj<numObj; obj++)
	{
		pObject = (CgksObject*)this->GetAt(obj);
		switch (pObject->m_objType)
		{
		case gksLine:
			pLine = (CgksLine*)pObject;
			if (needTransform)
				pLine->Transform();
			pLine->Draw(pDC);
			break;
		case gksText:
			pText = (CgksText*)pObject;
			if (needTransform)
				pText->Transform();
			pText->Draw(pDC);
			break;
		case gksMarker:
			pMarker = (CgksMarker*)pObject;
			if (needTransform)
				pMarker->Transform();
			pMarker->Draw(pDC);
			break;
		case gksPolygon:
			pPolygon = (CgksPolygon*)pObject;
			if (needTransform)
				pPolygon->Transform();
			pPolygon->Draw(pDC);
			break;
		case gksViewport:
			pViewport = (CgksViewport*)pObject;
			pViewport->GetViewport(m_viewport);
			GKStransf(pDC, m_viewport, m_window, m_clipOn);
			break;
		case gksWindow:
			pWindow = (CgksWindow*)pObject;
			pWindow->GetWindow(m_window);
			GKStransf(pDC, m_viewport, m_window, m_clipOn);
			break;
		default:
			break;
		}
	}
}

// status

void	CgksSegment::SetClip (BOOL flag)
{
	m_clipOn = flag;
}

BOOL	CgksSegment::GetClip ()
{
	return (m_clipOn);
}

void	CgksSegment::SetPickable (BOOL flag)
{
	m_pickable = flag;
}

BOOL	CgksSegment::GetPickable ()
{
	return (m_pickable);
}



