// gksText.cpp : implementation of the CgksText class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "OzGKS.h"
#include "gksText.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



CgksText::CgksText(float x, float y, char* str, float height, float expansion, 
				   int horizontal, int vertical, int path, int font, int colour)
{
	m_objType = gksText;
	m_x = x;
	m_y = y;
	m_string = str; 
	m_height = height;
	m_expand = expansion;
	m_horizontal = horizontal;
	m_vertical = vertical;
	m_path = path;
	m_font = font;
	m_colour = colour;
	this->Transform();

}

// draw on screen.

BOOL CgksText::Draw(CDC* pDC)
{
	long x,y;
	int i;
	int length;
	int blanks;
	char	vertChar;
	int height;

	height = GKStext(pDC, m_height, m_expand, m_horizontal, m_vertical, 
										m_font, m_colour, FALSE);
	x = m_screenPoint.x;
	y = m_screenPoint.y;
	length = m_string.GetLength();
	if (m_path == 3)  // vertical
    {
		 for (i=0; i<length; i++)
        {
			vertChar = m_string.GetAt(i);
			pDC->TextOut(x, y, &vertChar, 1);
			y += height;
        }
    }
	else // horizontal
    {
	 blanks=-1;
		for (i=0; i<length && blanks<0; i++)
        {
		if (m_string[i] != ' ')  // leading blanks foul up alignment
			 blanks = i;
        }
		if (blanks < 0)
			blanks = 0;
		x += blanks * height;
		length -= blanks;
		pDC->TextOut(x, y,m_string.GetBuffer(blanks), length);	
	}
	return TRUE;
}


// Transform world coords to screen coords

void CgksText::Transform()
{
	xw2dev(m_x, &m_screenPoint.x);
	yw2dev(m_y, &m_screenPoint.y);

}