// CMyFancySheet.cpp : implementation file
//
// this is created completely by the wizard - just choose 
//		"new" and CPropertySheet - no code needed!!!

#include "stdafx.h"
#include "PropMode.h"
#include "sheetf.h"
#include "Modeles1.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyFancySheet

IMPLEMENT_DYNAMIC(CMyFancySheet, CPropertySheet)

CMyFancySheet::CMyFancySheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
	m_pModeLessChild = NULL; // init the pointer to NULL
}

CMyFancySheet::CMyFancySheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
	m_pModeLessChild = NULL; // init the pointer to NULL
}

CMyFancySheet::~CMyFancySheet()
{
	// in case user closes app while modeless dialog displayed
	if( m_pModeLessChild != NULL )
	{
		m_pModeLessChild->DestroyWindow();    // kill dialog
		delete m_pModeLessChild; // delete dialog's memory on heap
	}
}

BEGIN_MESSAGE_MAP(CMyFancySheet, CPropertySheet)
	//{{AFX_MSG_MAP(CMyFancySheet)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// added per Q143291
	ON_MESSAGE (WM_RESIZEPAGE, OnResizePage)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyFancySheet message handlers

/*
You can add controls to the property sheet dialog in the 
OnCreate handler. Accommodating additional controls usually 
requires expanding the size of the property sheet dialog. 
After calling the base class CPropertySheet::OnCreate, call 
GetWindowRect to get the width and height of the currently 
allocated property sheet window, expand the rectangles 
dimensions, and call MoveWindow to change the size of 
the property sheet window. */

/////////////////////////////////////////////////////////////////////////////
int CMyFancySheet::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CPropertySheet::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMyFancySheet::OnInitDialog() 
{
	BOOL b = CPropertySheet::OnInitDialog();

	// none of what follows is needed doing the "plain" propsheet

	// make the modeless dialog
	m_pModeLessChild = new CModeLessChild;    
	BOOL bCreate = m_pModeLessChild->Create(this);
	ASSERT(bCreate);

	// move the modeless window - it is centered now as a child
	//		move to left side
	CRect mrect; 
	m_pModeLessChild->GetWindowRect(&mrect);
	// save the total shift so we can shift everything else
	m_nModelessShift = 2*OFFSET+mrect.Width();
	int nWide = mrect.Width();
	int nHigh = mrect.Height();
	mrect.left = OFFSET;
	mrect.top = OFFSET;
	mrect.right = mrect.left + nWide;
	mrect.bottom = mrect.top + nHigh;
	m_pModeLessChild->MoveWindow(&mrect);

	// push out the right side of the PropSheet so the modeless has room
	CRect wr;
	GetWindowRect(&wr);
	wr.right += m_nModelessShift;
	MoveWindow(&wr);

	// resize the page
	// added per Q143291
	CPropertyPage* pPage = GetActivePage ();
	ASSERT (pPage);
	// store page size in m_PageRect
	pPage->GetWindowRect (&m_PageRect);
	ScreenToClient (&m_PageRect);
	m_PageRect.OffsetRect( m_nModelessShift, 0 );
	pPage->MoveWindow(&m_PageRect);

	// move the four buttons
	CButton* pSheetButton;
	CRect rectWnd;
	WINDOWPLACEMENT winplace;
	//HELP
	pSheetButton = (CButton*)GetDlgItem( IDHELP );
	ASSERT( pSheetButton );
	pSheetButton->GetWindowPlacement( &winplace );
	rectWnd = winplace.rcNormalPosition;
	rectWnd.OffsetRect( m_nModelessShift, 0 );
	winplace.rcNormalPosition = rectWnd;
	pSheetButton->SetWindowPlacement( &winplace );
	pSheetButton->ShowWindow( SW_HIDE );
	//CANCEL
	pSheetButton = (CButton*)GetDlgItem( IDCANCEL );
	ASSERT( pSheetButton );
	pSheetButton->GetWindowPlacement( &winplace );
	rectWnd = winplace.rcNormalPosition;
	rectWnd.OffsetRect( m_nModelessShift, 0 );
	winplace.rcNormalPosition = rectWnd;
	pSheetButton->SetWindowPlacement( &winplace );
	//OK
	pSheetButton = (CButton*)GetDlgItem( IDOK );
	ASSERT( pSheetButton );
	pSheetButton->GetWindowPlacement( &winplace );
	rectWnd = winplace.rcNormalPosition;
	rectWnd.OffsetRect( m_nModelessShift, 0 );
	winplace.rcNormalPosition = rectWnd;
	pSheetButton->SetWindowPlacement( &winplace );
	//APPLY
	pSheetButton = (CButton*)GetDlgItem( ID_APPLY_NOW );
	ASSERT( pSheetButton );
	pSheetButton->GetWindowPlacement( &winplace );
	rectWnd = winplace.rcNormalPosition;
	rectWnd.OffsetRect( m_nModelessShift, 0 );
	winplace.rcNormalPosition = rectWnd;
	pSheetButton->SetWindowPlacement( &winplace );

	// move the tab control
	CTabCtrl* pTabCtrl = GetTabControl();
	ASSERT( pTabCtrl );
	pTabCtrl->GetWindowPlacement( &winplace );
	rectWnd = winplace.rcNormalPosition;
	rectWnd.OffsetRect( m_nModelessShift, 0 );
	winplace.rcNormalPosition = rectWnd;
	pTabCtrl->SetWindowPlacement( &winplace );

	// we moved the sheet's right side so re-center 
	CenterWindow();

	return b;
}

/////////////////////////////////////////////////////////////////////////////
// hand added per Q143291
// only here to suppor the fancy style
LONG CMyFancySheet::OnResizePage(UINT, LONG) 
{ 
	// resize the page using m_PageRect which was set in OnInitDialog()
	CPropertyPage* pPage = GetActivePage ();
	ASSERT (pPage);
	pPage->MoveWindow (&m_PageRect);

	return 0;
} 

/////////////////////////////////////////////////////////////////////////////
// wizard added per Q143291
// only here to suppor the fancy style
BOOL CMyFancySheet::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	NMHDR* pnmh = (LPNMHDR) lParam;

	// the sheet resizes the page whenever it is activated
	// so we need to resize it to what we want
	if (TCN_SELCHANGE == pnmh->code)
	{
		// user-defined message needs to be posted because page must
		// be resized after TCN_SELCHANGE has been processed
		PostMessage (WM_RESIZEPAGE);
	}
	return CPropertySheet::OnNotify(wParam, lParam, pResult);
}
