#include <stdlib.h>
#include <windows.h>
#include <mmsystem.h>

#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#else
#  define DLLEXPORT
#endif

#define description " Ver 1.1 This function intialises the sound cord to record 16 bit adc \
                values. Valid sample rates are 8000,11025,22050,44100,48000 \
				it does not work with 16000 and 32000 sample rates. "

/* The description will show up on the Program Explorer when you select
   "Show Description" from the object menu and the Function Selection
   dialog box in the small window on the bottom of the box.
*/
DLLEXPORT char scd_desc[] = description;

DLLEXPORT long scd (long command, long sample_rate, long sample_size, long *rx_data )
	/* open mono, 16 bit sampling at sample_rate (samples per second)
	  sample_size in number of data samples i.e. for 16 bit data.
	  Returns job_OK if no errors other wise errors listed below  
	  code checked with 8000, 11025, 22050,44100,48000  - it does not work
	  with 16000 or 32000 sample rates.
	  	*/

{

/* this code is for mono only */

# define INIT_CARD 1
# define GO			 2
# define no_memory    99
# define could_not_set_card 98
# define job_OK 3

	HWND                    hWnd;
    UINT                    nStatus, wDevID ;
    static UINT             nTimer ;
    static PCMWAVEFORMAT    pcmWaveFormat ;
    static HWAVEIN          hWaveIn = NULL ;
    static HANDLE           hGmem1, hGmem2 ;
    static PSHORT           lpData ;   // 16 bit data collected
    static LPWAVEHDR        lpWaveHdr ;
    static DWORD            dwBytesRecorded = 0 ;
    MMTIME                  mmTime ;
	DWORD					i ,samples_available;


	
// constants and variables declared in scd.h

	switch (command)
	{
	case INIT_CARD :

		 hGmem1 = GlobalAlloc (GMEM_SHARE | GMEM_MOVEABLE,
                sizeof (WAVEHDR)) ;
            hGmem2 = GlobalAlloc (GMEM_SHARE | GMEM_MOVEABLE,
                (DWORD) 2* sample_size );  // (sample_size/sample_rate) s data block max
            if (hGmem1 == NULL || hGmem2 == NULL) 
			{
				return (no_memory); 
			}
            
    // else leave blocks locked for both input and output
            lpWaveHdr = (LPWAVEHDR) GlobalLock (hGmem1) ;
            lpData = (PSHORT) GlobalLock (hGmem2) ;
	// initialise
    
			lpWaveHdr->dwBytesRecorded = 0L;
			lpWaveHdr->dwUser = 0L;
			lpWaveHdr->dwFlags = 0L;
			lpWaveHdr->dwLoops = 1L;
			lpWaveHdr->lpNext = NULL; 
    
             pcmWaveFormat.wf.wFormatTag =   // open input 
                        WAVE_FORMAT_PCM ;
             pcmWaveFormat.wf.nChannels = 1 ; // mono, stereo =2
              pcmWaveFormat.wf.nSamplesPerSec = sample_rate ;
			  pcmWaveFormat.wBitsPerSample = 16 ;
              pcmWaveFormat.wf.nAvgBytesPerSec = pcmWaveFormat.wf.nBlockAlign*pcmWaveFormat.wf.nSamplesPerSec ;
              pcmWaveFormat.wf.nBlockAlign = pcmWaveFormat.wf.nChannels*pcmWaveFormat.wBitsPerSample/8; 
//			  pcmWaveFormat.cbSize = 0;  
              nStatus= waveInOpen (&hWaveIn, 0, 
                        (LPWAVEFORMAT) &pcmWaveFormat, 
                        (DWORD )hWnd, NULL, CALLBACK_NULL) ;
			   if (nStatus) return (could_not_set_card);
			   lpWaveHdr->lpData = (PSHORT) lpData ;
              lpWaveHdr->dwBufferLength = (DWORD) 2 * sample_size ;
              waveInPrepareHeader (hWaveIn, lpWaveHdr, 
                                     sizeof (WAVEHDR)) ;
              waveInAddBuffer (hWaveIn, lpWaveHdr, 
                                  sizeof (WAVEHDR)) ;
   // now start recording
              waveInStart (hWaveIn) ;
   // check for time up - when reached the required number of samples
			   mmTime.wType = TIME_SAMPLES ; // specify timer units desired
       while (mmTime.u.sample != sample_size)
	   {
            waveInGetPosition (hWaveIn, &mmTime, sizeof (MMTIME)) ;
	   }
   // stop recording and tranfer the data to rx_data
       waveInStop(hWaveIn);
	   waveInReset(hWaveIn);
   /* the sound card stores data as 16 bit integers (short ).  */
   /* number of samples actually return is sample_size - an overhead */
       samples_available = sample_size - 10 -  ((sample_size * 2) - lpWaveHdr->dwBytesRecorded);

					for (i=0; i < samples_available; i++) 
					{
					               
                        *(rx_data+i) = *lpData++;
						
					
					}
	  
	   i=lpWaveHdr->dwBytesRecorded;
	   
   // now release the buffer
//	   waveInReset(hWaveIn);
	   waveInClose (hWaveIn) ;
	  
       if (hGmem1)
            {
                GlobalUnlock (hGmem1) ;
                GlobalFree (hGmem1) ;
            }
       if (hGmem2)
            {
                GlobalUnlock (hGmem2) ;
                GlobalFree (hGmem2) ;
            }
    } 
 return(i);
}
