
/*
  SCRIPTOL LIBRARY
  (c) 2002 by Denis G. Sureau
  http://www.scriptol.com
  http://www.scriptol.net

GENERAL PUBLIC LICENCE

Along with the free Scriptol to native compiler is
provided the libsol.a library. The library contains
the TEXT, DYN and ARRAY classes and lot of functions
compatibles with the Php library.
This library is the orginal work of Denis G. Sureau.
It has been registered at INPI 25 june 2002.
The Php compatible functions are original work. They
have nothing to do with Php sources.
The source of the library is furnished to registered
user of the compiler, enterprise edition.

The library is provided to allow the user to link it
with its Scriptol compiled program. He is allowed to
include the library in its program and distribute its
programs with the library included into, with no any
fee required and no any restriction or condition.

He is not allowed to distribute the library as it but
in the case of an open-source program. The library may
be included unchanged among other files of the open
source distribution and headers of the file to include,
libsol.hpp, text.hpp, dyn.hpp, array.hpp, fun.hpp and
other files, must be included unchanged, and must hold
my name and the address of the Scriptol site.

The source of the library is provided to licensed users
to allow them either to modify it according to their need,
or to compile it in a different file format, for a different
compiler. The registered user is not permitted to
distribute the source of the library in no any case, even
if is is modified.
*/


#ifndef _SOL_FUN
#define _SOL_FUN

#define STR_PAD_LEFT 0
#define STR_PAD_RIGHT 1
#define STR_PAD_BOTH 2

#define PHP_VERSION "C++"
#define PHP_OS "unknow"

//===== general

#define print_r(a) a.display()

void runtimeError(const char *);

void die(text);
void die(const char *);
void exit();

// swap defined inside algo
template<class T> T &min(T &a, T &b);
template<class T> T &max(T &a, T &b);

#define swap(a,b) { dyn temp = a; a = b; b = temp; }

//===== types

bool is_array(dyn a);

//===== numbers

double doubleval(text);
double doubleval(const char *);
double doubleval(dyn);
double doubleval(int);
double doubleval(double);
int intval(text);
int intval(const char *);
int intval(dyn);
int intval(double);
int intval(int);
int ord(const char *);
int ord(text);
int ord(char);
text chr(int);
double abs(double);
double _sol_round(double);

//===== array

#define array_values(a) a.values()
#define array_keys(a) a.keys()
#define array_flip(a) a.flip()

int   count(array *);
int   count(array);
int   count(dyn);

array _sol_range(int, int);

array array_merge(array *, array);
array array_merge(array, array);

array array_diff(array , array);
array array_intersect(array, array);
array array_unique(const array &);


int array_search(array, ...);
text implode(array *, text sep);

void array_map(void (*)(dyn &), array &);
void array_map(void (*)(dyn *), array &);
void array_map(void (*fun)(dyn &, dyn &), array &, array &);
void array_map(void (*fun)(dyn &, dyn &, dyn &), array &, array &, array &);

template<class T> void array_map(T (*)(dyn *), array &);
//template<class ANY> void array_map(void, ...);

//template <class ANY> bool in_array(ANY, array);
bool in_array(int, array);
bool in_array(text, array);
bool in_array(const char *, array);
bool in_array(double, array);
bool in_array(dyn, array);

bool in_sequence(const text &, text &);
bool in_sequence(const text &, const char *);
bool in_sequence(const char *, text &);
bool in_sequence(const char *, const char *);
bool in_sequence(dyn, array);

//===== iterators

dyn reset(array);
dyn next(array);
dyn prev(array);
dyn end(array);
text key(array &);
dyn current(array &);


//===== stack

#define array_unshift(a, d) a.unshift(d)
#define array_shift(a) a.shift()
#define array_pop(a) a.pop()
#define array_push(a, d)  a.push(d)

//===== functions

text implode(text, array);


//===== file

array file(text);
array file(const char *);
void store(array, const char *);
void store(array, text);


//===== text

text str(int);
text str(double);
text str(dyn);

text strval(int);
text strval(double);
text strval(dyn);

char *builtin_hex(int);


text strtoupper(text );
text strtoupper(const char *);
text strtoupper(dyn);
text strtolower(text );
text strtolower(const char *);
text strtolower(dyn);
int strlen(text);
int strlen(dyn);
text str_repeat(text , int);
text str_repeat(const char *, int);
text str_repeat(dyn, int);
int strcasecmp(text , text );
void str_replace(text , text );
char *substr(const char *, int, int);
char *substr(const char *, int);

char *strstr(const char *, const char *);
char *strstr(text, const char *);
char *strstr(const char *, text);
char *strstr(text, text);
char *stristr(const char *, const char *);
char *stristr(text, const char *);
char *stristr(const char *, text);
char *stristr(text, text);
char *strstr(dyn, dyn);

int strcasecmp(dyn, dyn);
int strcasecmp(dyn, text );
int strcasecmp(text, dyn);
void str_replace(text, dyn);
int strpos(const char *, const char *, int);

array explode(const char *, const char *);

text rtrim(text);
text ltrim(text);
text trim(text);
text rtrim(const char *);
text ltrim(const char *);
text trim(const char *);

text str_pad(text , int, text = " ", int = 1);
text str_pad(text , int, const char * =  " ", int = 1);
text str_pad(const char *, int, const char * = " ", int = 1);

//===== file

FILE *fopen(text, text);
FILE *fopen(text, const char *);
FILE *_sol_open(const char *, const char *);
void fseek(FILE *, int);
void fputs(text);
text fgets(FILE *);
text fread(FILE *, int size);
int  fwrite(FILE *, const text &);
int  fwrite(FILE *, const char *);

//===== dir

bool file_exists(const text &);
bool file_exists(const char *);
text filetype(const char *);
double filesize(const char *);
bool _sol_chdir(const char *);          // change directory for a drive/current
bool _sol_mkdir(const char *);          // create directory
bool _sol_rmdir(const char *);          // remove directory
bool _sol_ren(const char *, const char *);   // rename file

dyn open_dir(const char *);
text read_dir(dyn);
void rewind_dir(dyn);
void close_dir(dyn);
text getcwd();

//===== regular not yet implemented

bool ereg(text t, text);
bool ereg(text t, const char *);
bool ereg(const char *, text);
bool ereg(const char *, const char *);

#endif
