` Scriptol PHP
` A wrapper to GD, the image library


class Image

 constant int GIF = $(IMG_GIF)
 constant int PNG = $(IMG_PNG)
 constant int JPG = $(IMG_JPG)
 constant int BMP = $(IMG_WBMP)

 dyn theimage = 0
 int font = 1
 dyn texture = 0
 boolean created = false
 int width = 0
 int height = 0

 dyn create(int w, int h)
  theimage = imagecreate(w, h)
  width = w
  height = h
  created = true
 return theimage

 void Image(int w, int h)
  create(w, h)
 return

 int notCreated()
   print "Runtime error: image not created"
 return 0

 int copy(int x, int y, int w, int h, Image dst, int dx, int dy)
   if not created ? return notCreated()
 return imagecopy(dst, theimage, dx, dy, x, y, w, h)

 void setFont(int f) : font = f; return

 void setTexture(dyn t): texture = t; return

 void update()
   width  = imagesx(theimage)
   height = imagesy(theimage)
 return

 int createColor(int r, int g, int b)
   if not created ? return notCreated();
 return imagecolorallocate(theimage, r, g, b)

 `================== figures

 int ellipse(int cx, int cy, int w, int h, int color)
   if not created ? return notCreated()
 return imageellipse(theimage, cx, cy, w, h, color)

 int getPixel(int x, int y)
   if not created ? return notCreated()
 return imagecolorat(theimage, x, y)

 int setPixel(int x, int y, int color)
   if not created ? return notCreated()
 return imagepixel(x, y, color)

 int line(int x, int y, int x2, int y2, int color)
   if not created ? return notCreated()
 return imageline(theimage, x, y, x2, y2, color)

 int fill(int color, int x = 0, int y = 0)
   if not created ? return notCreated()
 return imagefill(theimage, x, y, color)

 int rectangle(int xl, int yt, int xr, int yb, int color)
   if not created ? return notCreated()
 return imagerectangle(theimage, xl, yt, xr, yb, color)

 `================= Loading an image

 boolean loadGif(text filename)
   theimage = imagecreatefromgif(filename)
   created = theimage <> 0
   update()
 return created

 boolean loadJpg(text filename)
   theimage = imagecreatefromjpeg(filename)
   created = theimage <> 0
   update()
 return created

 boolean loadPng(text filename)
   theimage = imagecreatefrompng(filename)
   created = theimage <> 0
   update()
 return created

 boolean loadBmp(text filename)
   theimage = imagecreatefromwbmp(filename)
   created = theimage <> 0
   update()
 return created


 `================= Making a file

 int savePng(text filename)
   if not created ? return notCreated()
 return imagepng(theimage, filename)

 int saveJpeg(text filename, int quality=80)
   if not created ? return notCreated()
 return imagejpeg(theimage, filename, quality)

 int saveJpg(text filename, int quality=80)
   if not created ? return notCreated()
 return imagejpeg(theimage, filename, quality)

 int saveBmp(text filename)
   if not created ? return notCreated()
 return imagewbmp(theimage)

 `================= Text

 void write(int x, int y, text t, int color)
   if not created : notCreated();  return; /if
   imagestring(theimage, font, x, y, t, color)
 return


 `================= Misc

 ` check for supported formats
 boolean support(int type)
  if type
  = GIF:
  = JPG:
  = PNG:
  = BMP:
  else return false
  /if
 return (imagetypes() & type) <> false

 void dispSupport(text format, int f)
   echo format, " "
   if support(f) ? print "supported"; else print "not supported"
 return

 void checkSupport()
  dispSupport("GIF", GIF)
  dispSupport("JPG", JPG)
  dispSupport("PNG", PNG)
  dispSupport("BMP", BMP)
 return

/class
