
`  Path Class
`  Scriptol-Php - (c) 2001-2002  D.G Sureau
`  www.scriptol.com

`  This is a set of static functions related to files in directory
`  The path separator is "/" under Unix and Windows


include "libphp.sol"

class Path

 ` EXISTS - Test if a file exists
 static boolean exists(text dname): return file_exists(dname)


 ` SIZE - Return the size of a file
 static number size(text fname):   return filesize(fname)


 ` TYPE - Return the type of an entry: file, dir, etc...
 static text type(text fname):   return filetype(fname)


 ` ISFILE
 static boolean isFile(text fname) return filetype(fname) = "file"


 ` ISDIR
 static boolean isDir(text fname)
  text t = filetype(fname)
  if t = "link" ? return false
  if t != "dir" ? return false
 return true


 ` REN
 static boolean ren(text oldname, text newname)
   boolean b = true
   rename(oldname, newname)
 return b

 ` DELETE
 static boolean erase(text fname) return unlink(fname) 

 ` MERGE - Merge elements of path
 static text merge(text path, text filename)
   if path = "" ? return filename
   if filename = "" ? return path
   if (path[path.length()-1] <> "/") and (filename[0] <> "/") ? path + "/"
 return path + filename

 ` MAKE DIR - Create a sub-directory
 static boolean make(text name) return mkdir(name)


 ` SPLIT EXT - Split the node and the extension of a filename or path
 static text, text splitExt(text path)
   int l = path.length()
   if l = 0 ? return "", ""
   for int x in l - 1 .. 0 step -1
    if path[x] = "." ? return path[--x], path[x + 1..]
   /for
 return path, ""

 ` Get EXTENSION - Get extension of a filename or path
 static text getExtension(text path)
   text ext = strrchr(path, ".")
   if ext <> nil return ext
 return ""


 ` SPLIT  - Split path to directory and file

 static text, text splitFile(text path)
   int l = path.length()
   if l = 0 ? return "",""
   for int x in l - 1 .. 0 step - 1
     if (path[x] = '/') or (path[x] = '\\') ? return path[..x], path[x + 1..]
   /for
 return path, ""


 ` GET DIR Get current directory
 text getDir()  return getcwd()

 ` COMPARE PATHS

 static boolean compare(text a, text b)
    int l = a.length()
    if l <> b.length() return false
    for int i in 0 -- l
      if a[i] <> b[i]
        if (a[i] = "\\") and (b[i] = "/") continue
        if (b[i] = "\\") and (a[i] = "/") continue
        return false
      /if
    /for
 return true


/class

