<HTML>
<HEAD>
<TITLE></TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-face: "Courrier New", Courrier, mono, Monospaced, Arial }
 .toc { font-face: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3  { font-size: 18pt; color: #333399 }
 H4  { font-size: 16pt; color: #333399 }
 H5  { font-size: 14pt; color: #333399 }
 H6  { font-size: 12pt; color: #333399 }
 H7  { font-size: 11pt; color: #333399 }
 PRE { font-size: "14pt"; font-face: "Courrier New", Courrier, mono, Monospaced, Arial;  color: "#000000" }
 A:link { text-decoration: none; color: #0000cc }
 A:visited { text-decoration: none; color: #0000ff }
 A:hover { text-decoration: none; color: #ff00ff }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_steps.php" target="_self"><img src="simprev.jpg" border="0"></a></td>
          <td width="105" height="40"><a href="en_steps.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_vars.php" target="_self"><img src="simup.jpg" border="0"></a></td>
          <td width="65" height="40"> <a href="en_vars.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_array.php" target="_self"><img src="simnext.jpg" border="0"></a></td>
          <td width="64" height="40"> <a href="en_array.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_steps.php" target="_self">IV First steps</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_array.php" target="_self">VI Arrays and dict</a>

<h3><a name="title0"></a>
V Constants & variables</h3> <pre>

 A constant is a name given to a numerical value or a text.
 A variable is a name gived to a memory the content of which may change, and
replaced by another value, text, or object of the same type.

 Examples of constants:
 constant int x = 1
 constant boolean b = true
 constant text t = "some text"

</pre>
<h4><a name="title1"></a>
  Declarations</h4> <pre>

 A constant is declared as a variable, with the "constant" modifier before.
 A literal value must always be assigned to it.

 Here is the list of simple types that you can use. Simple types are named
"scalars". They are also complex ones, made of sets of scalars objects, but you
see them in the next chapter.

 number     any numeric value, including boolean ones.
 integer    or int, integer value, without decimals.
 text       a string of characters.
 boolean    a boolean with two values, true and false.
 dyn        a dynamic variable, that may holds any type of object.

 A variable is declared by its type followed by its name.
 Examples of variables:
 number a
 integer x
 int x             ...integer may be abbreviated.
 text mytext

 In most case, the variable should be initialized at declaration, and a
literal value is assigned to it.
 Example:
 int x = 5
 number pi = 3.14

 A literal text may be enclosed in simple or double quotes.
 In the first case, it is considered as a simple string of characters.
 text t = 'abc$xyz'
 This is just the string of the characters: a,b,c,$,x,y,z

 In the second case, some symbols have special meaning at runtime and strings of
digits are threaded as numbers.
 text xyz = "def"
 text t = "abc$xyz"
 Inside double quotes, the $ symbol means for a variable name.
 To the t variable are assigned the characters a,b,c followed by the content
of the variable xyz, and thus have been assigned a,b,c,d,e,f.
 This could have been written also:
 text t = "abc" + xyz

 In the same manner, the {} symbols have special meaning, but this has no real
interest for the Scriptol language, look at the Php manual for more infos about
that.

</pre>
<h4><a name="title2"></a>
  Escaping</h4> <pre>

 For characters that cannot be directly inserted into a text, one uses a special
code:  \
 For example, to display a double quote, one writes:
 "abc\"def"
 The \" sequence puts the double quotes into the text.
 This is the same for special codes:
 \n      inserts a newline.
 \t      inserts a tab.

</pre>
<h4><a name="title3"></a>
  Multiple declarations</h4> <pre>

 Providing that all of them have the same type, is it possible to declare and
initialize several variables at once.
 The syntax is:
 type name [= value], name [= value], etc...
 Example:
 int x = 1, y, z = 2
 You can't merge several types inside a sole declaration. You can't do multiple
assignments, as described below, in a declaration.

</pre>
<h4><a name="title4"></a>
  Assignment</h4> <pre>

 The assigment allows to put a value into a memory, to give a value to a
variable. This value may be a literal or be contained inside another variable.
In all cases, one can only assign to a variable a value having the same type.
 Example:
 int x = 1200
 number z = 0.5
 text t = "abc"

 A literal integer is a number without decimal point. A real number is identified
by the decimal point or e, for "exponent".
 Ex:
 number z = 110         ... bad, 110 is an integer.
 number z = 110.0       ... ok, a point denotes a real.
 number z = 1e5         ... ok.

 To convert a number in text, the toText() method may be used. The toInt() and
toNumber() methods convert a text in integer or real providing that the text
is a string of digits.
 text t = 10.toText()
 int x = "1200".toInt()
 Of course, these methods are only useful with variables.

</pre>
<h4><a name="title5"></a>
  Multiple asignments</h4> <pre>

 There is two manners to perform multiple assignement. In the first case, by
initializing several variables with one value.
 Example:
 x, y, z = 0
 In this case, the three variables x, y, z are initialized with the zero value.
 But we can also assign several values to several variables at once.
 Example:
 x, y, z = 1, 2, 3
 Here, 1 is assigned to x, 2 to y and 3 to z.
 In this second case, the number of targets must match the number of values,
otherwise this an error is thrown by the compiler.

 Multiple assignment is especially useful to allow a function returning several
values at once.
 For example, we have a function named getColor() which returns the red, green,
blue components of a color, and we can write:
 int red, green, blue
 red, green, blue = getColor()

 The compiler knows that the getColor() function has been defined to return
three values, and thus that this matches the number of variables.
 If the function was defined to return a single value, the variables will be
all assigned with this same value. If the number of values is greater than one,
and different of the number of variables at left, this an error is thrown by the
compiler.

 Unlike multiple declaration, a multiple assignment may be performed on variables
having different types.
 Example:
 int x
 text t
 x, t = 1000, "abc"

 Multiple assignment may be used with the elements of an array too.
 Arrays have a dynamic size and thus, the number of targets don't need to match
the number of elements, and if the array has a single element, only the first
variable will be assigned.
 Example:
 x, y, z = array(1, 2, 3, 4)
 is equivalent to x = 1, y = 2, z = 3.
 x, y, z = array(1)
 is equivalent to x = 1 and other variables are not assigned.

</pre>
<h4><a name="title6"></a>
  Compound assigment</h4> <pre>

 This feature has been simplified in Scriptol more than in any other language.
 This designates the case a variable is assigned a value while an operation
is performed on the variable and the value.
 For example, adding 10 to x and putting the result into x.
 Rather than writing x = x + 10, one may write simply: x + 10
 In a conditional test, x + 10 returns simply the result of 10 added to the
content of x, without to modify x. But if this is a statement, the result will
be assigned to x.

 The compound assignments work with these operators:
 + - * / mod << >> & | ^
 Example:
 x + 1      increments the content of x by 1.
 x * y      replaces the content of x by the result of x * y.
 a & b      replaces the array a by the intersection of arrays a and b.

 At opposite, in:
 if x + 1 : ...     here x is not modified.

</pre>
<h4><a name="title7"></a>
  Tuples</h4> <pre>

 A tuple is the name of a list of variable assigned or read all together.
 A tuple is not an object, nor an expression, but a construction of the language.
A tuple is not enclosed by anything.
 A tuple of expressions may follows the return statement. A tuple of variables
may be assigned by a function call providing the function returns a tuple with
same number of elements.
 It may be assigned with either another tuple with same number of elements, or
a single expression, in this case this expression is assigned to each variable
of the tuple, as described above.

</pre>
<h4><a name="title8"></a>
  The system's constants and variables</h4> <pre>

 If you know the Php language, you know that variables are prefixed with a $
(but you are not richer with all these dollars).
 To access directly a Php variable, Scriptol keeps simply this syntaxe.
 For Php constant, Scriptol uses also the $, but the constant is enclosed in
parenthesis.
 We will see later why to use these Php items. Here are just some example, to
show the syntax...

 Example:
 array a = $argv
 int x = $(PAD_LEFT)

 Conclusion
 You have covered simple types of variables. We have also view what tuples
are. Tuple have a natural complement, when we want use tuples as objects, these
are arrays. Now we will study arrays and the power of dynamic list.

</pre>
<br><br><table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_steps.php" target="_self"><img src="simprev.jpg" border="0"></a></td>
          <td width="105" height="40"><a href="en_steps.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_vars.php" target="_self"><img src="simup.jpg" border="0"></a></td>
          <td width="65" height="40"> <a href="en_vars.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_array.php" target="_self"><img src="simnext.jpg" border="0"></a></td>
          <td width="64" height="40"> <a href="en_array.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_steps.php" target="_self">IV First steps</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_array.php" target="_self">VI Arrays and dict</a>
</BODY>
</HTML>
