// SpltCombDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SpltComb.h"
#include "SCDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpltCombDlg dialog

CSpltCombDlg::CSpltCombDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSpltCombDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSpltCombDlg)
	m_sFileName = _T("");
	m_sInfo = _T("");
	m_unFileSize = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSpltCombDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpltCombDlg)
	DDX_Text(pDX, IDC_FILE_NAME, m_sFileName);
	DDX_Text(pDX, IDC_INFO, m_sInfo);
	DDX_Text(pDX, IDC_FILE_SIZE, m_unFileSize);
	DDV_MinMaxUInt(pDX, m_unFileSize, 1, 10000000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSpltCombDlg, CDialog)
	//{{AFX_MSG_MAP(CSpltCombDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE_BUT, OnBrowseBut)
	ON_BN_CLICKED(IDC_COMB_BUT, OnCombBut)
	ON_BN_CLICKED(IDC_SPLT_BUT, OnSpltBut)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpltCombDlg message handlers

BOOL CSpltCombDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CSpltCombApp * pApp = (CSpltCombApp*)AfxGetApp();
	m_sFileName = pApp->GetProfileString("Settings", "File", "");
	m_unFileSize = (UINT)pApp->GetProfileInt("Settings", "Size", 1400);
	m_sInfo = "Ready";
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

/////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
/////////////////////////////////////////////////////////////////////////////
HCURSOR CSpltCombDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnBrowseBut() 
{
	// filter
	char szFilter[MAX_PATH];
//	= "Data Files (*.xlc;*.xls)|*.xlc; *.xls|All Files (*.*)|*.*||";
//	 static char BASED_CODE szFilter[] ="Text Files (*.txt)|*.txt| All Files (*.*)|*.*||";
  
	UpdateData(TRUE);
	CString sExt = "*";
	strcpy(szFilter, "All Files (*.*)|*.*||" );
	CFileDialog fileDialog(		TRUE, // so Open
											(LPCTSTR)sExt, // extension
											(LPCTSTR)m_sFileName,	// starter name
											//OFN_EXPLORER |		// controls
											OFN_LONGNAMES,// |
											//OFN_HIDEREADONLY |		 
											//OFN_OVERWRITEPROMPT, 
											szFilter,	 //  filter
											NULL );	 // parent

	if( fileDialog.DoModal() == IDOK)
	{
		m_sFileName =  fileDialog.GetPathName();
		UpdateData(FALSE);
	}	
	
}

////////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnCombBut() 
{
	UpdateData(TRUE);
	
	if(m_sFileName.GetLength())
	{
		int nFind = m_sFileName.ReverseFind('.');
		if(nFind != -1)
		{
			CString sFile = m_sFileName;
			sFile = sFile.Left(nFind);
			FILE * fp;
			// last arg is the filename
			fp = fopen((const char *)sFile, "wb");
			if(!fp)
			{
				m_sInfo.Format("Error: cannot open file %s", (const char *)sFile);
				UpdateData(FALSE);
			}
			else
			{
				CombineHelper(fp, sFile);
				fclose(fp);
				m_sInfo = "Combine Complete!";
				UpdateData(FALSE);
			}
		}
		else
		{
			m_sInfo.Format("Error: illegal file name");
			UpdateData(FALSE);
		}
	}
	else
	{
		m_sInfo.Format("Error: illegal file name");
		UpdateData(FALSE);
	}
}

////////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::CombineHelper(FILE * fpOut, CString sFileOut)
{
	char buffer[HUGEBUF];
	FILE * fpIn;
	int i;
	int j;
	int nRead;
	int nSize = m_unFileSize * HUGEBUF;
	CString sFileIn;
	printf("Starting Combine...");
	for(i = 1; ; i++)
	{
		sFileIn.Format("%s.%d", sFileOut, i);

		fpIn = fopen((const char *)sFileIn, "rb");
		if(fpIn)
		{
			nRead = HUGEBUF;
			for(j = 0; j < nSize/HUGEBUF && nRead == HUGEBUF; j++)
			{
				nRead = fread(buffer, 1, HUGEBUF, fpIn);
				fwrite(buffer, 1, nRead, fpOut);
			}
			fclose(fpIn);
			m_sInfo.Format("Wrote chunk from file %s", sFileIn);
			UpdateData(FALSE);
		}
		else
		{
			break;
		}

		if(nRead != HUGEBUF)
		{
			break;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnSpltBut() 
{
	UpdateData(TRUE);

	if(m_sFileName.GetLength())
	{
		FILE * fp;
		// last arg is the filename
		fp = fopen((const char *)m_sFileName, "rb");
		if(!fp)
		{
			m_sInfo.Format("Error: cannot open file %s", (const char *)m_sFileName);
			UpdateData(FALSE);
		}
		else
		{
			SplitHelper(fp, m_sFileName);
			fclose(fp);
			m_sInfo = "Split Complete!";
			UpdateData(FALSE);
		}
	}
	else
	{
		m_sInfo.Format("Error: illegal file name");
		UpdateData(FALSE);
	}
}

////////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::SplitHelper(FILE * fpIn, CString sFileIn)
{
	char buffer[HUGEBUF];
	FILE * fpOut;
	int j;
	int nRead;
	int nSize = m_unFileSize * HUGEBUF;
	CString sFileOut;
	m_sInfo = "Starting Split...";
	UpdateData(FALSE);
	for(int i = 1; ; i++)
	{
		sFileOut.Format("%s.%d", sFileIn, i);

		fpOut = fopen((const char *)sFileOut, "wb");
		if(fpOut)
		{
			nRead = HUGEBUF;
			for(j = 0; j < nSize/HUGEBUF && nRead == HUGEBUF; j++)
			{
				nRead = fread(buffer, 1, HUGEBUF, fpIn);
				fwrite(buffer, 1, nRead, fpOut);
			}
			fclose(fpOut);
			m_sInfo.Format("Wrote file %s", sFileOut);
			UpdateData(FALSE);
		}
		else
		{
			m_sInfo.Format("Error: Failed to create file %s", sFileOut);
			break;
		}

		if(nRead != HUGEBUF)
		{
			break;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
void CSpltCombDlg::OnOK() 
{
	UpdateData(TRUE);
	CSpltCombApp * pApp = (CSpltCombApp*)AfxGetApp();
	pApp->WriteProfileString("Settings", "File", m_sFileName);
	pApp->GetProfileInt("Settings", "Size", (int)m_unFileSize);
	
	CDialog::OnOK();
}
