###########################################################################################
# STLFilt.pl: STL error message decryption filter (A Perl script) supporting
#			  Microsoft VC++6/7 when working with any of the following libraries:
#
#					Native MSVC 6 Library
#					Native MSVC 7 (.NET) Library
#					Dinkumware 3.08 Library
#					STLPort 4.x Library
#
#			  (Under VC7/.NET compiler, the /WL compiler option is REQUIRED)
#
# Copyright (C) 2001 Leor Zolman (leor@bdsoft.com, www.bdsoft.com)
# Permission is granted to use this code without restriction
# provided this copyright notice is included in the code.
#
# Release 2.04 10/02/2001
#
# For quick installation instructions for the STL Error Decryptor, see QUICKSTART.txt.
# For general info, see README.txt
#
# (Note: hard tab setting for this source file is: 4)
#
# Purpose:	Transform STL template-based typenames from MSVC error messages
#			into a minimal, *readable* format. We might lose some details...
#			but retain our sanity! For use with the "Proxy CL" program, CL.cpp.
#
# Command line options:
#			/iter:x (or) -iter:x        Set iterator policy to x,
#										where x is s[short], m[edium] or l[ong]
#
#										The following two options apply ONLY to VC7:
#			/alloc:x (or) -alloc:x		Set allocator policy s[short] or l[ong]
#			/func:x (or) -func:x		Set functor policy s[hort], or l[ong]
#
#										(The three options above are typically 
#										 conveyed to Perl by the Proxy CL)
#
#			/width:nn					Set output text area width (will break
#										message lines at this column. Most useful
#										under VC7 when /alloc:L, /func:L or /iter:L
#										are being used)
#
# This file is part of a package including:
#	CL.cpp			The "Proxy" CL.EXE replacement,
#	STLTask			A taskbar icon-based error decryption control utility,
#	STLFilt.BAT		A "low-bandwidth" batch file for error decryption control
#
# Acknowledgments:
# -----------------
# Thanks to Dave Smallberg for the idea (wish I'd have thought of it myself)
# and to Scott Meyers for putting on his ESTL seminar -- the event that
# inspired this project. 
###########################################################################################

###########################################################################################
# User-configurable settings:
#

$newiter = 'iter';			# ('iter' or 'IT' or...) shorten the word "iterator" to this

							# The following three policy settings may be overriden by
							# options on the command line (typically set up via the Proxy
							# CL). 

							# default iterator policy:
$def_iter_policy = 'M';		# 'L' (Long): NEVER remove iterator type name qualification
							# 'M' (Medium): USUALLY remove iterator type name qualification
							#               leave intact when iter type may be significant
							#				to the diagnostic
							# 'S' (Short): ALWAYS remove iterator type name qualification

$def_alloc_policy = 'S';	# default allocator policy (applies to VC7/.NET only):
							# 'L' (Long): leave allocator info intact
							# 'S' (Short): strip all allocator information

$def_func_policy = 'S';		# default functor policy (applies to VC7/.NET only):
							# 'L' (Long): leave default functor info intact
							# 'S' (Short): strip all default functor information

$alloc = 'alloc';			# shorten the word "allocator" to this
#
# END of user-configurable settings
###########################################################################################

$| = 1;											# force output buffer flush after every line

$iter_policy = $def_iter_policy;				# default iterator policy
$alloc_policy = $def_alloc_policy;				# default allocator policy (used w/VC7 ONLY)
$func_policy = $def_func_policy;				# default functor policy (used w/VC7 ONLY)
$output_width = 0;								# no line wrap by default

while ("$ARGV[0]")								# process command-line options
{
	if ($ARGV[0] =~ /^[\/-]iter:([SML])[a-zA-Z]*$/i) # allow command-line iterator policy
	{												 # specification of form: /iter:x
		$iter_policy = "\u$1";
		shift;
		next;
	}

	if ($ARGV[0] =~ /^[\/-]alloc:([SL])[a-zA-Z]*$/i) # allow command-line allocator policy
	{												 # specification of form: /alloc:x
		$alloc_policy = "\u$1";
		shift;
		next;
	}

	if ($ARGV[0] =~ /^[\/-]func:([SL])[a-zA-Z]*$/i) # allow command-line functor policy
	{												# specification of form: /func:x
		$func_policy = "\u$1";						# (applies to hash_compare<...> and	
		shift;										# equal<...> functors under VC7 ONLY)
		next;
	}

	if ($ARGV[0] =~ /^[\/-]width:(\d+)/)			# allow line output width spec
	{												# of form: /width:n
		$output_width = $1;
		shift;
		next;
	}

	last;
}

$sid = '\b[a-zA-Z_]\w*';						# pattern for a simple identifier or keyword
$id = "(?:$sid\:\:)*$sid";						# simple id preceded by an optional namespace qualifier

$p = '(?: \*){0,5}';							# suffix for "ptr", "ptr to ptr", "ptr to ptr to ptr", ad nauseum.
$idp = "(?:$id )?(?:$id )?(?:$id )?$id ?$p ?";	# one or more identifiers/keywords with perhaps some *'s after

												# simple id or basic template spec
$cid = "(?:$idp(?: ?const)?|$id<$idp(?: ?const)?(?:,$idp(?: ?const)?){0,8}>$p) ?";

												# a cid or template type with 1+ cid's as parameters
$t = "(?:$cid|$id<$cid(?:,$cid){0,8}>$p|$id<$id<$cid>$p(?:,$id<$cid>$p){0,8} ?>$p)";

$long_id = 0;									# flag that remembers if last message processed 
												# was a long identifier warning

$dotNET = 0;									# haven't detected that we're processing .NET messages yet


while (<>)
{

##################################################################################################
# Do .NET preprocessing, to transform into old-style messages (native CL's /WL option required):

	while (/'(([^']*)( with \[([^']*)\]))(::|')/)
	{
		$dotNET = 1;				# OK, now we know we're dealing with .NET messages...
		$text = $2;					# the original message text with placeholder names
		$keyclause = $3;			# the "with [...]" clause
		$keylist = $4;				# just the list of key/value mappings

		%map = ();					# clear the hash of key/value pairs
		while($keylist =~ /(\w+)=/)
		{
			$key = $1;
			$pos = $start = substr($keylist, $key) + length($key) + 1;
			
			$depth = 0;				# count <'s and >'s
			while ($pos <= length($keylist))
			{
				$next = substr ($keylist, $pos++, 1);
				last if $depth == 0 && ($next eq "," || $next eq "]");
				$depth++ if $next eq "<";
				$depth-- if $next eq ">";
			}
			$value = substr($keylist, $start, $pos - $start - 1);

			$map{$key} = $value;
			$keylist = substr($keylist, $pos);
			last if $next eq "]";
		}

	# Apply substitutions to the original text fragment:

		$newtext = $text;
		while(($key, $value) = each(%map))
		{
			$newtext =~ s/$key/$value/g;
		}

	# Replace the original message text with the expanded version:

		$pos = index($_, "$text");
		$_ = substr($_, 0, $pos) . $newtext . substr($_, $pos + length("$text"));

	# Delete the key/value list from the message:

		$pos = index($_, $keyclause);
		$_ = substr($_, 0, $pos) . substr($_, $pos + length($keyclause));

	}

# End .NET-specific preprocessing
#############################################################################################

# throw away those obnoxious "long identifier" warnings, and subsequent references
# to those warnings (eliminates the need for the #pragma hack):

  if (/truncated to '255'/)
  {
	$long_id = 1;								# on long identifier warnings, set flag and cycle
	next;
  }
  if ($long_id == 1)
  {
	/see reference to class template/ && next;	# one kind of message referring to the warnings
	/\(\d+\) \: while/ && next;					# VC bug spews sentence fragments relating to those warnings
  }
  $long_id = 0;									# hopefully we've now caught all the crud that followed the long identifier warning... 

# eliminate some noise:

  s/\bstd\:\://g;
  s/\bclass //g;
  s/\bstruct ([^'])/\1/g;		# don't strip "struct" for *anonymous* structs
  s/\b__thiscall //g;
  s/\(__cdecl \*\)//g;
  s/\b__cdecl\W//g;
  s/\b_STLD?\:\://g;			# for STLPort

# simplify the ubiquitous "vanilla" string and i/ostreams (w/optional default allocator):

  s/\b_?basic_(string|if?stream|of?stream|([io]?stringstream))<(char|wchar_t),char_traits<(char|wchar_t)>(,_?allocator<(char|wchar_t)>)? ?>/\1/g;
  s/\b_?basic_(string|istream|ostream)<unsigned short,char_traits<unsigned short>(,_?allocator<unsigned short>)? ?>/w\1/g;
  s/\b_?basic_(string|istream|ostream)<_(E(lem)?|CharT),_Tr(aits)?,_A(lloc)?>/\1/g;


# print "-----DEBUG---- Before main processing loop:\n$_\n";

# The following loop repeats until no transformations occur in the last complete iteration:

  for ($pass = 1; ;$pass++)			# pass count (for debugging purposes only)
  {
	my $before = $_;				# save the current line; keep looping while changes happen

	s/\b([io])stream_iterator<($t),(?:__stl_)?char,char_traits<char> *(,$t)?>/\1stream_iterator<\2>/g;

#
# Handle allocator clauses:
#

# Unless .NET with 'L' allocator policy, delete allocators from template typenames completely:

	unless ($dotNET == 1 && $alloc_policy eq 'L')
	{
		s/,? ?allocator<$t ?> ?>/>/g;
		s/,? ?allocator<$t ?>(,(0|1|true|false)) ?>/\1>/g;
	}

	if ($dotNET == 1 && $func_policy eq 'S')
	{
		s/,? ?hash_compare<$t ?> ?>/>/g;
		s/,? ?equal<$t ?> ?>/>/g;
	}

# remove allocator clauses completely if this is not .NET *AND* the
# message doesn't refer to an allocator explicitly:

	unless ($dotNET == 1 || /' to '.*allocator</)
	{
	  s/,allocator<$t ?> ?//g;							# the leading comma allows the full spec.
	  s/,const allocator<$t ?> ?&//g;					# to appear in the error message details
	}

	unless ($dotNET == 1 || /' to '.*hash_compare</)	# same for hash_compare
	{
	  s/,hash_compare<$t ?> ?//g;
	  s/,const hash_compare<$t ?> ?&//g;
	}

	unless ($dotNET == 1 || /' to '.*equal</)			# same for equal
	{
	  s/,equal<$t ?> ?//g;
	  s/,const equal<$t ?> ?&//g;
	}

# unless .NET with 'L' allocator policy, reduce any remaining allocator parameters to just "$alloc":

	unless (($dotNET == 1 && $alloc_policy eq 'L')  || ($dotNet == 0 && / to '.*allocator</))
	{
		s/\ballocator<$t ?> ?([\)'])/$alloc\1/g;
		s/\b$t\:\:_Alloc/$alloc/g;
		s/\b$t\:\:allocator_type/$alloc/g;
		s/\bconst allocator<$t ?> &([\)'])/const $alloc\1/g;
	}
	
# To debug, I place a line such as the following before suspect code
# to see progressive transformations. The "list" below would be replaced by a
# known pattern in the construct being debugged:
#/list/ && print "-----(Pass $pass)------------------------DEBUG:\n$_\n";

# STLPort vector iterators:

	s/reverse_iterator<($t) \*,\1,\1 &,\1 \*,$t>/vector<\1>::reverse_iterator/g;
	s/reverse_iterator<($t) const \*,\1,\1 const &,\1 const \*,$t>/vector<\1>::const_reverse_iterator/g;

# STLPort vector iterators under VC7:

	s/reverse_iterator<vector<($t)>::iterator,vector<\1>::value_type,vector<\1>::reference,\1 \*,vector<\1>::difference_type>/vector<\1>::reverse_iterator/g;
	s/reverse_iterator<vector<($t)>::const_iterator,vector<\1>::value_type,vector<\1>::const_reference,\1 const \*,vector<\1>::difference_type>/vector<\1>::const_reverse_iterator/g;

# STLPort list and deque iterators:

	s/\b_(Sl|L)ist_iterator<($t),_Nonconst_traits<\2 ?> ?>/\l\1ist<\2>::iterator/g;
	s/\b_(Sl|L)ist_iterator<($t),_Const_traits<\2 ?> ?>/\l\1ist<\2>::const_iterator/g;
	s/\b_Deque_iterator<($t),_Nonconst_traits<\1 ?> ?>/deque<\1>::iterator/g;
	s/\b_Deque_iterator<($t),_Const_traits<\1 ?> ?>/deque<\1>::const_iterator/g;

# more STLPort list iterators

	s/list<($t)>::iterator,list<\1>::value_type,list<\1>::reference,list<\1>::pointer,list<\1>::difference_type/list<\1>::iterator/g;
	s/list<($t)>::const_iterator,list<\1>::value_type,list<\1>::const_reference,list<\1>::const_pointer,list<\1>::difference_type/list<\1>::const_iterator/g;

# STLPort set/multiset iterators:
# Since STLPort uses the same iterator type for both set and multiset, we just
# say "gen_set<T>::iterator" to mean the "GENERIC" set/multiset iterator type:

	s/\b_Rb_tree_iterator<($t),_Nonconst_traits<\1 ?> ?>/gen_set<\1>::iterator/g;
	s/\b_Rb_tree_iterator<($t),_Const_traits<\1 ?> ?>/gen_set<\1>::const_iterator/g;
	s/\b_Rb_tree_iterator<_Rb_tree<set<($t),($t)<\1>>::key_type,set<\1,\2<\1>>::value_type,_Identity<set<\1,\2<\1>>::value_type>,set<\1,\2<\1>>::key_compare>::value_type,_Const_traits<_Rb_tree<set<\1,\2<\1>>::key_type,set<\1,\2<\1>>::value_type,_Identity<set<\1,\2<\1>>::value_type>,set<\1,\2<\1>>::key_compare>::value_type>>/gen_set<\1>::const_iterator/g;
	s/\b_Rb_tree_iterator<_Rb_tree<set<($t),($t)<\1>>::key_type,set<\1,\2<\1>>::value_type,_Identity<set<\1,\2<\1>>::value_type>,set<\1,\2<\1>>::key_compare>::value_type,_Nonconst_traits<_Rb_tree<set<\1,\2<\1>>::key_type,set<\1,\2<\1>>::value_type,_Identity<set<\1,\2<\1>>::value_type>,set<\1,\2<\1>>::key_compare>::value_type>>/gen_set<\1>::iterator/g;

# STLPort hash_set/_multiset iterators:

	s/\b_Ht_iterator<($t),_Const_traits<\1 ?> ?(,\1) ?,$id<\1>,$id<\1>,$id<\1>>/gen_hash_set<\1>::const_iterator/g;
	s/\b_Ht_iterator<($t),_Nonconst_traits<\1 ?> ?(,\1) ?,$id<\1> ?,$id<\1> ?,$id<\1>>/gen_hash_set<\1>::iterator/g;

# STLPort hash_set/_multiset iterators under VC7:

	s/\b_Ht_iterator<($t),hashtable<\1,\1,hash<\1>,_Identity<\1>,equal_to<\1>>::__const_val_traits,\1,hash<\1>,_Identity<\1>,equal_to<\1>>/gen_hash_set<\1>::const_iterator/g;

# STLPort hash_set/_multiset:

	s/\b(hash_(?:multi)?)set<($t)(,hash<\2 ?>)? ?(,equal_to<\2 ?>)? ?>/\1set<\2>/g;

# STLPort map/multimap under VC7:

	s/\b_Rb_tree<map<($t),($t)(?:,$t)?>::key_type,\1,_Select1st<\1>,map<\1,\2(,$t)?>::key_compare>/map<\1,\2>/g;
	s/\b_Rb_tree<map<($t),($t)(?:,$t)?>::key_type,(pair<\1,\2>),_Select1st<\3>,map<\1,\2(,$t)?>::key_compare>/map<\1,\2>/g;

# STLPort map/multimap iterators (same "GENERIC" iterator approach as above):

	s/\b_Rb_tree_iterator<pair<($t) const ?,($t)>,_Nonconst_traits<pair<\1 const ?,\2> > >/gen_map<\1,\2>::iterator/g;
	s/\b_Rb_tree_iterator<pair<($t) const ?,($t)>,_Const_traits<pair<\1 const ?,\2> > >/gen_map<\1,\2>::const_iterator/g;

# STLPort hash_map/_multimap iterators (same "GENERIC" iterator approach as above):

	s/\b_Ht_iterator<pair<($t) const ?,($t)>,_Nonconst_traits<pair<\1 const ?,\2> >,\1,hash<\1 ?>,_Select1st<pair<\1 const ?,\2> >,equal_to<\1 ?> ?>/gen_hash_map<\1,\2>::iterator/g;
	s/\b_Ht_iterator<pair<($t) const ?,($t)>,_Const_traits<pair<\1 const ?,\2> >,\1,hash<\1 ?>,_Select1st<pair<\1 const ?,\2> >,equal_to<\1 ?> ?>/gen_hash_map<\1,\2>::const_iterator/g;

# STLPort hash_map/_multimap iterators under VC7 (same "GENERIC" iterator approach as above):

	s/\b_Ht_iterator<pair<const ($t),($t)>,hash_map<\1,\2>::__nonconst_val_traits,\1,hash<\1 ?>,_Select1st<pair<const \1,\2> ?>,equal_to<\1 ?> ?>/gen_hash_map<\1,\2>::iterator/g;
	s/\b_Ht_iterator<pair<const ($t),($t)>,hash_map<\1,\2>::__const_val_traits,\1,hash<\1 ?>,_Select1st<pair<const \1,\2> ?>,equal_to<\1 ?> ?>/gen_hash_map<\1,\2>::const_iterator/g;


# STLPort hash_map/_multimap:

	s/\b(hash_(?:multi)?)map<($t),($t)(,hash_compare(<\2 ?>)?)? ?(,$t(<\2 ?>)?)? ?>/\1map<\2,\3>/g;
	s/\b(hash_(?:multi)?)map<($t),($t)(,equal(<\2 ?>)?)? ?>/\1map<\2,\3>/g;

# STLPort hash_map/_multimap under VC7:

	s/hashtable<pair<const ($t),($t)>,\1,hash<\1>,_Select1st<pair<const \1,\2>>,$t<\1>>/hash_map<\1,\2>/g;

# STLPort debug iterator: reduce the entire thing to just "dbg_iter"

	while (/\b_DBG_iter</)
	{
		$start = $pos = index ($_, "_DBG_iter<") + 10;
		$depth = 1;
		while ($depth)
		{
			$next = substr ($_, $pos++, 1);
			$depth++ if $next eq "<";
			$depth-- if $next eq ">";
		}
		$_ = substr($_, 0, $start - 1) . " " . substr($_, $pos);
	}
	s/\b_DBG_iter\b/dbg_iter/g;

# Dinkumware vector iterators:

	s/_Ptrit<($t),$t,\1 const \*,\1 const &,\1 \*,\1 &>/vector<\1>::const_iterator/g;
	s/_Ptrit<($t),$t,\1 \*,\1 &,\1 \*,\1 &>/vector<\1>::iterator/g;

# VC7 vector iterators:

	s/vector<($t)>::(_Tptr|pointer)\b/\1 */g;
	s/vector<($t)>::(_Ctptr|const_pointer)\b/\1 const */g;
	s/_Ptrit<vector<($t)>::value_type,vector<\1>::difference_type,\1 \*,vector<\1>::reference,vector<\1>::_Tptr2,vector<\1>::reference>/vector<\1>::iterator/g;
	s/_Ptrit<vector<($t)>::value_type,vector<\1>::difference_type,\1 const \*,vector<\1>::const_reference,vector<\1>::_Ctptr2,vector<\1>::reference>/vector<\1>::const_iterator/g;

# Dinkumware map/multimap:

	s/\b(multi)?map<($t),($t)(,$t(<\2 ?>)?)? ?>/\1map<\2,\3\4>/g;
	s/\b_Tree<_Tmap_traits<($t),($t)(,$t(<\1 ?>)?)?,(0|false) ?> ?>/map<\1,\2\3>/g;
	s/\b_Tree<_Tmap_traits<($t),($t)(,$t(<\1 ?>)?)?,(1|true) ?> ?>/multimap<\1,\2\3>/g;

# Dinkumware hash_map/hash_multimap:

	s/\b(hash_(?:multi)?)map<($t),($t)(,hash_compare(<\2 ?>)?)? ?(,$t(<\2 ?>)?)? ?>/\1map<\2,\3>/g;
	s/\b(hash_(?:multi)?)map<($t),($t)(,equal(<\2 ?>)?)? ?>/\1map<\2,\3>/g;
	s/\b(hash_(?:multi)?)map<($t),($t)(,$t(<\2 ?>)?)? ?(,$t(<\2 ?>)?)? ?>/\1map<\2,\3\4>/g;
	s/\b_Hash<_Hmap_traits<($t),($t)(,$t(<\1 ?>)?)?,(0|false) ?> ?>/hash_map<\1,\2\3>/g;
	s/\b_Hash<_Hmap_traits<($t),($t)(,$t(<\1 ?>)?)?,(1|true) ?> ?>/hash_multimap<\1,\2\3>/g;

# native VC6 list iterators:

	s/list<($t)>::iterator,\1,\1 &,\1 \*,int/list<\1>::iterator/g;
	s/list<($t)>::const_iterator,\1,\1 const &,\1 const \*,int/list<\1>::const_iterator/g;


# native VC6 map/multimap:

	s/\b_Tree<($t),pair<\1 const ?,($t) ?>,(multi)?map<\1,\2(,$t(<\1 ?>)?)? ?>\:\:_Kfn\4? ?>/\3map<\1,\2>/g;
	s/\(const pair<($t) const ?,($t) ?> \*,const pair<\1 const ?,\2 ?> \*,const $t<\1 ?> & ?&\)/($newiter, $newiter, \3<\1>)/g;

# map/multimap members common to native/Dinkum:

	s/\bconst pair<($t) const ?,($t) ?> ([\*&])/pair<\1,\2> \3/g;

# native VC6 set/multiset

 	s/\b_Tree<($t),\1,(multi)?set<\1(,$t(?:<\1 ?>)?)? ?(,$t)?>\:\:_Kfn(?:\3(?:<\1 ?>)?)? ?(,\4)?>/\2set<\1\3>/g;

# Dinkumware set/multiset:

	s/\b_Tree<_Tset_traits<($t)(,$t)?,(0|false) ?> ?>/set<\1\2>/g;
	s/\b_Tree<_Tset_traits<($t)(,$t)?,(1|true) ?> ?>/multiset<\1\2>/g;

# Dinkumware hash_set/hash_multiset:

	s/\b_Hash<_Hset_traits<($t)(,$t)?,(0|false) ?> ?>/hash_set<\1\2>/g;
	s/\b_Hash<_Hset_traits<($t)(,$t)?,(1|true) ?> ?>/hash_multiset<\1\2>/g;
	s/\blist<($t),_Hset_traits<$t(,$t)?,false>::allocator_type>/hash_set<\1>/g;

# simplify default comparison function objects (not "functors", right Chuck Allison?), but leave others intact:

	s/,_?less<$t ?>//g;
	s/,Comp<$t ?>//g;		# STLPort's default comparison function
 	s/\b(,)?const less<$t ?> &/\1less &/g;

# handle vc7 nested typedefs by substituting back their actual types:

	s/($id<($t)>)::_Pairib/pair<\1::iterator,bool>/g;				# set iterator
	s/(?:hash_)?(?:multi)?set<($t)(,$t)?>::value_type/\1/g;				# set value_type
	s/($id<($t),$t(,$t)?>)::_Pairib/pair<\1::iterator,bool>/g;		# map iter-bool pair
	s/(?:hash_)?(?:multi)?map<($t),($t)(,$t)?>::value_type/pair<\1,\2>/g;		# map value_type
	s/\blist<(_Hset_traits<($t),$id<\2>,false>)::value_type,\1::allocator_type>/hash_set<\2>/g;
	s/\blist<(_Hmap_traits<($t),($t),$id<\2>,false>)::value_type,\1::allocator_type>/hash_map<\2,\3>/g;

	last if $before eq $_;					# stop looping only if there were no changes this pass
  }

# reduce iterators according to $iter_policy:

  $olditer = '(reverse_)?(bidirectional_)?((back_)?insert_)?iterator';
  if ($iter_policy eq 'M')					# policy 'M': USUALLY remove:
  {
	unless (/( of type|' to '|from ')$t\:\:(const_)?$olditer/  # Shorten to $newiter and
			|| /iterator' does/)							   # *remove* the base type completely...
	{														   # as long as the error message doesn't	
		s/$t\:\:((const_)?$olditer)\b/\1/g;					   # mention iterators!				
	}			
  }
  elsif ($iter_policy eq 'S')								# policy 'S': ALWAYS remove:
  {
	s/$t\:\:((const_)?$olditer)\b/\1/g;						#	remove the base type completely
  }
															# All policies (including 'L'):
  s/iterator/$newiter/g; 

# reduce "double" constructor names 'T::T' to just 'T':

  s/'string\:\:string([\('])/'string\1/g;
  s/'(.*)\:\:\1([\('])/'\1\2/g;

# I'm sorry, Microsoft needs grammar lessons:

  s/take 1 parameters/take 1 parameter/g;

# get rid of that useless space between stars in ptrs-to-ptrs:

  s/ \* \* \* \*/ ****/g;
  s/ \* \* \*/ ***/g;
  s/ \* \*/ **/g;

# deal with some other non-critical (and often not even very aesthetic) spaces:

  s/ >/>/g;
  s/ ,/,/g;

# break error line at column $output_width (if non-zero):

  $pos = 0;
  if ($output_width)
  {
	while(length(substr($_, $pos)) > $output_width)
	{
		substr($_, $pos + $output_width, 0)  = "\n";
		$pos += $output_width + 1;
	}
  } 

# and FINALLY, print out the result of all transformations:

  print;

}

exit 0;			# The proxy CL.EXE will take care of returning the appropriate status to caller

