#ifndef _EMUDLL_H
#define _EMUDLL_H

#ifdef USPL_DLL_EXPORTS
#define EXP __declspec(dllexport)
#elif defined USPL_DLL_IMPORTS
#define EXP __declspec(dllimport)
#else
#define EXP
#endif

#ifdef  __cplusplus
extern "C" {
#endif

/* Defines for remez */
#define BANDPASS       1
#define DIFFERENTIATOR 2
#define HILBERT        3

#define NEGATIVE       0
#define POSITIVE       1

#define Pi             3.1415926535897932
#define Pi2            6.2831853071795865

#define GRIDDENSITY    16
#define MAXITERATIONS  40


/*
 *  Prototypes
 */

 /* Notes 1. I think some routines still may need upgrading from int to long
          2. Some routines are using the non_ routines as default (esp ffts)
          3. Should integer vector shift routines use long or ulong??
 */

/* Section 1 non-exported functions (internal only) */

/* Section 2 exported UC functions */

void EXP acorf_(float rv1[], float rvo[], long *no, long *n1);
void EXP acorf(float rv1[], float rvo[], long no, long n1);

void EXP acort_(float rv1[], float rvo[], long *no, long *n1);
void EXP acort(float rv1[], float rvo[], long no, long n1);

void EXP aspec_(float cv1[], long *inc1, float rvio[], long *inco, long *n);
void EXP aspec(float cv1[], long inc1, float rvio[], long inco, long n);

void EXP blkman_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP blkman(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP ccdotp_(float cv1[], long *inc1, float cv2[], long *inc2, float cso[], long *n);
void EXP ccdotp(float cv1[], long inc1, float cv2[], long inc2, float cso[], long n);

void EXP ccorf_(float rv1[], float rv2[], float rvo[], long *no, long *n1);
void EXP ccorf(float rv1[], float rv2[], float rvo[], long no, long n1);

void EXP ccort_(float rv1[], float rv2[], float rvo[], long *no, long *n1);
void EXP ccort(float rv1[], float rv2[], float rvo[], long no, long n1);

void EXP cdotpr_(float cv1[], long *inc1, float cv2[], long *inc2, float cso[], long *n);
void EXP cdotpr(float cv1[], long inc1, float cv2[], long inc2, float cso[], long n);

void EXP cfft_(float cv[], long *nr, long *flg);
void EXP cfft(float cv[], long n, long f);

void EXP cfftf_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cfftf(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cffti_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cffti(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cfftsc_(float cvio[], long *n);
void EXP cfftsc(float cvio[], long n);

void EXP cft2fc_(float cv1[], float cvo[], long *nr, long *nc);
void EXP cft2fc(float cv1[], float cvo[], long nr, long nc);

void EXP cft2fr_(float cv1[], float cvo[], long *nr, long *nc);
void EXP cft2fr(float cv1[], float cvo[], long nr, long nc);

void EXP cft2ic_(float cv1[], float cvo[], long *nr, long *nc);
void EXP cft2ic(float cv1[], float cvo[], long nr, long nc);

void EXP cft2ir_(float cv1[], float cvo[], long *nr, long *nc);
void EXP cft2ir(float cv1[], float cvo[], long nr, long nc);

void EXP convd_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *no, long *n2, long *ndf);
void EXP convd(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long no, long n2, long ndf);

void EXP cpow_(float cv1[], long *inc1, float *rs1, float rv[], long *inc2, float *rs2, float rvo[], long *inco, long *n);
void EXP cpow(float cv1[], long inc1, float *rs1, float rv[], long inc2, float *rs2, float rvo[], long inco, long n);

void EXP crvdiv_(float cv1[], long *inc1, float rv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP crvdiv(float cv1[], long inc1, float rv2[], long inc2, float cvo[], long inco, long n);

void EXP crvmul_(float cv1[], long *inc1, float rv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP crvmul(float cv1[], long inc1, float rv2[], long inc2, float cvo[], long inco, long n);

void EXP cspec_(float cv1[], float cv2[], float cvo[], long *n);
void EXP cspec(float cv1[], float cv2[], float cvo[], long n);

void EXP cvabs_(float cv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP cvabs(float cv1[], long inc1, float rvo[], long inco, long n);

void EXP cvadd_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvadd(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n);

void EXP cvcml_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvcml(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n);

void EXP cvcmla_(float cv1[], long *inc1, float cv2[], long *inc2, float cv3[], long *inc3, float cvo[], long *inco, long *n);
void EXP cvcmla(float cv1[], long inc1, float cv2[], long inc2, float cv3[], long inc3, float cvo[], long inco, long n);

void EXP cvcomb_(float rv1[], long *inc1, float rv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvcomb(float rv1[], long inc1, float rv2[], long inc2, float cvo[], long inco, long n);

void EXP cvconj_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvconj(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cvcsml_(float cv1[], long *inc1, float cs1[2], float cvo[], long *inco, long *n);
void EXP cvcsml(float cv1[], long inc1, float cs1[2], float cvo[], long inco, long n);

void EXP cvdiv_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvdiv(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n);

void EXP cvexp_(float rv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvexp(float rv1[], long inc1, float cvo[], long inco, long n);

void EXP cvfill_(float cs1[2], float cvo[], long *inco, long *n);
void EXP cvfill(float cs1[2], float cvo[], long inco, long n);

void EXP cvma_(float cv1[], long *inc1, float cv2[], long *inc2, float cv3[], long *inc3, float cvo[], long *inco, long *n, long *flg);
void EXP cvma(float cv1[], long inc1, float cv2[], long inc2, float cv3[], long inc3, float cvo[], long inco, long n, long flg);

void EXP cvmags_(float cv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP cvmags(float cv1[], long inc1, float rvo[], long inco, long n);

void EXP cvmexp_(float rv1[], long *inc1, float rv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvmexp(float rv1[], long inc1, float rv2[], long inc2, float cvo[], long inco, long n);

void EXP cvmgsa_(float cv1[], long *inc1, float rv1[], long *inc2, float rvo[], long *inco, long *n);
void EXP cvmgsa(float cv1[], long inc1, float rv1[], long inc2, float rvo[], long inco, long n);

void EXP cvml_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvml(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n);

void EXP cvmla_(float cv1[], long *inc1, float cv2[], long *inc2, float cv3[], long *inc3, float cvo[], long *inco, long *n);
void EXP cvmla(float cv1[], long inc1, float cv2[], long inc2, float cv3[], long inc3, float cvo[], long inco, long n);

void EXP cvmov_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvmov(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cvmul_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n, long *flg);
void EXP cvmul(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n, long flg);

void EXP cvneg_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvneg(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cvphas_(float cv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP cvphas(float cv1[], long inc1, float rvo[], long inco, long n);

void EXP cvrcip_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvrcip(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cvreal_(float rv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvreal(float rv1[], long inc1, float cvo[], long inco, long n);

void EXP cvsma_(float cv1[], long *inc1, float cs1[2], float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvsma(float cv1[], long inc1, float cs1[2], float cv2[], long inc2, float cvo[], long inco, long n);

void EXP cvsmul_(float cv1[], long *inc1, float *rs1, float cvo[], long *inco, long *n);
void EXP cvsmul(float cv1[], long inc1, float *rs1, float cvo[], long inco, long n);

void EXP cvsqrt_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP cvsqrt(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP cvsub_(float cv1[], long *inc1, float cv2[], long *inc2, float cvo[], long *inco, long *n);
void EXP cvsub(float cv1[], long inc1, float cv2[], long inc2, float cvo[], long inco, long n);

void EXP deq22_(float rv1[], long *inc1, float rv2[], float rvo[], long *inco, long *n);
void EXP deq22(float rv1[], long inc1, float rv2[], float rvo[], long inco, long n);

void EXP dotpr_(float rv1[], long *inc1, float rv2[], long *inc2, float *rso, long *n);
void EXP dotpr(float rv1[], long inc1, float rv2[], long inc2, float *rso, long n);

void EXP envel_(float rv1[], float rvo[], long *n);
void EXP envel(float rv1[], float rvo[], long n);

void EXP fftwts_(float cvo[], long *m, long *n);
void EXP fftwts(float cvo[], long m, long n);

void EXP fix2n_(float rv1[], long *inc1, short svo[], long *inco, long *n);
void EXP fix2n(float rv1[], long inc1, short svo[], long inco, long n);

void EXP fix4_(float rv1[], long *inc1, long ivo[], long *inco, long *n);
void EXP fix4(float rv1[], long inc1, long ivo[], long inco, long n);

void EXP fix4n_(float rv1[], long *inc1, long ivo[], long *inco, long *n);
void EXP fix4n(float rv1[], long inc1, long ivo[], long inco, long n);

void EXP fixbn_(float rv1[], long *inc1, unsigned char bvo[], long *inco, long *n);
void EXP fixbn(float rv1[], long inc1, unsigned char bvo[], long inco, long n);

void EXP flt2_(short sv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP flt2(short sv1[], long inc1, float rvo[], long inco, long n);

void EXP flt2iq_(short sv1[], long *inc1, float cvo1[], float cvo2[], long *n);
void EXP flt2iq(short sv1[], long inc1, float cvo1[], float cvo2[], long n);

void EXP flt4_(long iv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP flt4(long iv1[], long inc1, float rvo[], long inco, long n);

void EXP fltb_(char bv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP fltb(char bv1[], long inc1, float rvo[], long inco, long n);

void EXP fltbu_(unsigned char bv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP fltbu(unsigned char bv1[], long inc1, float rvo[], long inco, long n);

void EXP fxsl2n_(float rv1[], long *inc1, float *rs1, float *rs2, short svo[], long *inco, long *n);
void EXP fxsl2n(float rv1[], long inc1, float *rs1, float *rs2, short svo[], long inco, long n);

void EXP fxsl4n_(float rv1[], long *inc, float *rs1, float *rs2, long ivo[], long *inco, long *n);
void EXP fxsl4n(float rv1[], long inc, float *rs1, float *rs2, long ivo[], long inco, long n);

void EXP fxslbn_(float rv1[], long *inc, float *rs1, float *rs2, unsigned char bvo[], long *inco, long *n);
void EXP fxslbn(float rv1[], long inc, float *rs1, float *rs2, unsigned char bvo[], long inco, long n);

void EXP gcexp_(float cs1[], float cs2[], float cvo[], long *inco, long *n);
void EXP gcexp(float cs1[], float cs2[], float cvo[], long inco, long n);

void EXP gcosf_(float rv1[], long *inc1, float *rs1, float *rs2, long *n);
void EXP gcosf(float rv1[], long inc1, float *rs1, float *rs2, long n);

void EXP hamm_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP hamm(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP hann_(float rv1[], long *inc1, float rvo[], long *inco, long *n, long *flg);
void EXP hann(float rv1[], long inc1, float rvo[], long inco, long n, long flg);

void EXP hlbrt_(float rv1[], float rvo[], long *n);
void EXP hlbrt(float rv1[], float rvo[], long n);

void EXP lveq_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lveq(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvge_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lvge(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvgt_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lvgt(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvle_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lvle(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvlt_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lvlt(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvne_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP lvne(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP lvnot_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP lvnot(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP maxmgv_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP maxmgv(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP maxv_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP maxv(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP meamgv_(float rv1[], long *inc1, float *rso, long *n);
void EXP meamgv(float rv1[], long inc1, float *rso, long n);

void EXP meanv_(float rv1[], long *inc1, float *rso, long *n);
void EXP meanv(float rv1[], long inc1, float *rso, long n);

void EXP measqv_(float rv1[], long *inc1, float *rso, long *n);
void EXP measqv(float rv1[], long inc1, float *rso, long n);

void EXP minmgv_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP minmgv(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP minv_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP minv(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP mvessq_(float rv1[], long *inc1, float *rso, long *n);
void EXP mvessq(float rv1[], long inc1, float *rso, long n);

void EXP mxmla_(float rm1[], long *incc1, long *incr1, float rm2[], long *incc2, long *incr2, float rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP mxmla(float rm1[], long incc1, long incr1, float rm2[], long incc2, long incr2, float rmo[], long incco, long incro, long nr, long nc, long ncr);

void EXP mxmls_(float rm1[], long *incc1, long *incr1, float rm2[], long *incc2, long *incr2, float rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP mxmls(float rm1[], long incc1, long incr1, float rm2[], long incc2, long incr2, float rmo[], long incco, long incro, long nr, long nc, long ncr);

void EXP mxmov_(float rm1[], long *incc1, long *incr1, float rmo[], long *incco, long *incro, long *nr, long *nc);
void EXP mxmov(float rm1[], long incc1, long incr1, float rmo[], long incco, long incro, long nr, long nc);

void EXP mxmul_(float rm1[], long *incc1, long *incr1, float rm2[], long *incc2, long *incr2, float rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP mxmul(float rm1[], long incc1, long incr1, float rm2[], long incc2, long incr2, float rmo[], long incco, long incro, long nr, long nc, long ncr);

void EXP polar_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP polar(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP rect_(float cv1[], long *inc1, float cvo[], long *inco, long *n);
void EXP rect(float cv1[], long inc1, float cvo[], long inco, long n);

void EXP reqs_(float rv1[], long *inc1, float *rs1, long *n, long *idx);
void EXP reqs(float rv1[], long inc1, float *rs1, long n, long *idx);

void EXP rfft_(float rvio[], long *n, long *flg);
void EXP rfft(float rvio[], long n, long flg);

void EXP rfftf_(float rv1[], long *inc1, float cvo[], long *inco, float *rs1, long *n);
void EXP rfftf(float rv1[], long inc1, float cvo[], long inco, float *rs1, long n);

void EXP rffti_(float cv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP rffti(float cv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP rfftsc_(float cvio[], long *n, long *flg1, long *flg2);
void EXP rfftsc(float cvio[], long n, long flg1, long flg2);

void EXP rft2fc_(float rv1[], float cvn[], long *inc2, float cvo[], long *nr, long *nc);
void EXP rft2fc(float rv1[], float cvn[], long inc2, float cvo[], long nr, long nc);

void EXP rft2fr_(float rv1[], float cvn[], long *inc2, float cvo[], long *nr, long *nc);
void EXP rft2fr(float rv1[], float cvn[], long inc2, float cvo[], long nr, long nc);

void EXP rft2ic_(float cv1[], float cvn[], long *inc2, float rvo[], long *nr, long *nc);
void EXP rft2ic(float cv1[], float cvn[], long inc2, float rvo[], long nr, long nc);

void EXP rft2ir_(float cv1[], float cvn[], long *inc2, float rvo[], long *nr, long *nc);
void EXP rft2ir(float cv1[], float cvn[], long inc2, float rvo[], long nr, long nc);

void EXP rges_(float rv1[], long *inc1, float *rs1, long *n, long *idx);
void EXP rges(float rv1[], long inc1, float *rs1, long n, long *idx);

void EXP rgts_(float rv1[], long *inc1, float *rs1, long *n, long *idx);
void EXP rgts(float rv1[], long inc1, float *rs1, long n, long *idx);

void EXP rlts_(float rv1[], long *inc1, float *rs1, long *n, long *idx);
void EXP rlts(float rv1[], long inc1, float *rs1, long n, long *idx);

void EXP rmax_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP rmax(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP rmaxmg_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP rmaxmg(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP rmin_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP rmin(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP rminmg_(float rv1[], long *inc1, float *rso, long *idx, long *n);
void EXP rminmg(float rv1[], long inc1, float *rso, long *idx, long n);

void EXP rmsqv_(float rv1[], long *inc1, float *rso, long *n);
void EXP rmsqv(float rv1[], long inc1, float *rso, long n);

void EXP rnes_(float rv1[], long *inc1, float *rs1, long *n, long *idx);
void EXP rnes(float rv1[], long inc1, float *rs1, long n, long *idx);

void EXP rsve_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *no, long *nw);
void EXP rsve(float rv1[], long inc1, float *rs1, float rvo[], long inco, long no, long nw);

void EXP shphu_(float rv1[], long *inc1, float *rs, float rvo[], long *inco, long *n);
void EXP shphu(float rv1[], long inc1, float *rs, float rvo[], long inco, long n);

void EXP shphuf_(float rv1[], long *inc1, float *rs, float rvo[], long *inco, long *n);
void EXP shphuf(float rv1[], long inc1, float *rs, float rvo[], long inco, long n);

void EXP sn2_(float rv1[], long *inc1, float rv2[], long *inc2, float *rso, long *n);
void EXP sn2(float rv1[], long inc1, float rv2[], long inc2, float *rso, long n);

void EXP svdiv_(float *rs1, float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP svdiv(float *rs1, float rv1[], long inc1, float rvo[], long inco, long n);

void EXP sve_(float rv1[], long *inc1, float *rso, long *n);
void EXP sve(float rv1[], long inc1, float *rso, long n);

void EXP svemg_(float rv1[], long *inc1, float *rso, long *n);
void EXP svemg(float rv1[], long inc1, float *rso, long n);

void EXP svesq_(float rv1[], long *inc1, float *rso, long *n);
void EXP svesq(float rv1[], long inc1, float *rso, long n);

void EXP svessq_(float rv1[], long *inc1, float *rso, long *n);
void EXP svessq(float rv1[], long inc1, float *rso, long n);

void EXP tconv_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *no, long *n2, long *n1);
void EXP tconv(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long no, long n2, long n1);

void EXP trans_(float rv1[], float cv1[], float cvo[], long *n);
void EXP trans(float rv1[], float cv1[], float cvo[], long n);

void EXP vaam_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rv4[], long *inc4, float rvo[], long *inco, long *n);
void EXP vaam(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rv4[], long inc4, float rvo[], long inco, long n);

void EXP vabs_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vabs(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vacos_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vacos(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vadd_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vadd(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vaint_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vaint(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vam_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vam(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vanint_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vanint(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vasbm_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rv4[], long *inc4, float rvo[], long *inco, long *n);
void EXP vasbm(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rv4[], long inc4, float rvo[], long inco, long n);

void EXP vasin_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vasin(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vasm_(float rv1[], long *inc1, float rv2[], long *inc2, float *rs1, float rvo[], long *inco, long *n);
void EXP vasm(float rv1[], long inc1, float rv2[], long inc2, float *rs1, float rvo[], long inco, long n);

void EXP vatan_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vatan(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vatan2_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vatan2(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vatn2f_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vatn2f(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vavexp_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vavexp(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vavlin_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vavlin(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vclip_(float rv1[], long *inc1, float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP vclip(float rv1[], long inc1, float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP vclr_(float rv1[], long *inc1, long *n);
void EXP vclr(float rv1[], long inc1, long n);

void EXP vcmprs_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vcmprs(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vcos_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vcos(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vcosf_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vcosf(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vdbpwr_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vdbpwr(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vdiv_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vdiv(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vdpsp_(double dv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vdpsp(double dv1[], long inc1, float rvo[], long inco, long n);

void EXP veucl2_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP veucl2(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP veucl3_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP veucl3(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vexp_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vexp(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vexp10_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vexp10(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vexp2_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vexp2(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vfill_(float *rs1, float rvo[], long *inco, long *n);
void EXP vfill(float *rs1, float rvo[], long inco, long n);

void EXP vfrac_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vfrac(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vfracn_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vfracn(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vgathr_(float rv1[], long iv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vgathr(float rv1[], long iv2[], long inc2, float rvo[], long inco, long n);

void EXP vgen_(float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP vgen(float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP viadd_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP viadd(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP viand_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP viand(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP viars_(long iv1[], long *inc1, long *is1, long ivo[], long *inco, long *n);
void EXP viars(long iv1[], long inc1, long is1, long ivo[], long inco, long n);

void EXP viclip_(float rv1[], long *inc1, float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP viclip(float rv1[], long inc1, float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP vils_(long iv1[], long *inc1, long *is1, long ivo[], long *inco, long *n);
void EXP vils(long iv1[], long inc1, long is1, long ivo[], long inco, long n);

void EXP vimag_(float cv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vimag(float cv1[], long inc1, float rvo[], long inco, long n);

void EXP vimul_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP vimul(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP vindex_(float rv1[], float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vindex(float rv1[], float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vineg_(long iv1[], long *inc1, long ivo[], long *inco, long *n);
void EXP vineg(long iv1[], long inc1, long ivo[], long inco, long n);

void EXP vintb_(float rv1[], long *inc1, float rv2[], long *inc2, float *rs1, float rvo[], long *inco, long *n);
void EXP vintb(float rv1[], long inc1, float rv2[], long inc2, float *rs1, float rvo[], long inco, long n);

void EXP vior_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP vior(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP virs_(long iv1[], long *inc1, long *is1, long ivo[], long *inco, long *n);
void EXP virs(long iv1[], long inc1, long is1, long ivo[], long inco, long n);

void EXP visub_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP visub(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP vixor_(long iv1[], long *inc1, long iv2[], long *inc2, long ivo[], long *inco, long *n);
void EXP vixor(long iv1[], long inc1, long iv2[], long inc2, long ivo[], long inco, long n);

void EXP vlim_(float rv1[], long *inc1, float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP vlim(float rv1[], long inc1, float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP vlint_(float rv1[], long *n1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vlint(float rv1[], long n1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vlmerg_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vlmerg(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vlog_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vlog(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vlog10_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vlog10(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vlog2_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vlog2(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vma_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vma(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vmax_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vmax(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vmaxmg_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vmaxmg(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vmin_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vmin(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vminmg_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vminmg(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vmma_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rv4[], long *inc4, float rvo[], long *inco, long *n);
void EXP vmma(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rv4[], long inc4, float rvo[], long inco, long n);

void EXP vmmsb_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rv4[], long *inc4, float rvo[], long *inco, long *n);
void EXP vmmsb(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rv4[], long inc4, float rvo[], long inco, long n);

void EXP vmov_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vmov(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vmsa_(float rv1[], long *inc1, float rv2[], long *inc2, float *rs1, float rvo[], long *inco, long *n);
void EXP vmsa(float rv1[], long inc1, float rv2[], long inc2, float *rs1, float rvo[], long inco, long n);

void EXP vmsb_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vmsb(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vmul_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vmul(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vnabs_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vnabs(float rv1[], long in1c, float rvo[], long inco, long n);

void EXP vneg_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vneg(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vnmsa_(float rv1[], long *inc1, float rv2[], long *inc2, float *rs1, float rvo[], long *inco, long *n);
void EXP vnmsa(float rv1[], long inc1, float rv2[], long inc2, float *rs1, float rvo[], long inco, long n);

void EXP vpmerg_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vpmerg(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vpoly_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n, long *n1);
void EXP vpoly(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n, long n1);

void EXP vqint_(float rv1[], long *nrv1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vqint(float rv1[], long nrv1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vramp_(float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP vramp(float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP vrand_(long *is1, float rvo[], long *inco, long *n);
void EXP vrand(long *is1, float rvo[], long inco, long n);

void EXP vreal_(float cv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vreal(float cv1[], long inc1, float rvo[], long inco, long n);

void EXP vrecip_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vrecip(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vrsqrt_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vrsqrt(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vrvrs_(float rv1[], long *inc1, long *n);
void EXP vrvrs(float rv1[], long inc1, long n);

void EXP vsadd_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vsadd(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vsbm_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rvo[], long *inco, long *n);
void EXP vsbm(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rvo[], long inco, long n);

void EXP vsbsbm_(float rv1[], long *inc1, float rv2[], long *inc2, float rv3[], long *inc3, float rv4[], long *inc4, float rvo[], long *inco, long *n);
void EXP vsbsbm(float rv1[], long inc1, float rv2[], long inc2, float rv3[], long inc3, float rv4[], long inc4, float rvo[], long inco, long n);

void EXP vsbsm_(float rv1[], long *inc1, float rv2[], long *inc2, float *rs1, float rvo[], long *inco, long *n);
void EXP vsbsm(float rv1[], long inc1, float rv2[], long inc2, float *rs1, float rvo[], long inco, long n);

void EXP vscatr_(float rv1[], long *inc1, long iv2[], long *inc2, float rvo[], long *n);
void EXP vscatr(float rv1[], long inc1, long iv2[], long inc2, float rvo[], long n);

void EXP vsdiv_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vsdiv(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vsimps_(float rv1[], long *inc1, float rvo[], long *inco, long *n, float *rs1);
void EXP vsimps(float rv1[], long inc1, float rvo[], long inco, long n, float *rs1);

void EXP vsin_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vsin(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vsinf_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vsinf(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vsinrf_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vsinrf(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vsm2sa_(float rv1[], long *inc1, float *rs1, float rv2[], long *inc2, float *rs2, float *rs3, float rvo[], long *inco, long *n);
void EXP vsm2sa(float rv1[], long inc1, float *rs1, float rv2[], long inc2, float *rs2, float *rs3, float rvo[], long inco, long n);

void EXP vsma_(float rv1[], long *inc1, float *rs1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vsma(float rv1[], long inc1, float *rs1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vsma2_(float rv1[], float *rs1, float rv2[], float *rs2, long *inc, float rvo[], long *inco, long *n);
void EXP vsma2(float rv1[], float *rs1, float rv2[], float *rs2, long inc, float rvo[], long inco, long n);

void EXP vsma3_(float rv1[], float *rs1, float rv2[], float *rs2, float rv3[], float *rs3, long *inc, float rvo[], long *inco, long *n);
void EXP vsma3(float rv1[], float *rs1, float rv2[], float *rs2, float rv3[], float *rs3, long inc, float rvo[], long inco, long n);

void EXP vsma4_(float rv1[], float *rs1, float rv2[], float *rs2, float rv3[], float *rs3, float rv4[], float *rs4, long *inc, float rvo[], long *inco, long *n);
void EXP vsma4(float rv1[], float *rs1, float rv2[], float *rs2, float rv3[], float *rs3, float rv4[], float *rs4, long inc, float rvo[], long inco, long n);

void EXP vsmsa_(float rv1[], long *inc1, float *rs1, float *rs2, float rvo[], long *inco, long *n);
void EXP vsmsa(float rv1[], long inc1, float *rs1, float *rs2, float rvo[], long inco, long n);

void EXP vsmsb_(float rv1[], long *inc1, float *rs1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vsmsb(float rv1[], long inc1, float *rs1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vsmul_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vsmul(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vspdp_(float rv1[], long *inc1, double dvo[], long *inco, long *n);
void EXP vspdp(float rv1[], long inc1, double dvo[], long inco, long n);

void EXP vsq_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vsq(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vsqrt_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vsqrt(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vssq_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vssq(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vsub_(float rv1[], long *inc1, float rv2[], long *inc2, float rvo[], long *inco, long *n);
void EXP vsub(float rv1[], long inc1, float rv2[], long inc2, float rvo[], long inco, long n);

void EXP vsum_(float rv1[], long *inc1, float rvo[], long *inco, long *n, float *rs1);
void EXP vsum(float rv1[], long inc1, float rvo[], long inco, long n, float *rs1);

void EXP vswap_(float rv1[], long *inc1, float rv2[], long *inc2, long *n);
void EXP vswap(float rv1[], long inc1, float rv2[], long inc2, long n);

void EXP vtabi_(float rv1[], long *inc1, float *rs1, float *rs2, float rv2[], float rvo[], long *inco, long *n2, long *n);
void EXP vtabi(float rv1[], long inc1, float *rs1, float *rs2, float rv2[], float rvo[], long inco, long n2, long n);

void EXP vtan_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vtan(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vtanf_(float rv1[], long *inc1, float rvo[], long *inco, long *n);
void EXP vtanf(float rv1[], long inc1, float rvo[], long inco, long n);

void EXP vthr_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vthr(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vthres_(float rv1[], long *inc1, float *rs1, float rvo[], long *inco, long *n);
void EXP vthres(float rv1[], long inc1, float *rs1, float rvo[], long inco, long n);

void EXP vtrapz_(float rv1[], long *inc1, float rvo[], long *inco, long *n, float *rs1);
void EXP vtrapz(float rv1[], long inc1, float rvo[], long inco, long n, float *rs1);

void EXP vxcs_(float rv1[], float cvo[], long *inco, float *rs1, float *rs2, long *n);
void EXP vxcs(float rv1[], float cvo[], long inco, float *rs1, float *rs2, long n);

void EXP vxcsf_(float rv1[], long *inc1, float cvo[], long *inco, float *rs1, float *rs2, long *n);
void EXP vxcsf(float rv1[], long inc1, float cvo[], long inco, float *rs1, float *rs2, long n);

void EXP wiener_(long *LR, float R[], float G[], float F[], float A[], long *ISW, long *IERR);
void EXP wiener(long LR, float R[], float G[], float F[], float A[], long ISW, long *IERR);

/* Section 3 - Sigma Tech exported Functions */

void EXP convrrs_(float rv1[], long *inc1, float rv2[], long *inc2, float  rvo[],
                 long *inco, long *no, long *n2);
void EXP convrrs(float rv1[], long inc1, float rv2[], long inc2, float  rvo[],
                 long inco, long no, long n2);
/*
void EXP convrrs2_(float rv1[], float rv2[], float  rvo[], long *no, long *n2);
*/
void EXP convrr_(float rv1[], long *inc1, float rv2[], long *inc2, float  rvo[],
                 long *inco, long *no, long *n2);
void EXP convrr(float rv1[], long inc1, float rv2[], long inc2, float  rvo[],
                long inco, long no, long n2);

long EXP remez(double h[], int numtaps,
           int numband, double bands[], double des[], double weight[],
           int type);

long EXP genorder(float fs, float center_freq, float bandwidth, float transition_width,
				 float pass_ripple,float stop_ripple, long *numcoeff);
long EXP genorder_(float *fs, float *center_freq, float *bandwidth, float *transition_width,
				 float *pass_ripple,float *stop_ripple, long *numcoeff);

long EXP genfilt(float fs, float center_freq, float bandwidth, float transition_width,
				 float pass_ripple,float stop_ripple, long *numcoeff, double **coeffs, long type);
long EXP genfilt_(float *fs, float *center_freq, float *bandwidth, float *transition_width,
				 float *pass_ripple,float *stop_ripple, long *numcoeff, double **coeffs, long *type);

void EXP leveldet_(float rv1[], long *noise, long *gap, long *sig, float *thresh, long *maxsearch,
                   long *det, float *avg, float *siglevel, long *n);
void EXP leveldet(float rv1[], long noise, long gap, long sig, float thresh, long maxsearch,
                   long *det, float *avg, float *siglevel, long n);

void EXP dmxmla_(double rm1[], long *incc1, long *incr1, double rm2[], long *incc2, long *incr2, double rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP dmxmla(double rm1[], long incc1, long incr1, double rm2[], long incc2, long incr2, double rmo[], long incco, long incro, long nr, long nc, long ncr);

void EXP dmxmls_(double rm1[], long *incc1, long *incr1, double rm2[], long *incc2, long *incr2, double rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP dmxmls(double rm1[], long incc1, long incr1, double rm2[], long incc2, long incr2, double rmo[], long incco, long incro, long nr, long nc, long ncr);

void EXP dmxmov_(double rm1[], long *incc1, long *incr1, double rmo[], long *incco, long *incro, long *nr, long *nc);
void EXP dmxmov(double rm1[], long incc1, long incr1, double rmo[], long incco, long incro, long nr, long nc);

void EXP dmxmul_(double rm1[], long *incc1, long *incr1, double rm2[], long *incc2, long *incr2, double rmo[], long *incco, long *incro, long *nr, long *nc, long *ncr);
void EXP dmxmul(double rm1[], long incc1, long incr1, double rm2[], long incc2, long incr2, double rmo[], long incco, long incro, long nr, long nc, long ncr);

float EXP fastcosf(float in);
float EXP fastsinf(float in);
double EXP fastcos(double in);
double EXP fastsin(double in);

float EXP fastabsf(float in);

long EXP dbltolr(double x);
long EXP dbltol(double x);
long EXP flttolr(float x);
long EXP flttol(float x);
short EXP flttosr(float x);
short EXP flttos(float x);
unsigned char EXP flttobr(float x);
unsigned char EXP flttob(float x);

#ifdef USPL_DEMO
void CheckCall();
#endif

#ifdef  __cplusplus
}
#endif

#define FASTABS(x) (x>=0.0) ? x: -x
#define FASTNABS(x) (x>=0.0) ? -x: x


#endif  /* end ifdef EMU_DLL_H */




