/* Tower of hanoi */
/* Note, this program uses curses, so you'd either have to load a library 
   of external functions, or you must run it from another application, 
   that has registered the neccessary functions (hanoi.c) */

say starting
call charout ,"Number of discs (3-12) ? "
parse pull disks .

lib = './curses.rxlib'
if rxfuncadd('CURSES',lib,'curses')  then do
   say 'An error occured when trying to load the library: "'lib'"'
   say 'The error message returned was: "'rxfuncerrmsg()'"'
   say 'Exiting...'
   exit
   end

call curses('CUR_')
call cur_initscr

call cur_clear
call cur_erase
call cur_refresh


pole.1 = "" 
pole.2 = ""
pole.3 = ""
pole.height = disks 

do i=1 to disks 
   pole.1 = space( i pole.1 )
   end

parse value  13 40 66  with pole.pos.1 pole.pos.2 pole.pos.3

call setup_screen 
call move_stack disks 1 3 2
call cur_endwin

exit 0

move_stack: procedure expose pole. /* screen. */
   parse arg num from target scratch
   if num <= 0 then 
      return

   call move_stack num-1 from scratch target
   call move_plate from target
   call move_stack num-1 scratch target from
   return 



move_plate: procedure expose pole. /* screen. */
   parse arg from target
   
   plate = word( pole.from, words( pole.from )) 
/* pole.from = subword( pole.from, 1, words( pole.from ) - 1 )  */
   pole.from = reverse( pole.from )
   parse var pole.from . pole.from 
   pole.from = reverse( pole.from ) 
   
   if 0 then
      say 'Moving plate' plate 'from pole' from 'to pole' target
   else
      call draw_a_move plate from target

   pole.target = pole.target plate
   return


draw_a_move: procedure expose pole. /* screen. */
   parse arg plate from target

   screen.height = 20
   screen.width = 80 
   top = screen.height - pole.height - 2
   full = copies('#', plate*2+1)
   empty = center('|', plate*2+1)
   real_empty = copies( ' ', plate*2+1)

   do i=words(pole.from) to pole.height+1
      call cur_move screen.height-i-2, pole.pos.from-plate
      call cur_addstr full
      call cur_move screen.height-i-1, pole.pos.from-plate
      if (i>pole.height) then
         call cur_addstr real_empty
      else
         call cur_addstr empty
      call cur_refresh
      end

   top = screen.height - pole.height - 3
   step = sign( pole.pos.target - pole.pos.from ) ;
   do i=pole.pos.from to pole.pos.target-step by step
      call cur_move top, i-step*plate
      call cur_addch ' '
      call cur_move top, i+step*plate+step
      call cur_addch '#'
      call cur_refresh 
      end


   j = screen.height - pole.height - 1
   do i=0 to pole.height + 1 - words(pole.target)
      call cur_move j+i-1, pole.pos.target-plate
      call cur_addstr full
      call cur_move j+i-2, pole.pos.target-plate
      if (i<=1) then
         call cur_addstr real_empty
      else
         call cur_addstr empty
      call cur_refresh
      end

   return 


setup_screen: 
   screen.height = 20
   screen.width = 80 
   

   do i=1 to disks
      call cur_move screen.height-i, pole.pos.1-(disks+1-i)
      call cur_addstr copies('#', 2*(disks-i)+3)
      end

   call cur_move (screen.height-(disks+1)), pole.pos.1
   call cur_addch '|'

   do i=1 to disks+1
      call cur_move screen.height-i, pole.pos.2
      call cur_addch '|'
      call cur_move screen.height-i, pole.pos.3
      call cur_addch '|'
      end

   call cur_refresh

   return

trap_msg:
   say 
   say 'Sorry, this script is not meant to be executed directly from the'
   say 'command line. It is a demonstration of the use of the libregina.a'
   say 'library. Try to compile "hanoi.c", and like with libregina.a, and'
   say 'try to run the "hanoi" program. Enjoy!'
   say 
   exit 0
