/*
**  EMAIL.C
**
**  Win32 console program.
**
**  Emails a file from the keyboard. For example, to email
**  the file "example.txt" to mike@marshallsoft.com, type
**
**  email mike@marshallsoft.com example.txt
**
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <string.h>
#include "wil.h"
#include "str.h"
#include "cons.h"

#define MAX_STR  50
#define MAX_BUF 256

#define SMTP_PORT 25

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

/* Programmer: Put your greeting & email address below */
static LPSTR Greetings = "WIL4C Application";
static LPSTR FromName = "msc@traveller.com";

static char Temp[MAX_BUF+8];
static char InBuffer[MAX_BUF+1];
static char UserName[MAX_STR] = "";
static char HostName[MAX_STR] = "";
static SOCKET Socket = 0;
static ULONG  HostAddr = 0;

static HANDLE ConIn;
static HANDLE ConOut;
static DWORD OldMode;
static DWORD NewMode;
static int FileHandle = 0;

/* display error */

static void DisplayError(HANDLE Handle, int Code, LPSTR Msg)
{PutString(Handle ,"ERROR: ");
 if(Msg) PutString(Handle,Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,MAX_BUF);
    PutLine(Handle,(LPSTR)Temp);
   }
}

/* display error & exit (before calling wilAttach) */

void SayError(LPSTR Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

void ShutDown(void)
{PutLine(ConOut,"Shutting down...");
 wilRelease();
 SetConsoleMode(ConIn, OldMode);
 exit(0);
}

int SmtpCommand(SOCKET Socket, LPSTR Command)
{int Code;
 /* email command */
 Code = wilWriteLine(Socket,(LPSTR)Command);
 PutLine(ConOut,(LPSTR)Command);
 if(Code<0)
   {DisplayError(ConOut, Code, NULL);
    return Code;
   }
 if(!wilDataIsReady(Socket,5000)) return WIL_EOF;
 /* get response line */
 while(1)
   {/* read line*/
    Code = wilReadLine(Socket,(LPSTR)InBuffer,MAX_BUF);
    if(Code==WIL_EOF) return WIL_NO_ERROR;
    if(Code<0)
       {DisplayError(ConOut,Code,"wilReadLine:");
        return Code;
       }
    if(Code>0)
       {wsprintf((LPSTR)Temp,">%s", (LPSTR)InBuffer);
        PutString(ConOut,(LPSTR)Temp);
       }
    if(!wilDataIsReady(Socket,1000)) return WIL_NO_ERROR;
   } /*end-while(1)*/
 }

/*** main ***/

void main(int argc, char *argv[])
{
 int   Code;
 BOOL  Success;
 LPSTR Ptr;
 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* check arguments */
 if(argc!=3)
   {PutLine(ConOut,"Usage: email user@host filename");
    PutLine(ConOut,"   Eg: email mike@marshallsoft.com wil4c_u.txt");
    ShutDown();
   }
 /* open file for read */
 FileHandle = _lopen(argv[2],OF_READ|OF_SHARE_DENY_WRITE);
 if(FileHandle<0)
   {wsprintf((LPSTR)Temp,"Cannot open '%s'", argv[2]);
    PutLine(ConOut,(LPSTR)Temp);
    ShutDown();
   }
 wsprintf((LPSTR)Temp,"File %s opended for read access", (LPSTR)argv[2]);
 PutLine(ConOut,(LPSTR)Temp);
 /* attach WINSOCK */
 PutString(ConOut,"Attaching WINSOCK...");
 Code = wilAttach();
 PutLine(ConOut,"OK");
 if(Code<0) DisplayError(ConOut,Code,"wilAttach fails:");
 else
   {PutString(ConOut," Description: ");
    wilGetDescription((LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
    PutString(ConOut,"My Host Name: ");
    wilGetMyHostName((LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
    PutString(ConOut,"My Host Addr: ");
    wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
    PutLine(ConOut,(LPSTR)Temp);
   }
 /* extract user name */
 lstrcpy((LPSTR)InBuffer,(LPSTR)argv[1]);
 Ptr = StringChar((LPSTR)InBuffer,'@');
 if(Ptr==NULL)
   {DisplayError(ConOut, Code, "Cannot recognize User@Host");
    ShutDown();
   }
 *Ptr++ = '\0';
 /* extract host name  */
 lstrcpy((LPSTR)UserName, (LPSTR)InBuffer);
 lstrcpy((LPSTR)HostName, (LPSTR)(Ptr));
#if 1
 wsprintf((LPSTR)Temp,"User ='%s'", (LPSTR)UserName);
 PutLine(ConOut,Temp);
 wsprintf((LPSTR)Temp,"Host ='%s'", (LPSTR)HostName);
 PutLine(ConOut,Temp);
#endif
 /* get host name */
 if(wilIsDotted((LPSTR)HostName))
   {/* already have IP address */
    HostAddr = wilMakeAddr((LPSTR)HostName);
   }
  else
   {/* ask DNS for IP address */
    HostAddr = wilGetHostAddr((LPSTR)HostName,0);
    if(HostAddr==0)
      {DisplayError(ConOut, 0, "Cannot get IP addess");
       ShutDown();
      }
   }
 /* display remote host address */
 PutString(ConOut,"HostAddr = ");
 wilMakeDotted(HostAddr,(LPSTR)Temp,MAX_BUF);
 PutLine(ConOut,(LPSTR)Temp);
 /* create socket */
 Socket = wilTcpSocket();
 if((int)Socket<0)
   {DisplayError(ConOut, (int)Code, NULL);
    ShutDown();
   }
 /* attempt to connect to remote host */
 Code = wilConnect(Socket,HostAddr,SMTP_PORT);
 if(Code<0)
   {DisplayError(ConOut, Code, NULL);
    ShutDown();
   }
 PutString(ConOut,"Connecting to SMTP server...");
 /* wait up to 30 seconds for connection */
 if(wilIsConnected(Socket,30000)) PutLine(ConOut,"OK");
 else
   {DisplayError(ConOut,0, "Cannot CONNECT");
    ShutDown();
   }
 wsprintf((LPSTR)Temp,"HELO %s",(LPSTR)Greetings);
 SmtpCommand(Socket,(LPSTR)Temp);
 wsprintf((LPSTR)Temp,"MAIL FROM: %s",(LPSTR)FromName);
 SmtpCommand(Socket,(LPSTR)Temp);
 wsprintf((LPSTR)Temp,"RCPT TO:%s",(LPSTR)UserName);
 SmtpCommand(Socket,(LPSTR)Temp);
 SmtpCommand(Socket,(LPSTR)"DATA");
 /* send file (in small chunks) */
 PutString(ConOut,"Sending data...");
 while(1)
   {Code = _lread(FileHandle,(LPSTR)InBuffer,80);
    if(Code<=0) break;
    Code = wilWriteSocket(Socket,(LPSTR)InBuffer,Code);
    if(Code<0)
      {DisplayError(ConOut, Code, NULL);
       ShutDown();
      }
   }
 SmtpCommand(Socket,(LPSTR)"\r\n.\r\n");
 PutLine(ConOut,"OK");
 SmtpCommand(Socket,(LPSTR)"QUIT");
 PutLine(ConOut,"\r\nSMTP completed.");
 wilCloseSocket(Socket,500);
 ShutDown();
} /* end main */
