/*
 * Copyright (c) 1980, 1987 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Wed Jun 22 22:22:37 1994, faith@cs.unc.edu:
 *     Added internationalization patches from Vitor Duarte <vad@fct.unl.pt>
 * Fri Jun 13 10:39:00 1997, tfelix@fred.net:
 *     Got this from Linux Slackware 3.2
 *     Ported to Win32, removed -a option and executable processing
 *     Found bug:
 * 	   if (!(bfr = malloc((u_int)minlen))) {
 *     should be:
 *       if (!(bfr = malloc((u_int)(minlen + 1)))) {
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980, 1987 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)strings.c	5.10 (Berkeley) 5/23/91";
#endif /* not lint */

#include <sys/types.h>
typedef unsigned char u_char;
typedef unsigned int u_int;

#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#pragma warning (disable : 4032)
#include <conio.h>
#pragma warning (default : 4032)
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#define DEF_LEN		4		/* default minimum string length */

#if 0
/* Microsoft's isprint() isn't too picky */
#define ISSTR(ch)	(isprint(ch) || ch == '\t')
#else
/* This is better, although not international */
#define ISSTR(ch) (ch >= 0x20  &&  ch <= 0x7E  ||  ch == '\t')
#endif

static long	foff;			/* offset in the file */

static void usage();
int getch2();

void
main(int argc, char **argv)
{
	extern char *optarg;
	extern int optind;
	register int ch, cnt;
	register u_char *C;
	int exitcode, minlen;
	short oflg, fflg;
	u_char *bfr;
	char *file, *p;

	/* Removed -a flag for Win32 */

	exitcode = fflg = oflg = 0;
	minlen = -1;

	/* Process options */
	while ((ch = getopt(argc, argv, "-0123456789n:of")) != EOF)
		switch((char)ch) {
		case '0': case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
			/*
			 * kludge: strings was originally designed to take
			 * a number after a dash.
			 */
			if (minlen == -1) {
				p = argv[optind - 1];
				if (p[0] == '-' && p[1] == ch && !p[2])
					minlen = atoi(++p);
				else
					minlen = atoi(argv[optind] + 1);
			}
			break;
		case 'f':
			fflg = 1;
			break;
		case 'n':
			minlen = atoi(optarg);
			break;
		case 'o':
			oflg = 1;
			break;
		case '?':
		default:
			usage();
		}

	/* Move up to files */
	argc -= optind;
	argv += optind;

	/* If no length was specified */
	if (minlen == -1)
		minlen = DEF_LEN;  /* Use the default */

	/* Allocate a buffer for collecting printable chars */
	bfr = malloc((u_int)(minlen + 1));
	if (!bfr) {
		(void)fprintf(stderr, "strings: %s\n", strerror(errno));
		exit(1);
	}

	/* Null terminate the buffer */
	bfr[minlen] = '\0';

	/* Assume stdin */
	file = "stdin";

	/* For each file */
	do {
		if (*argv) {
			// Get filename and open it
			file = *argv++;
			if (!freopen(file, "rb", stdin)) {
				(void)fprintf(stderr,
				    "strings; %s: %s\n", file, strerror(errno));
				exitcode = 1;
				goto nextfile;
			}
		}
		foff = 0;
		C = bfr;

		/* For each character in the current file */
		for (cnt = 0; (ch = getch2()) != EOF;) {
			/* If it is a printable char */
			if (ISSTR(ch)) {
				if (!cnt)
					C = bfr;
				*C++ = (u_char)ch;
				/* If we don't have at least minlen printables */
				if (++cnt < minlen)
					continue;
				if (fflg)
					printf("%s:", file);
				if (oflg)
					printf("%07ld %s",
					    foff - minlen, (char *)bfr);
				else
					printf("%s", bfr);

				/* Display the rest of the printable chars */
				while ((ch = getch2()) != EOF && ISSTR(ch))
					putchar((char)ch);
				putchar('\n');
			}
			cnt = 0;
		}
nextfile: ;
	} while (*argv);
	exit(exitcode);
}

int 
getch2()
{
	++foff;
	return(getchar());
}

static void
usage()
{
	(void)fprintf(stderr,
	    "usage: strings [-fo] [-n length] [file ... ]\n");
	exit(1);
}
