//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#define INITGUID
#include <d3drmwin.h>
#include "FrmSplsh.h"
//---------------------------------------------------------------------------
USERES("XCube.res");
USERC("Xframe.rc");
USERC("hrstrngs.rc");
USEUNIT("D3dVCs.cpp");
USEUNIT("D3dUtil.cpp");
USEFORM("FrmSplsh.cpp", SplashForm);
USEFORM("FrmCube.cpp", CubeForm);
USEFORM("FrmSetup.cpp", SetupForm);
USEUNIT("DXEnum.cpp");
USEUNIT("D3dInOut.cpp");
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
    try
    {
        SplashForm = new TSplashForm(Application);
        SplashForm->ProductName->Caption = "X-Cube";
        SplashForm->Status->Caption = "Initializing...";
        SplashForm->Show();
        SplashForm->Update();
        Application->Initialize();
        Application->Title = "X-Cube";
        Application->CreateForm(__classid(TCubeForm), &CubeForm);
        Application->CreateForm(__classid(TSetupForm), &SetupForm);
        SplashForm->Status->Caption = "";
        SplashForm->Hide();
        SplashForm->Close();
        Application->Run();
    }
    catch (Exception &exception)
    {
        if (!exception.ClassNameIs("EInvalidOp"))
        Application->ShowException(&exception);
    }
    return 0;
}
//---------------------------------------------------------------------------
