/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
/*
 * Statement parser
 */
#include        <stdio.h> 
#include				<string.h>
#include        "lists.h"
#include        "expr.h" 
#include        "c.h" 
#include        "errors.h"

extern ENODE *block_rundown ;
extern int lastch;
extern enum e_sym lastst;
extern char lastid[];
extern TABLE lsyms;
extern int lineno;
extern SYM *currentfunc;
extern int skm_closepa[];
extern int incldepth;
extern short unalteredline[4096];
extern TABLE oldlsym;
extern int prm_cplusplus, prm_debug;
extern int prm_ansi;
extern int vtabhead;
extern int currentfile ;
extern FILELIST *lastinc ;
extern int dbgblocknum ;

SNODE *funcendstmt ;
int asmline;
int skm_openpa[] = { openpa, begin, semicolon, 0 };
int skm_semi[] = { semicolon, end, 0 };
long nextlabel, firstlabel;
int goodcode;


static char phibuf[4096];
static int lastlineno = 0;
static int switchbreak;

SNODE *cbautoinithead, *cbautoinittail,*cbautorundownhead,*cbautorundowntail;

void stmtini(void)
{
	lastlineno = 0;
  nextlabel = firstlabel = 1;
	goodcode = 0;
	asmline = FALSE;
}
/* scan an expression and determine if there are any pias */
TYP *doassign(ENODE **exp, int canerror, int *skm)
{
  TYP *tp;
  goodcode |= GF_INIF ;
  if( (tp =expression(exp,TRUE)) == 0 )  {
		if (canerror)
         generror(ERR_EXPREXPECT,0,skm); 
		*exp = 0;
  }
  goodcode &= ~GF_INIF ;
  return tp;
}
SNODE    *whilestmt(void) 
/* 
 *      whilestmt parses the c while statement. 
 */ 
{       SNODE    *snp; 
				int ogc = goodcode;
				goodcode |= GF_INLOOP;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_while; 
				snp->s1 = 0;
        getsym(); 
				needpunc(openpa,0);
				doassign(&snp->exp,TRUE,0);
				
        needpunc( closepa,skm_closepa );
				goodcode |= GF_CONTINUABLE | GF_BREAKABLE; 
        snp->s1 = cppblockedstatement(); 
				goodcode = ogc; 
        return snp; 
} 
  
SNODE    *dostmt(void) 
/* 
 *      dostmt parses the c do-while construct. 
 */ 
{       SNODE    *snp; 
				int ogc = goodcode,oswb = switchbreak;
				goodcode |= GF_INLOOP;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_do; 
        getsym(); 
				goodcode |= GF_CONTINUABLE | GF_BREAKABLE; 
        snp->s1 = cppblockedstatement(); 
				goodcode = ogc; 
        if( lastst != kw_while ) 
								gensymerror(ERR_IDENTEXPECT,lastid);
        else   
          getsym();
				needpunc(openpa,0); 
				doassign(&snp->exp,TRUE,0);
        needpunc(closepa,skm_closepa); 
        if( lastst != eof)
          needpunc( semicolon,0 );
				switchbreak = oswb;
        return snp; 
} 
  
SNODE    *forstmt(void) 
/*
 * Generate a block for a for statement
 */
{       SNODE    *snp; 
				int ogc = goodcode,oswb = switchbreak;
				int plussemi = 0;
				goodcode |= GF_INLOOP;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        getsym(); 
				snp->label = snp->exp = snp->s2 = 0;
        snp->stype = st_for; 
        if (needpunc(openpa,skm_closepa)) { 
#ifdef CPLUSPLUS
					/* CPLUSPLUS allows you to declare a variable here */
					if (castbegin(lastst)) {
						if (prm_cplusplus) {
							ENODE *exp=0,**next = &exp;
							cbautoinithead = cbautoinittail = 0;
							
							blockdecl();
							while (cbautoinithead) {
								if (*next) {
									*next = makenode(en_void,(*next),cbautoinithead->exp);
									next = &(*next)->v.p[1];
								}
								else *next = cbautoinithead->exp;
								cbautoinithead = cbautoinithead->next;
							}
							snp->label = exp;
							plussemi = 1;
						}
						else {
							generror(ERR_NODECLARE,0,0);
							while (castbegin(lastst))
								getsym();
							goto forjoin;
						}
					}
					else 
forjoin:
#endif
					{
						if( expression(&snp->label,TRUE) == 0 ) 
							snp->label = 0;
						plussemi = needpunc(semicolon,0);
					}
					if (plussemi) {
						doassign(&snp->exp,FALSE,0);
						if (needpunc(semicolon,0)) {
							if( expression(&snp->s2,TRUE) == 0 )  {
								snp->s2 = 0;
							}
	  				}
					}
        	needpunc(closepa,skm_closepa); 
				}
				goodcode |= GF_CONTINUABLE | GF_BREAKABLE; 
        snp->s1 = cppblockedstatement(); 
				goodcode = ogc; 
				switchbreak = oswb;
        return snp; 
} 
  
SNODE    *ifstmt(void) 
/* 
 *      ifstmt parses the c if statement and an else clause if 
 *      one is present. 
 */ 
{       SNODE    *snp;
				int ogc = goodcode; 
				int temp=0,temp1 = 0;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_if; 
        getsym();
				needpunc(openpa,0); 
				doassign(&snp->exp,TRUE,0);
        needpunc( closepa,skm_closepa ); 
        snp->s1 = cppblockedstatement(); 
				temp1 = goodcode & (GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO);
        if( lastst == kw_else ) { 
					temp = goodcode & (GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO);
					goodcode = ogc;
          getsym(); 
          snp->s2 = cppblockedstatement(); 
					temp = temp & goodcode;
        } 
        else 
          snp->s2 = 0; 
				goodcode = ogc | (temp & temp1);
        return snp; 
} 
  
SNODE    *casestmt(SNODE *lst, int size) 
/* 
 *      cases are returned as seperate statements. for normal 
 *      cases label is the case value and s2 is zero. for the 
 *      default case s2 is nonzero. 
 */ 
{       SNODE    *snp; 
        SNODE    *head=0, *tail; 
				long ssize;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        if( lastst == kw_case ) { 
                getsym(); 
                snp->s2 = 0;
                snp->stype = st_case;
                snp->label = (SNODE *)(ssize = intexpr(0));
								if (size == 1 && (ssize & 0xffffff00)
									|| size == 2 && (ssize & 0xffff0000)
									|| size == -1 && (ssize < -0x80 || ssize > 0x7f)
									|| size == -2 && (ssize < -0x8000  || ssize > 0x7fff))
										generror(ERR_LOSTCONVCASE,0,0);
        } 
        else if( lastst == kw_default) { 
								goodcode |= GF_DEF;
                getsym(); 
                snp->stype = st_case;
                snp->s2 = (SNODE *)1; 
                } 
        else    { 
                generror(ERR_NOCASE,0,0); 
                return 0; 
                } 
        if (!needpunc(colon,0))
					return snp;
        head = 0; 
				if (lst) {
					head = tail = lst;
					lst->next = 0;
				}
        while( lastst != end && lastst != eof &&
                lastst != kw_case && 
                lastst != kw_default ) { 
								if (goodcode & (GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO)) {
									if (lastst == id) {
                    while( isspace(lastch) ) 
                      getch(); 
										if (lastch != ':')
											generror(ERR_UNREACHABLE,0,0);
											
									}
									else
										generror(ERR_UNREACHABLE,0,0);
								}
#ifdef XXXXX
                        if (lastst == id && lastch == ':') {
                           if (head == 0)
                              head = tail = labelstmt(FALSE) ;
                           else
                              tail->next = labelstmt(FALSE) ;
                           while(tail && tail->next != 0 ) 
                              tail = tail->next; 
                           if (lastst == kw_case || lastst == kw_default || lastst == end || lastst == eof)
                              break ;
                        }
#endif
								goodcode &= ~(GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO);
                if( head == 0 ) 
                        head = tail = statement(); 
                else    { 
                        tail->next = statement(); 
                        } 
                while(tail && tail->next != 0 ) 
                  tail = tail->next; 
                }
				if (goodcode & GF_BREAK)
					goodcode &= ~GF_UNREACH;
        snp->s1 = head; 
        return snp; 
} 
  
int     checkcases(SNODE *head) 
/* 
 *      checkcases will check to see if any duplicate cases 
 *      exist in the case list pointed to by head. 
 */ 
{     
	SNODE	*top, *cur;
	top = head;
	while( top != 0 )
	{
		cur = top->next;
		while( cur != 0 )
		{
			if( (!cur->s2 && !top->s2 && cur->label == top->label)
				|| (cur->s2 && top->s2) )
			{
				generror(ERR_DUPCASE,(int)cur->label,0);
				return 1;
			}
			cur = cur->next;
		}
		top = top->next;
	}
	return 0;
} 
  
SNODE    *switchstmt(void) 
/*
 * Handle the SWITCH statement
 */
{       SNODE    *snp; 
        SNODE    *head, *tail;       
				int size = 0;
				TYP *tp;
				SNODE *lst = 0;
				int ogc = goodcode,oswb=switchbreak;
	TABLE oldoldlsym;
	switchbreak = 0;
#ifdef CPLUSPLUS
	if (prm_cplusplus) {
		oldoldlsym = oldlsym;
		oldlsym = lsyms;
	}
#endif
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_switch; 
        getsym(); 
        needpunc(openpa,0); 
				tp = doassign(&snp->exp,TRUE,0);
				size = natural_size(snp->exp);
				if (tp) {
               int type = tp->type ;
               if (type == bt_cond)
                  type = tp->btp->type ;
               switch  (type) {
						case bt_char:
						case bt_unsignedchar:
						case bt_short:
						case bt_unsignedshort:
						case bt_long:
						case bt_int:
						case bt_unsignedlong:
						case bt_unsigned:
						case bt_enum:
							break;
						default:
							generror(ERR_SWITCHINT,0,0);
					}
				}
        needpunc(closepa, skm_closepa); 
        needpunc(begin,0); 
        head = 0; 
				goodcode |= GF_UNREACH | GF_BREAKABLE;
				goodcode &= ~GF_DEF;
        while( lastst != end && lastst != eof) { 
								goodcode &= ~(GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO);
            if (lastst == id) {
               while (isspace(lastch))
                  getch() ;
					if (lastch == ':')
						lst = labelstmt(FALSE);
            }
                if( head == 0 ) 
                        head = tail = casestmt(lst,size); 
                else    { 
                        tail->next = casestmt(lst,size); 
                        if( tail->next != 0 ) 
                                tail = tail->next; 
                        } 
								lst = 0;
								if (tail)
                	tail->next = 0; 
                } 
				if (!switchbreak && goodcode & GF_RETURN) {
					if ((goodcode & GF_UNREACH)  && (goodcode & GF_DEF)) 
						ogc |= GF_RETURN;
				}
				goodcode = ogc;
        snp->s1 = head; 
        getsym(); 
        checkcases(head);
				switchbreak = oswb;
#ifdef CPLUSPLUS
	if (prm_cplusplus) {
		check_funcused(&oldlsym,&lsyms);
		gather_labels(&oldlsym,&lsyms);
		cseg();
		lsyms = oldlsym;
		oldlsym.head = oldoldlsym.head;
	}
#endif
        return snp; 
} 
  
SNODE    *retstmt(void) 
/*
 * Handle return 
 */
{       SNODE    *snp; 
				TYP *tp;
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_return; 
				snp->exp = 0;
        getsym(); 
				if (lastst == end || lastst == semicolon) {
               if (currentfunc->tp->btp->type != bt_void)
                  generror(ERR_FUNCRETVAL,0,0);
					needpunc(semicolon,0);
				}
				else {
					int ogc = goodcode;
					goodcode |= GF_SUPERAND;
        	tp = expression(&(snp->exp),TRUE);
					goodcode = ogc;
        	if( lastst != eof)
                needpunc( semicolon, 0 );
					if (tp->type == bt_void) {
						generror(ERR_NOVOIDRET,0,0);
					}
					else
                  if (currentfunc->tp->btp->type == bt_void)
                     generror(ERR_VOIDFUNCNOVALUE,0,0) ;
                  else
/*						if (tp->type == bt_pointer && tp->val_flag)
							generror(ERR_NOFUNCARRAY,0,0);
						else
*/						if (!checktype(currentfunc->tp->btp,tp,TRUE))
								if (!(isscalar(tp) && isscalar(currentfunc->tp->btp)))
									if (currentfunc->tp->btp->type != bt_pointer ||
											floatrecurse(snp->exp))
										generror(ERR_RETMISMATCH,0,0);
				}
        return snp; 
} 
  
SNODE    *breakstmt(void) 
/*
 * handle break
 */
{       SNODE    *snp; 
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_break; 
        getsym(); 
				if (!(goodcode & GF_BREAKABLE))
					generror(ERR_NOCONTINUE,0,0);
        if( lastst != eof)
                needpunc( semicolon,0 );
        return snp; 
} 
  
SNODE    *contstmt(void) 
/*
 * handle continue
 */
{       SNODE    *snp; 
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_continue; 
				if (!(goodcode & GF_CONTINUABLE))
					generror(ERR_NOCONTINUE,0,0);
        getsym();
        if( lastst != eof)
                needpunc( semicolon,0 );
        return snp;
}
SNODE *_genwordstmt(void)
/*
 * Insert data in the code stream
 */
{
				SNODE *snp;
				snp = xalloc(sizeof(SNODE));
				snp->next = 0;
				snp->stype = st__genword;
				snp->exp = 0;
				getsym();
				if (lastst != openpa) {
					generror(ERR_PUNCT,openpa,skm_semi);
					getsym();
					snp = 0;
				}
				else {
					getsym();
					snp->exp = (ENODE *) intexpr(0);
					if (lastst != closepa) {
						generror(ERR_PUNCT,closepa,skm_semi);
						snp = 0;
					}
					getsym();
				}
				if (lastst != eof)
					needpunc(semicolon,0);
				return(snp);
}
SNODE    *exprstmt(void) 
/* 
 *      exprstmt is called whenever a statement does not begin 
 *      with a keyword. the statement should be an expression. 
 */ 
{       SNODE    *snp; 
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_expr; 
				goodcode &= ~(GF_ASSIGN);
  			if( expression(&snp->exp,TRUE) == 0 )  {
    			generror(ERR_EXPREXPECT,0,skm_semi); 
					snp->exp = 0;
  			}
				if (!(goodcode & GF_ASSIGN))
					generror(ERR_CODENONE,0,0);
        if( lastst != eof)
                needpunc( semicolon,0 );
        return snp; 
} 
SNODE *snp_line(int tocode)
/*
 * construct a statement for the beginning of a new line
 */
{
	SNODE *snp3 = 0;
				if (lineno != lastlineno && lastst != semicolon && lastst != begin) {
					int i = 0,j,l=pstrlen(unalteredline);
					snp3 = xalloc(sizeof(SNODE));
					snp3->next = 0;
					snp3->stype = st_line;
					snp3->exp = (ENODE *)lineno;
					snp3->s1 = (SNODE *)currentfile ;
					snp3->next = 0;
					for (j = 0; j < l && iswhitespacechar(unalteredline[j]); j++) ;
					for (; j<l; j++)
						i+= installphichar(unalteredline[j],phibuf,i);
					if (phibuf[i-1] == '\n')
						i--;
					phibuf[i] = 0;
					if ((phibuf[i-1] & 0xf0) == 0x90)
						phibuf[i-1] = 0x90;
					snp3->label = (SNODE *)xalloc(i+1);
					strcpy(snp3->label, phibuf);
					lastlineno = lineno;
               if (tocode && currentfile)
						lastinc->hascode = TRUE ;
				}
	return snp3;
}
#ifdef CPLUSPLUS
void dodefaultinit(SYM *sp)
/*
 * Evalueate a C++ default clause
 */
{
	TYP *tp;
	ENODE *ep;
	if (lastst == assign) {
		if ((tp =autoasnop(&ep, sp)) == 0) {
	 		generror(ERR_EXPREXPECT,0,0);
			getsym();
		}
		else {
			ep = ep->v.p[1];
			if (sp->tp->type == bt_ref)
				if (ep->nodetype == en_refassign && (isintconst(ep->v.p[1]->nodetype) || isfloatconst(ep->v.p[1]->nodetype)))
					generror(ERR_REFLVALUE,0,0);
			sp->value.classdata.defalt = ep;
		}
	}
}
#endif
void doautoinit(SYM *sym)
/*
 * This is here rather than in init because autoinit is a type of 
 * statement
 */
{
#ifdef CPLUSPLUS
   if (prm_cplusplus && (sym->tp->type == bt_class || sym->tp->type == bt_struct)) {
#ifdef XXXXX
      SNODE *snp = 0, *snp1 ;
      ENODE *exp ;
      SYM *typesp = sym->tp->sp ;

//      if (lastst == openpa || lastst == assign) {
         snp = snp_line(TRUE) ;
			if (snp)
				if (cbautoinithead == 0)
					cbautoinithead = cbautoinittail = snp;
				else {
					cbautoinittail->next = snp;
					cbautoinittail= snp;
				}
         basedecl(&exp,sym);
         if (exp) {
            snp = xalloc(sizeof(SNODE));
            snp->next = 0;
            snp->stype = st_expr;
            snp->exp = exp ;
            if (snp) 
               if (cbautoinithead == 0)
                  cbautoinithead = cbautoinittail = snp;
               else {
                  cbautoinittail->next = snp;
                  cbautoinittail= snp;
               }
         }
//      }
      if (!(typesp->value.classdata.cppflags & PF_HASCONS) && typesp->value.classdata.baseclass->vtabsp) {
         ENODE *exp = makenode(en_nacon,typesp->value.classdata.baseclass->vtabsp,0) ;
         ENODE *exp1,*exp2,*exp3 ;
         CLASSLIST *l = typesp->value.classdata.baseclass ;
         if (sym->absflag)
            exp1 = makenode(en_absacon,sym,0);
         else if (sym->storage_class == sc_auto)
            exp1 = makenode(en_autocon,sym,0) ;
         else
            exp1 = makenode(en_nacon,sym,0) ;
         while (l) {
            if (l->isvtab) {
               exp3 = makenode(en_addstruc,exp1,makeintnode(en_icon,l->offset)) ;
               exp3 = makenode (en_l_ref,exp3,0) ;
               exp2 = makenode(en_addstruc,exp,makeintnode(en_icon,l->vtaboffs)) ;
               exp2 = makenode(en_assign,exp3,exp2) ;
               if (snp)
                  snp->exp = makenode(en_void, exp2,snp->exp) ; 
               else {
                  snp = xalloc(sizeof(SNODE));
                  snp->next = 0;
                  snp->stype = st_expr;
                  snp->exp = exp2 ;
                  if (cbautoinithead == 0)
                     cbautoinithead = cbautoinittail = snp;
                  else {
                     cbautoinittail->next = snp;
                     cbautoinittail= snp;
                  }
               }
            }
            l = l->link ;
         }
      }
#endif
	}
	else
#endif
		if (lastst == assign || prm_cplusplus && lastst == openpa) {
         SNODE *snp = snp_line(TRUE);
			int s = lastst ;
			if (snp) 
				if (cbautoinithead == 0)
					cbautoinithead = cbautoinittail = snp;
				else {
					cbautoinittail->next = snp;
					cbautoinittail= snp;
				}
			snp = xalloc(sizeof(SNODE));
			snp->next = 0;
			snp->stype = st_expr;
			if (autoasnop(&(snp->exp), sym) == 0) {
				generror(ERR_EXPREXPECT,0,0);
			}
			else {
				if (cbautoinithead == 0)
					cbautoinithead = cbautoinittail = snp;
				else {
					cbautoinittail->next = snp;
					cbautoinittail= snp;
				}
			}
			if (s == openpa)
				needpunc(closepa,0) ;
		}
}
		
SNODE    *compound(void) 
/* 
 * Process the body of a compound block.  Declarations are already
 * handled by now.
 * 
 */ 
{       SNODE    *head, *tail; 
        head = cbautoinithead;
				tail = cbautoinittail;
				goodcode &= ~(GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO);
        while( lastst != end  && lastst != eof) { 
								if (goodcode & (GF_RETURN | GF_BREAK | GF_CONTINUE | GF_GOTO)) 
									if (lastst == id) {
                    while( isspace(lastch) ) 
                      getch(); 
										if (lastch != ':')
											generror(ERR_UNREACHABLE,0,0);
											
									}
									else
										generror(ERR_UNREACHABLE,0,0);
								goodcode &= ~(GF_RETURN | GF_BREAK| GF_CONTINUE | GF_GOTO);
                if( head == 0 ) 
                        head = tail = statement(); 
                else    { 
                        tail->next = statement(); 
                        } 
								if (head)
                  while( tail->next != 0 ) 
                    tail = tail->next; 
								
                } 
            funcendstmt = snp_line(TRUE);
				if (lastst == eof)
					generror(ERR_PUNCT,end,0);
				else
        	getsym(); 

        return head; 
} 
  
SNODE    *labelstmt(int fetchnext) 
/* 
 *      labelstmt processes a label that appears before a 
 *      statement as a seperate statement. 
 */ 
{       SNODE    *snp; 
        SYM             *sp; 
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        snp->stype = st_label; 
					goodcode &= ~GF_UNREACH;
        if( (sp = search(lastid,&lsyms)) == 0 ) { 
                sp = xalloc(sizeof(SYM)); 
                sp->name = litlate(lastid); 
                sp->storage_class = sc_label; 
								sp->tp = xalloc(sizeof(TYP));
								sp->tp->type = bt_unsigned;
								sp->tp->uflags = 0;
								sp->tp->bits = sp->tp->startbit = -1;
                sp->value.i = nextlabel++; 
                insert(sp,&lsyms); 
                } 
        else    { 
                if( sp->storage_class != sc_ulabel ) 
                        gensymerror(ERR_DUPLABEL,sp->name); 
                else 
                        sp->storage_class = sc_label; 
                } 
        getsym();       /* get past id */ 
        needpunc(colon,0); 
        if( sp->storage_class == sc_label ) { 
                snp->label = (SNODE *)sp->value.i; 
                snp->next = 0; 
                        if (lastst != end && fetchnext && lastst != kw_case && lastst != kw_default)
									snp->next = statement();
                return snp; 
                } 
        return 0; 
} 
  
SNODE    *gotostmt(void) 
/* 
 *      gotostmt processes the goto statement and puts undefined 
 *      labels into the symbol table. 
 */ 
{       SNODE    *snp; 
        SYM             *sp; 
        getsym(); 
        if( lastst != id ) { 
                generror(ERR_IDEXPECT,0,0); 
                return 0; 
                } 
        snp = xalloc(sizeof(SNODE)); 
				snp->next = 0;
        if( (sp = search(lastid,&lsyms)) == 0 ) { 
                sp = xalloc(sizeof(SYM)); 
                sp->name = litlate(lastid); 
                sp->value.i = nextlabel++; 
                sp->storage_class = sc_ulabel; 
								sp->tp = xalloc(sizeof(TYP));
								sp->tp->bits = sp->tp->startbit = -1;
								sp->tp->type = bt_unsigned;
                insert(sp,&lsyms); 
                } 
				sp->tp->uflags = UF_USED;
        getsym();       /* get past label name */ 
        if( lastst != eof)
                needpunc( semicolon,0 );
        if( sp->storage_class != sc_label && sp->storage_class != sc_ulabel) 
                gensymerror( ERR_LABEL,sp->name); 
        else    { 
                snp->stype = st_goto; 
                snp->label = (SNODE *)sp->value.i; 
                snp->next = 0; 
                return snp; 
                } 
        return 0; 
} 

SNODE *deletestatement(void)
{
			SNODE *snp=0 ;
			getsym() ;
}
SNODE *asm_statement(int shortfin);
SNODE    *statement(void) 
/* 
 *      statement figures out which of the statement processors 
 *      should be called and transfers control to the proper 
 *      routine. 
 */ 
{       SNODE    *snp=0, *snp2, **psnp; 
            SNODE     *snp3=snp_line(TRUE);
            int done = FALSE ;

//        while (!done) {
//            done = TRUE ;
            switch( lastst ) { 
#ifndef ICODE
								case kw_asm:
												if (prm_ansi) {
													strcpy(lastid,"_asm");
													lastst = id;
													goto doid;
												}
												asmline = TRUE;
												getsym();
												if (lastst == begin) {
													getsym();
													snp = snp3;
													if (snp)
														psnp = &snp->next;
													else
														psnp = &snp;
													*psnp = 0;
													while (lastst != end && lastst != eof) {
														*psnp = asm_statement(TRUE);
														while (*psnp)
															psnp=&(*psnp)->next;
                                          *psnp = snp_line(TRUE);
														while (*psnp)
															psnp=&(*psnp)->next;
													}
													asmline = FALSE;
													if (lastst == end)
														getsym();
													return snp;
												}
												snp = asm_statement(FALSE);
												asmline = FALSE;
												break;
#endif
                case semicolon: 
                        getsym(); 
                        snp = 0; 
                        break; 
                case begin: 
                        {
                           int blocknum = dbgblocknum ;
                           getsym(); 
                           snp2 = compoundblock(); 
                                    snp = xalloc(sizeof(SNODE)) ;
                                    snp->next = 0 ;
                                    snp->exp = snp2 ;
                                    snp->stype = st_block ;
                                    snp->label = blocknum+1 ;
                                    break ;
                        }
                case kw_if: 
                        snp = ifstmt(); 
                        break; 
                case kw_while: 
                        snp = whilestmt(); 
												snp->lst = snp3;
												snp3 = 0;
                        break; 
                case kw_for: 
                        snp = forstmt(); 
												snp->lst = snp3;
												snp3 = 0;
                        break; 
                case kw_return: 
                        snp = retstmt(); 
												goodcode |= GF_RETURN;
                        break; 
                case kw_break: 
												goodcode |= GF_BREAK;
												switchbreak = 1;
                        snp = breakstmt(); 
                        break; 
                case kw_goto: 
												goodcode |= GF_GOTO;
                        snp = gotostmt(); 
                        break; 
                case kw_continue: 
												goodcode |= GF_CONTINUE;
                        snp = contstmt(); 
                        break; 
                case kw_do: 
                        snp = dostmt(); 
                        break; 
                case kw_switch: 
                        snp = switchstmt(); 
                        break; 
								case kw_else:
												generror(ERR_ELSE,0,0);
												getsym();
												break;
								case kw__genword:
												snp = _genwordstmt();
												break;
/*								case kw_delete:
												snp = deletestmt() ;
												break ;
*/
                case id: 
                default:
doid: /* FIXME - move up two lines */
#ifdef CPLUSPLUS
												if (castbegin(lastst)) {
													if (prm_cplusplus) {
														cbautoinithead = cbautoinittail = 0;
														blockdecl();
                                          snp = cbautoinithead;
													}
													else {
													  generror(ERR_NODECLARE,0,skm_semi);
													  snp = 0;
													}
												}
												else {
#endif
													if (lastst == id) {
                                          while( isspace(lastch) ) 
                                             getch(); 
                                          if( lastch == ':') 
                                             snp = labelstmt(TRUE); 
                                          else
															snp = exprstmt();
													} else
                                          snp = exprstmt();
												}
                        break; 
                } 
//        }
        if( snp != 0 ) {
								if (snp3) {
									snp3->next = snp;
									snp = snp3;
								}
				} 
        return snp; 
}
/* Handling for special C++ situations */
SNODE *cppblockedstatement(void)
{
	SNODE *snp;
	TABLE oldoldlsym;
	long oldlcauto;
	ENODE *obrd = block_rundown ;
	block_rundown = 0;
#ifdef CPLUSPLUS
	if (prm_cplusplus) {
		oldoldlsym = oldlsym;
		oldlsym = lsyms;
	}
#endif
	snp = statement();
#ifdef CPLUSPLUS
	if (prm_cplusplus) {
		addblocklist(lsyms.head) ;
		addrundown(snp) ;
		check_funcused(&oldlsym,&lsyms);
		gather_labels(&oldlsym,&lsyms);
		cseg();
		lsyms = oldlsym;
		oldlsym.head = oldoldlsym.head;
	}
#endif
	block_rundown = obrd ;
	return(snp);
}
 
