/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <time.h>
#include <libp.h>
#include <dpmi.h>
#include <llp.h>
#include <errno.h>

extern unsigned _linear;

void *_ll_malloc(size_t size)
{
	DPMI_MEM_HANDLE handle;
	ULONG address;
  if (dpmi_get_memory(&address, &handle, (size+sizeof(DPMI_MEM_HANDLE) + 4095) & -4096)) {
		errno = _dos_errno = ENOMEM;
		return 0;
	}
	address -= _linear;
	*(DPMI_MEM_HANDLE *)address = handle;
	return (void *) (address + sizeof(DPMI_MEM_HANDLE));
}

void _ll_free(void *block)
{
	DPMI_MEM_HANDLE handle;
	handle = *(((DPMI_MEM_HANDLE *) block) -1);
	dpmi_free_memory(handle);
}