/*  float.h

    Defines implementation specific macros for dealing with
    floating point.  We don't currently support long doubles.

*/

#ifndef __FLOAT_H
#define __FLOAT_H

#ifndef __DEFS_H__
#include <defs.h>
#endif


#define FLT_RADIX           2
#define FLT_ROUNDS          1
#define FLT_GUARD           1
#define FLT_NORMALIZE       1
#define FLT_EVAL_METHOD     -1

#define DBL_MANT_DIG        53
#define FLT_MANT_DIG        24
#define LDBL_MANT_DIG       64

#define DBL_DIG             15
#define FLT_DIG             6
#define LDBL_DIG            18

#define DECIMAL_DIG         18

#define DBL_EPSILON         0x1P-52
#define FLT_EPSILON         0x1P-23
#define LDBL_EPSILON        0x1P-63

/* smallest positive IEEE normal numbers */
#define DBL_MIN             0x1P-1021
#define FLT_MIN             0x1P-125F
#define LDBL_MIN            0x1P-16381

#define DBL_MAX             0x1PFFFFFFFFFFFFFP+1023
#define FLT_MAX             0x1PFFFFFEP+127
#define LDBL_MAX            0x1PFFFFFFFFFFFFFFFEP+16383

#define DBL_MAX_EXP         +1024
#define FLT_MAX_EXP         +128
#define LDBL_MAX_EXP        +16384

#define DBL_MAX_10_EXP      +308
#define FLT_MAX_10_EXP      +38
#define LDBL_MAX_10_EXP     +4932

#define DBL_MIN_10_EXP      -307
#define FLT_MIN_10_EXP      -37
#define LDBL_MIN_10_EXP     -4931

#define DBL_MIN_EXP         -1021
#define FLT_MIN_EXP         -125
#define LDBL_MIN_EXP        -16381

extern float         _huge_flt;
extern double        _huge_dble;
extern long double   _huge_ldble;
extern double   _tiny_ldble;

#ifdef __cplusplus
extern "C" {
#endif

unsigned int  _RTL_NORM _fpuclear(void);
unsigned int  _RTL_NORM _fpucontrol(unsigned int __newcw, unsigned int __mask);
void          _RTL_NORM _fpureset(void);
unsigned int  _RTL_NORM _fpustatus(void);

#ifdef __cplusplus
};
#endif

#endif