/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222

**********************************************************************

Profile.c is a low level interface to the registry.  Originally it worked
with INI files, hence the name.

**********************************************************************
*/
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "header.h"
#include "dir.h"
#ifdef PROFILE
static char szProfileName[] = "ccide.ini" ;
static char szProfileClass[] = "Defaults" ;
#else
static char RegistryKey[] = "Software\\LADSoft\\CC386\\CCIDE" ;
#endif


void StringToProfile(char *name, char *string) 
{
#ifdef PROFILE
	WritePrivateProfileString(szProfileClass,key,string,szProfileName) ;
#else
   HKEY key ;
   DWORD disp ;
   if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,RegistryKey,0,0,
         0,KEY_ALL_ACCESS,0,&key,&disp) == ERROR_SUCCESS) {
      RegSetValueEx(key,name,0,REG_SZ,string,strlen(string)) ;
      RegCloseKey(key) ;
   }
#endif
}
char * ProfileToString(char *name,char *def)
{
   static char buf[512] ;
#ifdef PROFILE
	GetPrivateProfileString(szProfileClass, key,def,buf,256, szProfileName) ;
#else
   HKEY key ;
   int disp ;
   int type, datalen=256 ;
   if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,RegistryKey,0,0,
         0,KEY_ALL_ACCESS,0,&key,&disp) == ERROR_SUCCESS) {
      if (RegQueryValueEx(key,name,NULL,&type,buf,&datalen)  != ERROR_SUCCESS) 
         strcpy(buf,def) ;
      RegCloseKey(key) ;
   }
#endif
	return buf ;

}
void IntToProfile(char *key, int value)
{
	char buf[256] ;
	sprintf(buf,"%d",value);
	StringToProfile(key,buf) ;
}
int ProfileToInt(char *key, int def)
{
   int val ;
   char vvv[256] ;
   char *buf ;
   sprintf(vvv,"%d",def) ;
   buf = ProfileToString(key,vvv) ;
   sscanf(buf,"%d",&val) ;
   return val ;
}