//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "PreviewFrm.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "PtblRV"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
bool TForm1::IsEmpty(TCustomRichViewEdit* rve)
{
  return rve->ItemCount==0 ||
    (rve->ItemCount==1 && rve->GetItemStyle(0)>=0 && rve->GetItemText(0)=="");
}
//---------------------------------------------------------------------------
void TForm1::PreparePrinting()
{
  RVPrint1->AssignSource(RichViewEdit1);
  if (!IsEmpty(RichViewEdit2))
  {
    if (StrToIntDef(txtHeader->Text,-1)<0)
      txtHeader->Text = "10";
    RVPrint1->SetHeader(RichViewEdit2->RVData);
  }
  else
    RVPrint1->SetHeader(NULL);
  if (!IsEmpty(RichViewEdit3))
  {
    if (StrToIntDef(txtFooter->Text,-1)<0)
      txtFooter->Text = "10";
    RVPrint1->SetFooter(RichViewEdit3->RVData);
  }
  else
    RVPrint1->SetFooter(NULL);
  RVPrint1->LeftMarginMM   = StrToIntDef(txtLeft->Text,0);
  RVPrint1->RightMarginMM  = StrToIntDef(txtRight->Text,0);
  RVPrint1->TopMarginMM    = StrToIntDef(txtTop->Text,0);
  RVPrint1->BottomMarginMM = StrToIntDef(txtBottom->Text,0);
  RVPrint1->HeaderYMM      = StrToIntDef(txtHeader->Text,0);
  RVPrint1->FooterYMM      = StrToIntDef(txtFooter->Text,0);
  RVPrint1->FormatPages(TRVDisplayOptions());
}
//---------------------------------------------------------------------------
void __fastcall TForm1::New1Click(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit2->Clear();
  RichViewEdit3->Clear();
  RichViewEdit1->DeleteUnusedStyles(true,true,true);
  RichViewEdit2->DeleteUnusedStyles(true,true,true);
  RichViewEdit3->DeleteUnusedStyles(true,true,true);
  RichViewEdit1->Format();
  RichViewEdit2->Format();
  RichViewEdit3->Format();
}
//---------------------------------------------------------------------------
void TForm1::OpenFile(const AnsiString FileName)
{
  RichViewEdit1->Clear();
  RichViewEdit2->Clear();
  RichViewEdit3->Clear();
  RichViewEdit1->DeleteUnusedStyles(true,true,true);
  RichViewEdit2->DeleteUnusedStyles(true,true,true);
  RichViewEdit3->DeleteUnusedStyles(true,true,true);
  RichViewEdit1->RTFReadProperties->SetHeader(RichViewEdit2->RVData);
  RichViewEdit1->RTFReadProperties->SetFooter(RichViewEdit3->RVData);
  RichViewEdit1->LoadRTF(FileName);
  RichViewEdit1->Format();
  RichViewEdit2->Format();
  RichViewEdit3->Format();
  txtHeader->Text = IntToStr(RichViewEdit1->RTFReadProperties->HeaderYMM);
  txtFooter->Text = IntToStr(RichViewEdit1->RTFReadProperties->FooterYMM);
}
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  OpenFile(ExtractFilePath(Application->ExeName)+"doc.rtf");	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Open1Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
    OpenFile(OpenDialog1->FileName);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PrintPreview1Click(TObject *Sender)
{
  PreparePrinting();
  TfrmPreview* frm = new TfrmPreview(Application);
  frm->rvpp->RVPrint = RVPrint1;
  frm->Button1Click(NULL);
  frm->ShowModal();
  delete frm;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Print1Click(TObject *Sender)
{
#if __BORLANDC__ > 0x520
  bool PrintIt = psd->Execute();
#else
  bool PrintIt = true;
#endif
  if (PrintIt)
  {
    RVPrint1->AssignSource(RichViewEdit1);
    RVPrint1->FormatPages(TRVDisplayOptions());
    if (RVPrint1->PagesCount>0)
      RVPrint1->Print("RichView Edit Demo",1,false);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------